/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.entity.child;

import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandResultMessage;
import org.axonframework.common.BuilderUtils;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.messaging.MessageStream;
import org.axonframework.messaging.QualifiedName;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.modelling.entity.ChildEntityNotFoundException;
import org.axonframework.modelling.entity.EntityMetamodel;
import org.axonframework.modelling.entity.child.CommandTargetResolver;
import org.axonframework.modelling.entity.child.EntityChildMetamodel;
import org.axonframework.modelling.entity.child.EventTargetMatcher;

public abstract class AbstractEntityChildMetamodel<C, P>
implements EntityChildMetamodel<C, P> {
    protected final EntityMetamodel<C> metamodel;
    protected final CommandTargetResolver<C> commandTargetResolver;
    protected final EventTargetMatcher<C> eventTargetMatcher;

    protected AbstractEntityChildMetamodel(@Nonnull EntityMetamodel<C> metamodel, @Nonnull CommandTargetResolver<C> commandTargetResolver, @Nonnull EventTargetMatcher<C> eventTargetMatcher) {
        this.metamodel = Objects.requireNonNull(metamodel, "The metamodel may not be null.");
        this.commandTargetResolver = Objects.requireNonNull(commandTargetResolver, "The commandTargetResolver may not be null.");
        this.eventTargetMatcher = Objects.requireNonNull(eventTargetMatcher, "The eventTargetMatcher may not be null.");
    }

    @Override
    @Nonnull
    public Set<QualifiedName> supportedCommands() {
        return this.metamodel.supportedCommands();
    }

    @Override
    public boolean canHandle(@Nonnull CommandMessage message, @Nonnull P parentEntity, @Nonnull ProcessingContext context) {
        if (!this.supportedCommands().contains(message.type().qualifiedName())) {
            return false;
        }
        List<C> childEntities = this.getChildEntities(parentEntity);
        if (childEntities.isEmpty()) {
            return false;
        }
        return this.commandTargetResolver.getTargetChildEntity(childEntities, message, context) != null;
    }

    @Override
    @Nonnull
    public MessageStream.Single<CommandResultMessage> handle(@Nonnull CommandMessage message, @Nonnull P parentEntity, @Nonnull ProcessingContext context) {
        List<C> childEntities = this.getChildEntities(parentEntity);
        C targetChildEntity = this.commandTargetResolver.getTargetChildEntity(childEntities, message, context);
        if (targetChildEntity == null) {
            return MessageStream.failed((Throwable)new ChildEntityNotFoundException(message, parentEntity));
        }
        return this.metamodel.handleInstance(message, targetChildEntity, context);
    }

    protected abstract List<C> getChildEntities(P var1);

    @Override
    public P evolve(@Nonnull P entity, @Nonnull EventMessage event, @Nonnull ProcessingContext context) {
        AtomicBoolean evolvedChildEntity = new AtomicBoolean(false);
        List evolvedEntities = this.getChildEntities(entity).stream().map(child -> {
            if (this.eventTargetMatcher.matches(child, event, context)) {
                evolvedChildEntity.set(true);
                return this.metamodel.evolve(child, event, context);
            }
            return child;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (!evolvedChildEntity.get()) {
            return entity;
        }
        return this.applyEvolvedChildEntities(entity, evolvedEntities);
    }

    protected abstract P applyEvolvedChildEntities(P var1, List<C> var2);

    @Override
    @Nonnull
    public Class<C> entityType() {
        return this.metamodel.entityType();
    }

    protected static abstract class Builder<C, P, R extends Builder<C, P, R>> {
        protected final EntityMetamodel<C> metamodel;
        protected CommandTargetResolver<C> commandTargetResolver;
        protected EventTargetMatcher<C> eventTargetMatcher;

        protected Builder(@Nonnull Class<P> parentClass, @Nonnull EntityMetamodel<C> metamodel) {
            Objects.requireNonNull(parentClass, "The parentClass may not be null.");
            this.metamodel = Objects.requireNonNull(metamodel, "The metamodel may not be null.");
        }

        public R commandTargetResolver(@Nonnull CommandTargetResolver<C> commandTargetResolver) {
            this.commandTargetResolver = Objects.requireNonNull(commandTargetResolver, "The commandTargetResolver may not be null.");
            return (R)this;
        }

        protected void validate() {
            BuilderUtils.assertNonNull(this.commandTargetResolver, (String)"The commandTargetResolver must be set before building the metamodel.");
            BuilderUtils.assertNonNull(this.eventTargetMatcher, (String)"The eventTargetMatcher must be set before building the metamodel.");
        }

        public R eventTargetMatcher(@Nonnull EventTargetMatcher<C> eventTargetMatcher) {
            this.eventTargetMatcher = Objects.requireNonNull(eventTargetMatcher, "The eventTargetMatcher may not be null.");
            return (R)this;
        }
    }
}

