/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.mongo.eventsourcing.eventstore;

import com.mongodb.DuplicateKeyException;
import com.mongodb.MongoBulkWriteException;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.axonframework.common.jdbc.PersistenceExceptionResolver;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventsourcing.DomainEventMessage;
import org.axonframework.eventsourcing.eventstore.BatchingEventStorageEngine;
import org.axonframework.eventsourcing.eventstore.DomainEventData;
import org.axonframework.eventsourcing.eventstore.TrackedEventData;
import org.axonframework.eventsourcing.eventstore.TrackingToken;
import org.axonframework.mongo.MongoTemplate;
import org.axonframework.mongo.eventsourcing.eventstore.MongoTrackingToken;
import org.axonframework.mongo.eventsourcing.eventstore.StorageStrategy;
import org.axonframework.mongo.eventsourcing.eventstore.documentperevent.DocumentPerEventStorageStrategy;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.upcasting.event.EventUpcaster;

public class MongoEventStorageEngine
extends BatchingEventStorageEngine {
    private final MongoTemplate template;
    private final StorageStrategy storageStrategy;

    public MongoEventStorageEngine(MongoTemplate template) {
        this(null, null, template, new DocumentPerEventStorageStrategy());
    }

    public MongoEventStorageEngine(Serializer serializer, EventUpcaster upcasterChain, MongoTemplate template, StorageStrategy storageStrategy) {
        this(serializer, upcasterChain, serializer, template, storageStrategy);
    }

    public MongoEventStorageEngine(Serializer snapshotSerializer, EventUpcaster upcasterChain, Serializer eventSerializer, MongoTemplate template, StorageStrategy storageStrategy) {
        this(snapshotSerializer, upcasterChain, eventSerializer, null, template, storageStrategy);
    }

    public MongoEventStorageEngine(Serializer serializer, EventUpcaster upcasterChain, Integer batchSize, MongoTemplate template, StorageStrategy storageStrategy) {
        this(serializer, upcasterChain, serializer, batchSize, template, storageStrategy);
    }

    public MongoEventStorageEngine(Serializer snapshotSerializer, EventUpcaster upcasterChain, Serializer eventSerializer, Integer batchSize, MongoTemplate template, StorageStrategy storageStrategy) {
        this(snapshotSerializer, upcasterChain, MongoEventStorageEngine::isDuplicateKeyException, eventSerializer, batchSize, template, storageStrategy);
    }

    public MongoEventStorageEngine(Serializer snapshotSerializer, EventUpcaster upcasterChain, PersistenceExceptionResolver persistenceExceptionResolver, Serializer eventSerializer, Integer batchSize, MongoTemplate template, StorageStrategy storageStrategy) {
        super(snapshotSerializer, upcasterChain, persistenceExceptionResolver, eventSerializer, batchSize);
        this.template = template;
        this.storageStrategy = storageStrategy;
        this.ensureIndexes();
    }

    private static boolean isDuplicateKeyException(Exception exception) {
        return exception instanceof DuplicateKeyException || exception instanceof MongoBulkWriteException && ((MongoBulkWriteException)exception).getWriteErrors().stream().anyMatch(e -> e.getCode() == 11000);
    }

    @Deprecated
    public void ensureIndexes() {
        this.storageStrategy.ensureIndexes(this.template.eventCollection(), this.template.snapshotCollection());
    }

    protected void appendEvents(List<? extends EventMessage<?>> events, Serializer serializer) {
        if (!events.isEmpty()) {
            try {
                this.storageStrategy.appendEvents(this.template.eventCollection(), events, serializer);
            }
            catch (Exception e) {
                this.handlePersistenceException(e, events.get(0));
            }
        }
    }

    protected void storeSnapshot(DomainEventMessage<?> snapshot, Serializer serializer) {
        try {
            this.storageStrategy.appendSnapshot(this.template.snapshotCollection(), snapshot, serializer);
            this.storageStrategy.deleteSnapshots(this.template.snapshotCollection(), snapshot.getAggregateIdentifier(), snapshot.getSequenceNumber());
        }
        catch (Exception e) {
            this.handlePersistenceException(e, (EventMessage)snapshot);
        }
    }

    protected Optional<? extends DomainEventData<?>> readSnapshotData(String aggregateIdentifier) {
        return this.storageStrategy.findLastSnapshot(this.template.snapshotCollection(), aggregateIdentifier);
    }

    protected List<? extends DomainEventData<?>> fetchDomainEvents(String aggregateIdentifier, long firstSequenceNumber, int batchSize) {
        return this.storageStrategy.findDomainEvents(this.template.eventCollection(), aggregateIdentifier, firstSequenceNumber, batchSize);
    }

    protected List<? extends TrackedEventData<?>> fetchTrackedEvents(TrackingToken lastToken, int batchSize) {
        return this.storageStrategy.findTrackedEvents(this.template.eventCollection(), lastToken, batchSize);
    }

    public Optional<Long> lastSequenceNumberFor(String aggregateIdentifier) {
        return this.storageStrategy.lastSequenceNumberFor(this.template.eventCollection(), aggregateIdentifier);
    }

    public TrackingToken createTailToken() {
        return this.storageStrategy.createTailToken(this.template.eventCollection());
    }

    public TrackingToken createHeadToken() {
        return this.createTokenAt(Instant.now());
    }

    public TrackingToken createTokenAt(Instant dateTime) {
        return MongoTrackingToken.of(dateTime, Collections.emptyMap());
    }
}

