/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.mongo.eventsourcing.eventstore.documentpercommit;

public class CommitEntryConfiguration {
    private final String firstTimestampProperty;
    private final String lastTimestampProperty;
    private final String firstSequenceNumberProperty;
    private final String lastSequenceNumberProperty;
    private final String eventsProperty;

    public static CommitEntryConfiguration getDefault() {
        return CommitEntryConfiguration.builder().build();
    }

    private CommitEntryConfiguration(Builder builder) {
        this.firstTimestampProperty = builder.firstTimestampProperty;
        this.lastTimestampProperty = builder.lastTimestampProperty;
        this.firstSequenceNumberProperty = builder.firstSequenceNumberProperty;
        this.lastSequenceNumberProperty = builder.lastSequenceNumberProperty;
        this.eventsProperty = builder.eventsProperty;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String firstTimestampProperty() {
        return this.firstTimestampProperty;
    }

    public String lastTimestampProperty() {
        return this.lastTimestampProperty;
    }

    public String firstSequenceNumberProperty() {
        return this.firstSequenceNumberProperty;
    }

    public String lastSequenceNumberProperty() {
        return this.lastSequenceNumberProperty;
    }

    public String eventsProperty() {
        return this.eventsProperty;
    }

    private static class Builder {
        private String firstTimestampProperty = "firstTimestamp";
        private String lastTimestampProperty = "lastTimestamp";
        private String firstSequenceNumberProperty = "firstSequenceNumber";
        private String lastSequenceNumberProperty = "lastSequenceNumber";
        private String eventsProperty = "events";

        private Builder() {
        }

        public Builder withFirstTimestampProperty(String firstTimestampProperty) {
            this.firstTimestampProperty = firstTimestampProperty;
            return this;
        }

        public Builder withLastTimestampProperty(String lastTimestampProperty) {
            this.lastTimestampProperty = lastTimestampProperty;
            return this;
        }

        public Builder withFirstSequenceNumberProperty(String firstSequenceNumberProperty) {
            this.firstSequenceNumberProperty = firstSequenceNumberProperty;
            return this;
        }

        public Builder withLastSequenceNumberProperty(String lastSequenceNumberProperty) {
            this.lastSequenceNumberProperty = lastSequenceNumberProperty;
            return this;
        }

        public Builder withEventsProperty(String eventsProperty) {
            this.eventsProperty = eventsProperty;
            return this;
        }

        public CommitEntryConfiguration build() {
            return new CommitEntryConfiguration(this);
        }
    }
}

