/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.mongo.eventsourcing.eventstore.documentpercommit;

import com.mongodb.BasicDBObject;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.IndexOptions;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventsourcing.DomainEventMessage;
import org.axonframework.eventsourcing.eventstore.DomainEventData;
import org.axonframework.eventsourcing.eventstore.EventUtils;
import org.axonframework.mongo.eventsourcing.eventstore.AbstractMongoEventStorageStrategy;
import org.axonframework.mongo.eventsourcing.eventstore.documentpercommit.CommitEntry;
import org.axonframework.mongo.eventsourcing.eventstore.documentpercommit.CommitEntryConfiguration;
import org.axonframework.mongo.eventsourcing.eventstore.documentperevent.EventEntryConfiguration;
import org.axonframework.serialization.Serializer;
import org.bson.Document;
import org.bson.conversions.Bson;

public class DocumentPerCommitStorageStrategy
extends AbstractMongoEventStorageStrategy {
    private final CommitEntryConfiguration commitEntryConfiguration;

    public DocumentPerCommitStorageStrategy() {
        this(CommitEntryConfiguration.getDefault());
    }

    public DocumentPerCommitStorageStrategy(CommitEntryConfiguration commitEntryConfiguration) {
        this(EventEntryConfiguration.getDefault(), commitEntryConfiguration, null);
    }

    public DocumentPerCommitStorageStrategy(EventEntryConfiguration eventConfiguration, CommitEntryConfiguration commitEntryConfiguration, Duration lookBackTime) {
        super(eventConfiguration, lookBackTime);
        this.commitEntryConfiguration = commitEntryConfiguration;
    }

    @Override
    protected Stream<Document> createEventDocuments(List<? extends EventMessage<?>> events, Serializer serializer) {
        return Stream.of(new CommitEntry(events.stream().map(EventUtils::asDomainEventMessage).collect(Collectors.toList()), serializer).asDocument(this.commitEntryConfiguration, this.eventConfiguration()));
    }

    @Override
    protected Document createSnapshotDocument(DomainEventMessage<?> snapshot, Serializer serializer) {
        return new CommitEntry(Collections.singletonList(snapshot), serializer).asDocument(this.commitEntryConfiguration, this.eventConfiguration());
    }

    @Override
    protected Stream<? extends DomainEventData<?>> extractEvents(Document object) {
        return Stream.of(new CommitEntry(object, this.commitEntryConfiguration, this.eventConfiguration()).getEvents());
    }

    @Override
    protected DomainEventData<?> extractSnapshot(Document object) {
        return new CommitEntry(object, this.commitEntryConfiguration, this.eventConfiguration()).getEvents()[0];
    }

    @Override
    protected Long extractHighestSequenceNumber(Document document) {
        return (Long)document.get((Object)this.commitEntryConfiguration.lastSequenceNumberProperty());
    }

    @Override
    public void ensureIndexes(MongoCollection<Document> eventsCollection, MongoCollection<Document> snapshotsCollection) {
        super.ensureIndexes(eventsCollection, snapshotsCollection);
        eventsCollection.createIndex((Bson)new BasicDBObject(this.eventConfiguration().aggregateIdentifierProperty(), (Object)1).append(this.commitEntryConfiguration.firstSequenceNumberProperty(), (Object)1), new IndexOptions().unique(true).name("uniqueAggregateStartIndex"));
    }
}

