/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.mongo.eventsourcing.eventstore.documentperevent;

import java.time.Duration;
import java.util.List;
import java.util.stream.Stream;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventsourcing.DomainEventMessage;
import org.axonframework.eventsourcing.eventstore.DomainEventData;
import org.axonframework.eventsourcing.eventstore.EventUtils;
import org.axonframework.mongo.eventsourcing.eventstore.AbstractMongoEventStorageStrategy;
import org.axonframework.mongo.eventsourcing.eventstore.documentperevent.EventEntry;
import org.axonframework.mongo.eventsourcing.eventstore.documentperevent.EventEntryConfiguration;
import org.axonframework.serialization.Serializer;
import org.bson.Document;

public class DocumentPerEventStorageStrategy
extends AbstractMongoEventStorageStrategy {
    public DocumentPerEventStorageStrategy() {
        this(EventEntryConfiguration.getDefault(), null);
    }

    public DocumentPerEventStorageStrategy(EventEntryConfiguration eventConfiguration, Duration lookBackTime) {
        super(eventConfiguration, lookBackTime);
    }

    @Override
    protected Stream<Document> createEventDocuments(List<? extends EventMessage<?>> events, Serializer serializer) {
        return events.stream().map(EventUtils::asDomainEventMessage).map(event -> new EventEntry((DomainEventMessage<?>)event, serializer)).map(entry -> entry.asDocument(this.eventConfiguration()));
    }

    @Override
    protected Document createSnapshotDocument(DomainEventMessage<?> snapshot, Serializer serializer) {
        return new EventEntry(snapshot, serializer).asDocument(this.eventConfiguration());
    }

    @Override
    protected Stream<? extends DomainEventData<?>> extractEvents(Document object) {
        return Stream.of(this.extractEvent(object));
    }

    @Override
    protected DomainEventData<?> extractSnapshot(Document object) {
        return this.extractEvent(object);
    }

    private EventEntry extractEvent(Document object) {
        return new EventEntry(object, this.eventConfiguration());
    }
}

