/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.event.axon;

import org.axonframework.axonserver.connector.AxonServerConfiguration;
import org.axonframework.axonserver.connector.PlatformConnectionManager;
import org.axonframework.axonserver.connector.processor.EventProcessorControlService;
import org.axonframework.axonserver.connector.processor.EventProcessorController;
import org.axonframework.axonserver.connector.processor.grpc.GrpcEventProcessorInfoSource;
import org.axonframework.axonserver.connector.processor.schedule.ScheduledEventProcessorInfoSource;
import org.axonframework.config.Configuration;
import org.axonframework.config.EventHandlingConfiguration;
import org.axonframework.config.ModuleConfiguration;

public class EventProcessorInfoConfiguration
implements ModuleConfiguration {
    private final EventProcessorControlService eventProcessorControlService;
    private final ScheduledEventProcessorInfoSource processorInfoSource;

    public EventProcessorInfoConfiguration(EventHandlingConfiguration eventHandlinConf, PlatformConnectionManager connectionManager, AxonServerConfiguration configuration) {
        EventProcessorController controller = new EventProcessorController(eventHandlinConf);
        GrpcEventProcessorInfoSource infoSource = new GrpcEventProcessorInfoSource(eventHandlinConf, connectionManager);
        this.eventProcessorControlService = new EventProcessorControlService(connectionManager, controller);
        this.processorInfoSource = new ScheduledEventProcessorInfoSource(configuration.getProcessorsNotificationInitialDelay(), configuration.getProcessorsNotificationRate(), infoSource);
    }

    public void initialize(Configuration config) {
    }

    public void start() {
        this.processorInfoSource.start();
        this.eventProcessorControlService.start();
    }

    public void shutdown() {
        this.processorInfoSource.shutdown();
    }
}

