/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector;

import io.axoniq.axonserver.grpc.control.NodeInfo;
import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.axonframework.axonserver.connector.event.util.EventCipher;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="axon.axonserver")
public class AxonServerConfiguration {
    private static final int DEFAULT_GRPC_PORT = 8124;
    private static final String DEFAULT_SERVERS = "localhost";
    private String servers = "localhost";
    private String clientId = ManagementFactory.getRuntimeMXBean().getName();
    private String componentName;
    private String token;
    private String context;
    private String certFile;
    private boolean sslEnabled;
    private Integer initialNrOfPermits = 1000;
    private Integer nrOfNewPermits = 500;
    private Integer newPermitsThreshold = 500;
    private int commandThreads = 10;
    private int queryThreads = 10;
    private int processorsNotificationRate = 500;
    private int processorsNotificationInitialDelay = 5000;
    private EventCipher eventCipher = new EventCipher();
    private long keepAliveTimeout = 5000L;
    private long keepAliveTime = 0L;
    private int snapshotPrefetch = 1;
    private boolean suppressDownloadMessage = false;
    private int maxMessageSize = 0;

    public String getServers() {
        return this.servers;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getComponentName() {
        return this.componentName == null ? System.getProperty("axon.application.name", "Unnamed-" + this.clientId) : this.componentName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public void setServers(String routingServers) {
        this.servers = routingServers;
        this.suppressDownloadMessage = true;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getCertFile() {
        return this.certFile;
    }

    public void setCertFile(String certFile) {
        this.certFile = certFile;
    }

    public boolean isSslEnabled() {
        return this.sslEnabled;
    }

    public void setSslEnabled(boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
    }

    public Integer getInitialNrOfPermits() {
        return this.initialNrOfPermits;
    }

    public void setInitialNrOfPermits(Integer initialNrOfPermits) {
        this.initialNrOfPermits = initialNrOfPermits;
    }

    public Integer getNrOfNewPermits() {
        return this.nrOfNewPermits;
    }

    public void setNrOfNewPermits(Integer nrOfNewPermits) {
        this.nrOfNewPermits = nrOfNewPermits;
    }

    public Integer getNewPermitsThreshold() {
        return this.newPermitsThreshold;
    }

    public void setNewPermitsThreshold(Integer newPermitsThreshold) {
        this.newPermitsThreshold = newPermitsThreshold;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public List<NodeInfo> routingServers() {
        String[] serverArr = this.servers.split(",");
        return Arrays.stream(serverArr).map(server -> {
            String[] s = server.trim().split(":");
            if (s.length > 1) {
                return NodeInfo.newBuilder().setHostName(s[0]).setGrpcPort(Integer.valueOf(s[1])).build();
            }
            return NodeInfo.newBuilder().setHostName(s[0]).setGrpcPort(8124).build();
        }).collect(Collectors.toList());
    }

    public EventCipher getEventCipher() {
        return this.eventCipher;
    }

    private void setEventSecretKey(String key) {
        if (key != null && key.length() > 0) {
            this.eventCipher = new EventCipher(key.getBytes(StandardCharsets.US_ASCII));
        }
    }

    public Integer getCommandThreads() {
        return this.commandThreads;
    }

    public void setCommandThreads(Integer commandThreads) {
        this.commandThreads = commandThreads;
    }

    public int getQueryThreads() {
        return this.queryThreads;
    }

    public void setQueryThreads(int queryThreads) {
        this.queryThreads = queryThreads;
    }

    public int getProcessorsNotificationRate() {
        return this.processorsNotificationRate;
    }

    public void setProcessorsNotificationRate(int processorsNotificationRate) {
        this.processorsNotificationRate = processorsNotificationRate;
    }

    public int getProcessorsNotificationInitialDelay() {
        return this.processorsNotificationInitialDelay;
    }

    public void setProcessorsNotificationInitialDelay(int processorsNotificationInitialDelay) {
        this.processorsNotificationInitialDelay = processorsNotificationInitialDelay;
    }

    public long getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public void setKeepAliveTimeout(long keepAliveTimeout) {
        this.keepAliveTimeout = keepAliveTimeout;
    }

    public void setCommandThreads(int commandThreads) {
        this.commandThreads = commandThreads;
    }

    public long getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public void setKeepAliveTime(long keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    public void setSuppressDownloadMessage(boolean suppressDownloadMessage) {
        this.suppressDownloadMessage = suppressDownloadMessage;
    }

    public boolean getSuppressDownloadMessage() {
        return this.suppressDownloadMessage;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void setMaxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    public int getSnapshotPrefetch() {
        return this.snapshotPrefetch;
    }

    public void setSnapshotPrefetch(int snapshotPrefetch) {
        this.snapshotPrefetch = snapshotPrefetch;
    }

    public static Builder builder() {
        Builder builder = new Builder();
        if (Boolean.getBoolean("axon.axonserver.suppressDownloadMessage")) {
            builder.suppressDownloadMessage();
        }
        return builder;
    }

    public static class Builder {
        private AxonServerConfiguration instance = new AxonServerConfiguration();

        public Builder() {
            this.instance.initialNrOfPermits = 1000;
            this.instance.nrOfNewPermits = 500;
            this.instance.newPermitsThreshold = 500;
        }

        public Builder ssl(String certFile) {
            this.instance.certFile = certFile;
            this.instance.sslEnabled = true;
            return this;
        }

        public Builder token(String token) {
            this.instance.token = token;
            return this;
        }

        public Builder context(String context) {
            this.instance.context = context;
            return this;
        }

        public Builder flowControl(int initialNrOfPermits, int nrOfNewPermits, int newPermitsThreshold) {
            this.instance.initialNrOfPermits = initialNrOfPermits;
            this.instance.nrOfNewPermits = nrOfNewPermits;
            this.instance.newPermitsThreshold = newPermitsThreshold;
            return this;
        }

        public Builder setEventSecretKey(String key) {
            this.instance.setEventSecretKey(key);
            return this;
        }

        public Builder eventCipher(EventCipher eventCipher) {
            this.instance.eventCipher = eventCipher;
            return this;
        }

        public Builder maxMessageSize(int maxMessageSize) {
            this.instance.maxMessageSize = maxMessageSize;
            return this;
        }

        public Builder snapshotPrefetch(int snapshotPrefetch) {
            this.instance.snapshotPrefetch = snapshotPrefetch;
            return this;
        }

        public AxonServerConfiguration build() {
            return this.instance;
        }

        public Builder servers(String servers) {
            this.instance.setServers(servers);
            return this;
        }

        public Builder suppressDownloadMessage() {
            this.instance.setSuppressDownloadMessage(true);
            return this;
        }

        public Builder componentName(String componentName) {
            this.instance.setComponentName(componentName);
            return this;
        }

        public Builder clientId(String clientId) {
            this.instance.setClientId(clientId);
            return this;
        }
    }
}

