/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.processor;

import io.axoniq.axonserver.grpc.control.PauseEventProcessor;
import io.axoniq.axonserver.grpc.control.PlatformOutboundInstruction;
import io.axoniq.axonserver.grpc.control.ReleaseEventProcessorSegment;
import io.axoniq.axonserver.grpc.control.RequestEventProcessorInfo;
import io.axoniq.axonserver.grpc.control.StartEventProcessor;
import java.util.function.Function;
import org.axonframework.axonserver.connector.AxonServerConnectionManager;
import org.axonframework.axonserver.connector.processor.EventProcessorController;
import org.axonframework.axonserver.connector.processor.grpc.GrpcEventProcessorMapping;
import org.axonframework.axonserver.connector.processor.grpc.PlatformInboundMessage;
import org.axonframework.eventhandling.EventProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventProcessorControlService {
    private final Logger logger = LoggerFactory.getLogger(EventProcessorControlService.class);
    private final AxonServerConnectionManager axonServerConnectionManager;
    private final EventProcessorController eventProcessorController;
    private final Function<EventProcessor, PlatformInboundMessage> mapping;

    public EventProcessorControlService(AxonServerConnectionManager axonServerConnectionManager, EventProcessorController eventProcessorController) {
        this.axonServerConnectionManager = axonServerConnectionManager;
        this.eventProcessorController = eventProcessorController;
        this.mapping = new GrpcEventProcessorMapping();
    }

    public void start() {
        this.axonServerConnectionManager.onOutboundInstruction(PlatformOutboundInstruction.RequestCase.PAUSE_EVENT_PROCESSOR, this::pauseProcessor);
        this.axonServerConnectionManager.onOutboundInstruction(PlatformOutboundInstruction.RequestCase.START_EVENT_PROCESSOR, this::startProcessor);
        this.axonServerConnectionManager.onOutboundInstruction(PlatformOutboundInstruction.RequestCase.RELEASE_SEGMENT, this::releaseSegment);
        this.axonServerConnectionManager.onOutboundInstruction(PlatformOutboundInstruction.RequestCase.REQUEST_EVENT_PROCESSOR_INFO, this::getEventProcessorInfo);
    }

    public void pauseProcessor(PlatformOutboundInstruction platformOutboundInstruction) {
        PauseEventProcessor pauseEventProcessor = platformOutboundInstruction.getPauseEventProcessor();
        String processorName = pauseEventProcessor.getProcessorName();
        this.eventProcessorController.pauseProcessor(processorName);
    }

    public void startProcessor(PlatformOutboundInstruction platformOutboundInstruction) {
        StartEventProcessor startEventProcessor = platformOutboundInstruction.getStartEventProcessor();
        String processorName = startEventProcessor.getProcessorName();
        this.eventProcessorController.startProcessor(processorName);
    }

    public void releaseSegment(PlatformOutboundInstruction platformOutboundInstruction) {
        ReleaseEventProcessorSegment releaseSegment = platformOutboundInstruction.getReleaseSegment();
        String processorName = releaseSegment.getProcessorName();
        int segmentIdentifier = releaseSegment.getSegmentIdentifier();
        this.eventProcessorController.releaseSegment(processorName, segmentIdentifier);
    }

    public void getEventProcessorInfo(PlatformOutboundInstruction platformOutboundInstruction) {
        try {
            RequestEventProcessorInfo request = platformOutboundInstruction.getRequestEventProcessorInfo();
            EventProcessor processor = this.eventProcessorController.getEventProcessor(request.getProcessorName());
            this.axonServerConnectionManager.send(this.mapping.apply(processor).instruction());
        }
        catch (Exception e) {
            this.logger.debug("Problem getting the information about Event Processor", (Throwable)e);
        }
    }
}

