/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector;

import org.axonframework.axonserver.connector.AxonServerConfiguration;
import org.axonframework.axonserver.connector.AxonServerConnectionManager;
import org.axonframework.axonserver.connector.command.AxonServerCommandBus;
import org.axonframework.axonserver.connector.command.CommandPriorityCalculator;
import org.axonframework.axonserver.connector.event.axon.AxonServerEventStore;
import org.axonframework.axonserver.connector.event.axon.EventProcessorInfoConfiguration;
import org.axonframework.axonserver.connector.query.AxonServerQueryBus;
import org.axonframework.axonserver.connector.query.QueryPriorityCalculator;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.SimpleCommandBus;
import org.axonframework.commandhandling.distributed.AnnotationRoutingStrategy;
import org.axonframework.commandhandling.distributed.RoutingStrategy;
import org.axonframework.common.transaction.NoTransactionManager;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.config.Configuration;
import org.axonframework.config.Configurer;
import org.axonframework.config.ConfigurerModule;
import org.axonframework.config.ModuleConfiguration;
import org.axonframework.eventhandling.tokenstore.TokenStore;
import org.axonframework.eventhandling.tokenstore.inmemory.InMemoryTokenStore;
import org.axonframework.queryhandling.LoggingQueryInvocationErrorHandler;
import org.axonframework.queryhandling.QueryBus;
import org.axonframework.queryhandling.QueryInvocationErrorHandler;
import org.axonframework.queryhandling.SimpleQueryBus;
import org.axonframework.serialization.upcasting.event.EventUpcaster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerConnectorConfigurerModule
implements ConfigurerModule {
    private static final Logger logger = LoggerFactory.getLogger(ServerConnectorConfigurerModule.class);

    public void configureModule(Configurer configurer) {
        configurer.registerComponent(AxonServerConfiguration.class, c -> new AxonServerConfiguration());
        configurer.registerComponent(AxonServerConnectionManager.class, c -> this.buildAxonServerConnectionManager((Configuration)c));
        configurer.configureEventStore(this::buildEventStore);
        configurer.configureCommandBus(this::buildCommandBus);
        configurer.configureQueryBus(this::buildQueryBus);
        configurer.registerModule((ModuleConfiguration)new EventProcessorInfoConfiguration());
        configurer.registerComponent(TokenStore.class, c -> {
            logger.warn("BEWARE! Falling back to an in-memory token store. It is highly recommended to configure a persistent implementation, based on the activity of the handler.");
            return new InMemoryTokenStore();
        });
    }

    private AxonServerConnectionManager buildAxonServerConnectionManager(Configuration c) {
        AxonServerConnectionManager axonServerConnectionManager = new AxonServerConnectionManager((AxonServerConfiguration)c.getComponent(AxonServerConfiguration.class));
        c.onShutdown(axonServerConnectionManager::shutdown);
        return axonServerConnectionManager;
    }

    private AxonServerEventStore buildEventStore(Configuration c) {
        return AxonServerEventStore.builder().configuration((AxonServerConfiguration)c.getComponent(AxonServerConfiguration.class)).platformConnectionManager((AxonServerConnectionManager)c.getComponent(AxonServerConnectionManager.class)).snapshotSerializer(c.serializer()).eventSerializer(c.eventSerializer()).upcasterChain((EventUpcaster)c.upcasterChain()).build();
    }

    private AxonServerCommandBus buildCommandBus(Configuration c) {
        AxonServerCommandBus commandBus = new AxonServerCommandBus((AxonServerConnectionManager)c.getComponent(AxonServerConnectionManager.class), (AxonServerConfiguration)c.getComponent(AxonServerConfiguration.class), (CommandBus)SimpleCommandBus.builder().build(), c.messageSerializer(), (RoutingStrategy)c.getComponent(RoutingStrategy.class, AnnotationRoutingStrategy::new), (CommandPriorityCalculator)c.getComponent(CommandPriorityCalculator.class, () -> new CommandPriorityCalculator(){}));
        c.onShutdown(commandBus::disconnect);
        return commandBus;
    }

    private QueryBus buildQueryBus(Configuration c) {
        SimpleQueryBus localSegment = SimpleQueryBus.builder().transactionManager((TransactionManager)c.getComponent(TransactionManager.class, NoTransactionManager::instance)).errorHandler((QueryInvocationErrorHandler)c.getComponent(QueryInvocationErrorHandler.class, () -> LoggingQueryInvocationErrorHandler.builder().build())).queryUpdateEmitter(c.queryUpdateEmitter()).messageMonitor(c.messageMonitor(QueryBus.class, "localQueryBus")).build();
        AxonServerQueryBus queryBus = new AxonServerQueryBus((AxonServerConnectionManager)c.getComponent(AxonServerConnectionManager.class), (AxonServerConfiguration)c.getComponent(AxonServerConfiguration.class), c.queryUpdateEmitter(), (QueryBus)localSegment, c.messageSerializer(), c.serializer(), (QueryPriorityCalculator)c.getComponent(QueryPriorityCalculator.class, () -> new QueryPriorityCalculator(){}));
        c.onShutdown(queryBus::disconnect);
        return queryBus;
    }

    public int order() {
        return Integer.MIN_VALUE;
    }
}

