/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.query;

import io.axoniq.axonserver.grpc.ErrorMessage;
import io.axoniq.axonserver.grpc.FlowControl;
import io.axoniq.axonserver.grpc.query.QueryComplete;
import io.axoniq.axonserver.grpc.query.QueryProviderInbound;
import io.axoniq.axonserver.grpc.query.QueryProviderOutbound;
import io.axoniq.axonserver.grpc.query.QueryRequest;
import io.axoniq.axonserver.grpc.query.QueryResponse;
import io.axoniq.axonserver.grpc.query.QueryServiceGrpc;
import io.axoniq.axonserver.grpc.query.QuerySubscription;
import io.grpc.ClientInterceptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import io.netty.util.internal.OutOfDirectMemoryError;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.axonframework.axonserver.connector.AxonServerConfiguration;
import org.axonframework.axonserver.connector.AxonServerConnectionManager;
import org.axonframework.axonserver.connector.DispatchInterceptors;
import org.axonframework.axonserver.connector.ErrorCode;
import org.axonframework.axonserver.connector.command.AxonServerRegistration;
import org.axonframework.axonserver.connector.query.QueryPriorityCalculator;
import org.axonframework.axonserver.connector.query.QuerySerializer;
import org.axonframework.axonserver.connector.query.QueueBackedSpliterator;
import org.axonframework.axonserver.connector.query.subscription.AxonServerSubscriptionQueryResult;
import org.axonframework.axonserver.connector.query.subscription.DeserializedResult;
import org.axonframework.axonserver.connector.query.subscription.SubscriptionMessageSerializer;
import org.axonframework.axonserver.connector.query.subscription.SubscriptionQueryRequestTarget;
import org.axonframework.axonserver.connector.util.ContextAddingInterceptor;
import org.axonframework.axonserver.connector.util.ExceptionSerializer;
import org.axonframework.axonserver.connector.util.FlowControllingStreamObserver;
import org.axonframework.axonserver.connector.util.ProcessingInstructionHelper;
import org.axonframework.axonserver.connector.util.ResubscribableStreamObserver;
import org.axonframework.axonserver.connector.util.TokenAddingInterceptor;
import org.axonframework.common.AxonThreadFactory;
import org.axonframework.common.Registration;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.MessageHandler;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.queryhandling.QueryBus;
import org.axonframework.queryhandling.QueryMessage;
import org.axonframework.queryhandling.QueryResponseMessage;
import org.axonframework.queryhandling.QueryUpdateEmitter;
import org.axonframework.queryhandling.SubscriptionQueryBackpressure;
import org.axonframework.queryhandling.SubscriptionQueryMessage;
import org.axonframework.queryhandling.SubscriptionQueryResult;
import org.axonframework.queryhandling.SubscriptionQueryUpdateMessage;
import org.axonframework.serialization.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AxonServerQueryBus
implements QueryBus {
    private final Logger logger = LoggerFactory.getLogger(AxonServerQueryBus.class);
    private static final int DIRECT_QUERY_NUMBER_OF_RESULTS = 1;
    private static final long DIRECT_QUERY_TIMEOUT_MS = TimeUnit.HOURS.toMillis(1L);
    private static final int SCATTER_GATHER_NUMBER_OF_RESULTS = -1;
    private final AxonServerConnectionManager axonServerConnectionManager;
    private final AxonServerConfiguration configuration;
    private final QueryUpdateEmitter updateEmitter;
    private final QueryBus localSegment;
    private final QuerySerializer serializer;
    private final SubscriptionMessageSerializer subscriptionSerializer;
    private final QueryPriorityCalculator priorityCalculator;
    private final QueryHandlerProvider queryProvider;
    private final ClientInterceptor[] interceptors;
    private final DispatchInterceptors<QueryMessage<?, ?>> dispatchInterceptors;
    private final Collection<String> subscriptions;
    private final Map<QueryProviderInbound.RequestCase, Collection<Consumer<QueryProviderInbound>>> queryHandlers;

    public AxonServerQueryBus(AxonServerConnectionManager axonServerConnectionManager, AxonServerConfiguration configuration, QueryUpdateEmitter updateEmitter, QueryBus localSegment, Serializer messageSerializer, Serializer genericSerializer, QueryPriorityCalculator priorityCalculator) {
        this.axonServerConnectionManager = axonServerConnectionManager;
        this.configuration = configuration;
        this.updateEmitter = updateEmitter;
        this.localSegment = localSegment;
        this.serializer = new QuerySerializer(messageSerializer, genericSerializer, configuration);
        this.subscriptionSerializer = new SubscriptionMessageSerializer(messageSerializer, genericSerializer, configuration);
        this.priorityCalculator = priorityCalculator;
        this.queryProvider = new QueryHandlerProvider();
        this.interceptors = new ClientInterceptor[]{new TokenAddingInterceptor(configuration.getToken()), new ContextAddingInterceptor(configuration.getContext())};
        this.dispatchInterceptors = new DispatchInterceptors();
        this.subscriptions = new CopyOnWriteArraySet<String>();
        this.queryHandlers = new EnumMap<QueryProviderInbound.RequestCase, Collection<Consumer<QueryProviderInbound>>>(QueryProviderInbound.RequestCase.class);
        this.axonServerConnectionManager.addReconnectListener(() -> this.queryProvider.resubscribe());
        this.axonServerConnectionManager.addReconnectInterceptor(this::interceptReconnectRequest);
        this.axonServerConnectionManager.addDisconnectListener(() -> this.queryProvider.unsubscribeAll());
        this.axonServerConnectionManager.addDisconnectListener(this::onApplicationDisconnected);
        SubscriptionQueryRequestTarget target = new SubscriptionQueryRequestTarget(localSegment, this::publish, this.subscriptionSerializer);
        this.on(QueryProviderInbound.RequestCase.SUBSCRIPTION_QUERY_REQUEST, target::onSubscriptionQueryRequest);
        this.axonServerConnectionManager.addDisconnectListener(target::onApplicationDisconnected);
    }

    private Runnable interceptReconnectRequest(Runnable reconnect) {
        if (this.subscriptions.isEmpty()) {
            return reconnect;
        }
        return () -> this.logger.info("Reconnect refused because there are active subscription queries.");
    }

    private void onApplicationDisconnected() {
        this.subscriptions.clear();
    }

    public <R> Registration subscribe(String queryName, Type responseType, MessageHandler<? super QueryMessage<?, R>> handler) {
        return new AxonServerRegistration(this.queryProvider.subscribe(queryName, responseType, this.configuration.getComponentName(), handler), () -> this.queryProvider.unsubscribe(queryName, responseType, this.configuration.getComponentName()));
    }

    public <Q, R> CompletableFuture<QueryResponseMessage<R>> query(QueryMessage<Q, R> queryMessage) {
        QueryMessage<Q, R> interceptedQuery = this.dispatchInterceptors.intercept(queryMessage);
        final CompletableFuture<QueryResponseMessage<R>> completableFuture = new CompletableFuture<QueryResponseMessage<R>>();
        try {
            QueryRequest queryRequest = this.serializer.serializeRequest(interceptedQuery, 1, DIRECT_QUERY_TIMEOUT_MS, this.priorityCalculator.determinePriority(interceptedQuery));
            this.queryService().query(queryRequest, new StreamObserver<QueryResponse>(){

                public void onNext(QueryResponse queryResponse) {
                    AxonServerQueryBus.this.logger.debug("Received query response [{}]", (Object)queryResponse);
                    completableFuture.complete(AxonServerQueryBus.this.serializer.deserializeResponse(queryResponse));
                }

                public void onError(Throwable throwable) {
                    if (AxonServerQueryBus.this.logger.isDebugEnabled()) {
                        AxonServerQueryBus.this.logger.warn("Received error while waiting for first response: {}", (Object)throwable.getMessage(), (Object)throwable);
                    } else {
                        AxonServerQueryBus.this.logger.warn("Received error while waiting for first response: {}", (Object)throwable.getMessage());
                    }
                    completableFuture.completeExceptionally((Throwable)ErrorCode.QUERY_DISPATCH_ERROR.convert(AxonServerQueryBus.this.configuration.getClientId(), throwable));
                }

                public void onCompleted() {
                    if (completableFuture.isDone()) {
                        return;
                    }
                    completableFuture.completeExceptionally((Throwable)ErrorCode.QUERY_DISPATCH_ERROR.convert(ErrorMessage.newBuilder().setMessage("No result from query executor").build()));
                }
            });
        }
        catch (Exception e) {
            this.logger.warn("There was a problem issuing a query {}.", interceptedQuery, (Object)e);
            completableFuture.completeExceptionally((Throwable)ErrorCode.QUERY_DISPATCH_ERROR.convert(this.configuration.getClientId(), e));
        }
        return completableFuture;
    }

    public <Q, R> Stream<QueryResponseMessage<R>> scatterGather(QueryMessage<Q, R> queryMessage, long timeout, TimeUnit timeUnit) {
        QueryMessage<Q, R> interceptedQuery = this.dispatchInterceptors.intercept(queryMessage);
        final QueueBackedSpliterator resultSpliterator = new QueueBackedSpliterator(timeout, timeUnit);
        QueryRequest queryRequest = this.serializer.serializeRequest(interceptedQuery, -1, timeUnit.toMillis(timeout), this.priorityCalculator.determinePriority(interceptedQuery));
        ((QueryServiceGrpc.QueryServiceStub)this.queryService().withDeadlineAfter(timeout, timeUnit)).query(queryRequest, new StreamObserver<QueryResponse>(){

            public void onNext(QueryResponse queryResponse) {
                AxonServerQueryBus.this.logger.debug("Received query response [{}]", (Object)queryResponse);
                if (queryResponse.hasErrorMessage()) {
                    AxonServerQueryBus.this.logger.warn("The received query response has error message [{}]", (Object)queryResponse.getErrorMessage());
                } else {
                    resultSpliterator.put(AxonServerQueryBus.this.serializer.deserializeResponse(queryResponse));
                }
            }

            public void onError(Throwable throwable) {
                if (!AxonServerQueryBus.this.isDeadlineExceeded(throwable)) {
                    AxonServerQueryBus.this.logger.warn("Received error while waiting for responses: {}", (Object)throwable.getMessage(), (Object)throwable);
                }
                resultSpliterator.cancel(throwable);
            }

            public void onCompleted() {
                resultSpliterator.cancel(null);
            }
        });
        return StreamSupport.stream(resultSpliterator, false);
    }

    private boolean isDeadlineExceeded(Throwable throwable) {
        return throwable instanceof StatusRuntimeException && ((StatusRuntimeException)throwable).getStatus().getCode().equals((Object)Status.Code.DEADLINE_EXCEEDED);
    }

    public void disconnect() {
        this.queryProvider.disconnect();
    }

    public QueryBus localSegment() {
        return this.localSegment;
    }

    private void publish(QueryProviderOutbound providerOutbound) {
        this.queryProvider.getSubscriberObserver().onNext((Object)providerOutbound);
    }

    public void on(QueryProviderInbound.RequestCase requestCase, Consumer<QueryProviderInbound> consumer) {
        Collection consumers = this.queryHandlers.computeIfAbsent(requestCase, rc -> new CopyOnWriteArraySet());
        consumers.add(consumer);
    }

    public <Q, I, U> SubscriptionQueryResult<QueryResponseMessage<I>, SubscriptionQueryUpdateMessage<U>> subscriptionQuery(SubscriptionQueryMessage<Q, I, U> query, SubscriptionQueryBackpressure backPressure, int updateBufferSize) {
        SubscriptionQueryMessage<Q, I, U> interceptedQuery = this.dispatchInterceptors.intercept(query);
        String subscriptionId = interceptedQuery.getIdentifier();
        if (this.subscriptions.contains(subscriptionId)) {
            String errorMessage = "There already is a subscription query with subscription Id [" + subscriptionId + "]";
            this.logger.warn(errorMessage);
            throw new IllegalArgumentException(errorMessage);
        }
        this.logger.debug("Subscription Query requested with subscription Id [{}]", (Object)subscriptionId);
        this.subscriptions.add(subscriptionId);
        AxonServerSubscriptionQueryResult result = new AxonServerSubscriptionQueryResult(this.subscriptionSerializer.serialize(interceptedQuery), this.queryService()::subscription, this.configuration, backPressure, updateBufferSize, () -> this.subscriptions.remove(subscriptionId));
        return new DeserializedResult(result.get(), this.subscriptionSerializer);
    }

    QueryServiceGrpc.QueryServiceStub queryService() {
        return (QueryServiceGrpc.QueryServiceStub)QueryServiceGrpc.newStub(this.axonServerConnectionManager.getChannel()).withInterceptors(this.interceptors);
    }

    public QueryUpdateEmitter queryUpdateEmitter() {
        return this.updateEmitter;
    }

    public Registration registerHandlerInterceptor(MessageHandlerInterceptor<? super QueryMessage<?, ?>> interceptor) {
        return this.localSegment.registerHandlerInterceptor(interceptor);
    }

    public Registration registerDispatchInterceptor(MessageDispatchInterceptor<? super QueryMessage<?, ?>> dispatchInterceptor) {
        return this.dispatchInterceptors.registerDispatchInterceptor(dispatchInterceptor);
    }

    private class QueryHandlerProvider {
        private static final int QUERY_QUEUE_CAPACITY = 1000;
        private static final int DEFAULT_PRIORITY = 0;
        private static final long THREAD_KEEP_ALIVE_TIME = 100L;
        private final ConcurrentMap<QueryDefinition, Set<MessageHandler<? super QueryMessage<?, ?>>>> subscribedQueries = new ConcurrentHashMap();
        private final ExecutorService queryExecutor;
        private volatile boolean subscribing;
        private volatile boolean running = true;
        private volatile StreamObserver<QueryProviderOutbound> outboundStreamObserver;

        QueryHandlerProvider() {
            PriorityBlockingQueue<Runnable> queryProcessQueue = new PriorityBlockingQueue<Runnable>(1000, Comparator.comparingLong(r -> r instanceof QueryProcessor ? ((QueryProcessor)r).getPriority() : 0L));
            int queryThreads = AxonServerQueryBus.this.configuration.getQueryThreads();
            this.queryExecutor = new ThreadPoolExecutor(queryThreads, queryThreads, 100L, TimeUnit.MILLISECONDS, queryProcessQueue, (ThreadFactory)new AxonThreadFactory("AxonServerQueryProvider"));
        }

        private void resubscribe() {
            if (this.subscribedQueries.isEmpty() || this.subscribing) {
                return;
            }
            try {
                StreamObserver<QueryProviderOutbound> subscriberStreamObserver = this.getSubscriberObserver();
                this.subscribedQueries.forEach((queryDefinition, handlers) -> subscriberStreamObserver.onNext((Object)QueryProviderOutbound.newBuilder().setSubscribe(this.buildQuerySubscription((QueryDefinition)queryDefinition, handlers.size())).build()));
            }
            catch (Exception ex) {
                AxonServerQueryBus.this.logger.warn("Error while resubscribing - {}", (Object)ex.getMessage());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <R> Registration subscribe(String queryName, Type responseType, String componentName, MessageHandler<? super QueryMessage<?, R>> handler) {
            this.subscribing = true;
            Set registrations = this.subscribedQueries.computeIfAbsent(new QueryDefinition(queryName, responseType.getTypeName(), componentName), k -> new CopyOnWriteArraySet());
            registrations.add(handler);
            try {
                this.getSubscriberObserver().onNext((Object)QueryProviderOutbound.newBuilder().setSubscribe(QuerySubscription.newBuilder().setMessageId(UUID.randomUUID().toString()).setClientId(AxonServerQueryBus.this.configuration.getClientId()).setComponentName(componentName).setQuery(queryName).setResultName(responseType.getTypeName()).setNrOfHandlers(registrations.size()).build()).build());
            }
            catch (Exception ex) {
                AxonServerQueryBus.this.logger.warn("Subscribe failed - {}", (Object)ex.getMessage());
            }
            finally {
                this.subscribing = false;
            }
            return AxonServerQueryBus.this.localSegment.subscribe(queryName, responseType, handler);
        }

        private void processQuery(QueryRequest query) {
            String requestId = query.getMessageIdentifier();
            QueryMessage queryMessage = AxonServerQueryBus.this.serializer.deserializeRequest(query);
            try {
                if (ProcessingInstructionHelper.numberOfResults(query.getProcessingInstructionsList()) == 1L) {
                    QueryResponseMessage response2 = (QueryResponseMessage)AxonServerQueryBus.this.localSegment.query(queryMessage).get();
                    this.outboundStreamObserver.onNext((Object)QueryProviderOutbound.newBuilder().setQueryResponse(AxonServerQueryBus.this.serializer.serializeResponse(response2, requestId)).build());
                } else {
                    AxonServerQueryBus.this.localSegment.scatterGather(queryMessage, 0L, TimeUnit.SECONDS).forEach(response -> this.outboundStreamObserver.onNext((Object)QueryProviderOutbound.newBuilder().setQueryResponse(AxonServerQueryBus.this.serializer.serializeResponse((QueryResponseMessage<?>)response, requestId)).build()));
                }
                this.outboundStreamObserver.onNext((Object)QueryProviderOutbound.newBuilder().setQueryComplete(QueryComplete.newBuilder().setMessageId(UUID.randomUUID().toString()).setRequestId(requestId)).build());
            }
            catch (Exception e) {
                AxonServerQueryBus.this.logger.warn("Failed to dispatch query [{}] locally - Cause: {}", new Object[]{queryMessage.getQueryName(), e.getMessage(), e});
                if (this.outboundStreamObserver == null) {
                    return;
                }
                this.outboundStreamObserver.onNext((Object)QueryProviderOutbound.newBuilder().setQueryResponse(QueryResponse.newBuilder().setMessageIdentifier(UUID.randomUUID().toString()).setRequestIdentifier(requestId).setErrorMessage(ExceptionSerializer.serialize(AxonServerQueryBus.this.configuration.getClientId(), e)).setErrorCode(ErrorCode.QUERY_EXECUTION_ERROR.errorCode()).build()).build());
            }
        }

        private synchronized StreamObserver<QueryProviderOutbound> getSubscriberObserver() {
            if (this.outboundStreamObserver != null) {
                return this.outboundStreamObserver;
            }
            StreamObserver<QueryProviderInbound> queryProviderInboundStreamObserver = new StreamObserver<QueryProviderInbound>(){

                public void onNext(QueryProviderInbound inboundRequest) {
                    QueryProviderInbound.RequestCase requestCase = inboundRequest.getRequestCase();
                    ((Collection)AxonServerQueryBus.this.queryHandlers.getOrDefault((Object)requestCase, Collections.emptySet())).forEach(consumer -> consumer.accept(inboundRequest));
                    switch (requestCase) {
                        case CONFIRMATION: {
                            break;
                        }
                        case QUERY: {
                            QueryHandlerProvider.this.queryExecutor.execute(new QueryProcessor(inboundRequest.getQuery()));
                        }
                    }
                }

                public void onError(Throwable ex) {
                    AxonServerQueryBus.this.logger.warn("Received error from server: {}", (Object)ex.getMessage());
                    QueryHandlerProvider.this.outboundStreamObserver = null;
                }

                public void onCompleted() {
                    AxonServerQueryBus.this.logger.info("Received completed from server.");
                    QueryHandlerProvider.this.outboundStreamObserver = null;
                }
            };
            ResubscribableStreamObserver<QueryProviderInbound> resubscribableStreamObserver = new ResubscribableStreamObserver<QueryProviderInbound>(queryProviderInboundStreamObserver, t -> this.resubscribe());
            StreamObserver<QueryProviderOutbound> streamObserver = AxonServerQueryBus.this.axonServerConnectionManager.getQueryStream(resubscribableStreamObserver, AxonServerQueryBus.this.interceptors);
            AxonServerQueryBus.this.logger.info("Creating new query stream subscriber");
            this.outboundStreamObserver = new FlowControllingStreamObserver<QueryProviderOutbound>(streamObserver, AxonServerQueryBus.this.configuration, flowControl -> QueryProviderOutbound.newBuilder().setFlowControl((FlowControl)flowControl).build(), t -> t.getRequestCase().equals((Object)QueryProviderOutbound.RequestCase.QUERY_RESPONSE)).sendInitialPermits();
            return this.outboundStreamObserver;
        }

        public void unsubscribe(String queryName, Type responseType, String componentName) {
            QueryDefinition queryDefinition = new QueryDefinition(queryName, responseType.getTypeName(), componentName);
            this.subscribedQueries.remove(queryDefinition);
            try {
                this.getSubscriberObserver().onNext((Object)QueryProviderOutbound.newBuilder().setUnsubscribe(this.buildQuerySubscription(queryDefinition, 1)).build());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void unsubscribeAll() {
            this.subscribedQueries.forEach((queryDefinition, handlerSet) -> {
                try {
                    this.getSubscriberObserver().onNext((Object)QueryProviderOutbound.newBuilder().setUnsubscribe(this.buildQuerySubscription((QueryDefinition)queryDefinition, 1)).build());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            this.outboundStreamObserver = null;
        }

        void disconnect() {
            if (this.outboundStreamObserver != null) {
                this.outboundStreamObserver.onCompleted();
            }
            this.running = false;
            this.queryExecutor.shutdown();
        }

        private QuerySubscription buildQuerySubscription(QueryDefinition queryDefinition, int nrHandlers) {
            return QuerySubscription.newBuilder().setClientId(AxonServerQueryBus.this.configuration.getClientId()).setMessageId(UUID.randomUUID().toString()).setComponentName(queryDefinition.componentName).setQuery(queryDefinition.queryName).setNrOfHandlers(nrHandlers).setResultName(queryDefinition.responseName).build();
        }

        private class QueryProcessor
        implements Runnable {
            private final long priority;
            private final QueryRequest queryRequest;

            private QueryProcessor(QueryRequest queryRequest) {
                this.priority = -ProcessingInstructionHelper.priority(queryRequest.getProcessingInstructionsList());
                this.queryRequest = queryRequest;
            }

            public long getPriority() {
                return this.priority;
            }

            @Override
            public void run() {
                if (!QueryHandlerProvider.this.running) {
                    AxonServerQueryBus.this.logger.debug("Query Handler Provider has stopped running, hence query [{}] will no longer be processed");
                    return;
                }
                try {
                    AxonServerQueryBus.this.logger.debug("Will process query [{}]", (Object)this.queryRequest);
                    QueryHandlerProvider.this.processQuery(this.queryRequest);
                }
                catch (OutOfDirectMemoryError | RuntimeException e) {
                    AxonServerQueryBus.this.logger.warn("Query Processor had an exception when processing query [{}]", (Object)this.queryRequest, (Object)e);
                }
            }
        }

        private class QueryDefinition {
            private final String queryName;
            private final String responseName;
            private final String componentName;

            QueryDefinition(String queryName, String responseName, String componentName) {
                this.queryName = queryName;
                this.responseName = responseName;
                this.componentName = componentName;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                QueryDefinition that = (QueryDefinition)o;
                return Objects.equals(this.queryName, that.queryName) && Objects.equals(this.responseName, that.responseName) && Objects.equals(this.componentName, that.componentName);
            }

            public int hashCode() {
                return Objects.hash(this.queryName, this.responseName, this.componentName);
            }
        }
    }
}

