/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.query.subscription;

import io.axoniq.axonserver.grpc.SerializedObject;
import io.axoniq.axonserver.grpc.query.QueryProviderOutbound;
import io.axoniq.axonserver.grpc.query.QueryRequest;
import io.axoniq.axonserver.grpc.query.QueryResponse;
import io.axoniq.axonserver.grpc.query.QueryUpdate;
import io.axoniq.axonserver.grpc.query.QueryUpdateComplete;
import io.axoniq.axonserver.grpc.query.QueryUpdateCompleteExceptionally;
import io.axoniq.axonserver.grpc.query.SubscriptionQuery;
import io.axoniq.axonserver.grpc.query.SubscriptionQueryResponse;
import org.axonframework.axonserver.connector.AxonServerConfiguration;
import org.axonframework.axonserver.connector.ErrorCode;
import org.axonframework.axonserver.connector.query.GrpcBackedResponseMessage;
import org.axonframework.axonserver.connector.query.subscription.GrpcBackedQueryUpdateMessage;
import org.axonframework.axonserver.connector.query.subscription.GrpcBackedSubscriptionQueryMessage;
import org.axonframework.axonserver.connector.util.ExceptionSerializer;
import org.axonframework.axonserver.connector.util.GrpcMetaDataConverter;
import org.axonframework.axonserver.connector.util.GrpcMetadataSerializer;
import org.axonframework.axonserver.connector.util.GrpcObjectSerializer;
import org.axonframework.axonserver.connector.util.GrpcPayloadSerializer;
import org.axonframework.messaging.Message;
import org.axonframework.queryhandling.QueryResponseMessage;
import org.axonframework.queryhandling.SubscriptionQueryMessage;
import org.axonframework.queryhandling.SubscriptionQueryUpdateMessage;
import org.axonframework.serialization.Serializer;

public class SubscriptionMessageSerializer {
    private final AxonServerConfiguration configuration;
    private final Serializer messageSerializer;
    private final Serializer serializer;
    private final GrpcPayloadSerializer payloadSerializer;
    private final GrpcMetadataSerializer metadataSerializer;
    private final GrpcObjectSerializer<Object> responseTypeSerializer;

    public SubscriptionMessageSerializer(Serializer messageSerializer, Serializer serializer, AxonServerConfiguration configuration) {
        this.configuration = configuration;
        this.messageSerializer = messageSerializer;
        this.serializer = serializer;
        this.payloadSerializer = new GrpcPayloadSerializer(messageSerializer);
        this.metadataSerializer = new GrpcMetadataSerializer(new GrpcMetaDataConverter(messageSerializer));
        this.responseTypeSerializer = new GrpcObjectSerializer(serializer);
    }

    public SubscriptionQuery serialize(SubscriptionQueryMessage subscriptionQueryMessage) {
        QueryRequest queryRequest = QueryRequest.newBuilder().setTimestamp(System.currentTimeMillis()).setMessageIdentifier(subscriptionQueryMessage.getIdentifier()).setQuery(subscriptionQueryMessage.getQueryName()).setClientId(this.configuration.getClientId()).setComponentName(this.configuration.getComponentName()).setPayload(this.payloadSerializer.apply((Message)subscriptionQueryMessage)).setResponseType((SerializedObject)this.responseTypeSerializer.apply((Object)subscriptionQueryMessage.getResponseType())).putAllMetaData(this.metadataSerializer.apply(subscriptionQueryMessage.getMetaData())).build();
        return SubscriptionQuery.newBuilder().setSubscriptionIdentifier(subscriptionQueryMessage.getIdentifier()).setNumberOfPermits(this.configuration.getInitialNrOfPermits().intValue()).setUpdateResponseType((SerializedObject)this.responseTypeSerializer.apply((Object)subscriptionQueryMessage.getUpdateResponseType())).setQueryRequest(queryRequest).build();
    }

    <Q, I, U> SubscriptionQueryMessage<Q, I, U> deserialize(SubscriptionQuery subscriptionQuery) {
        return new GrpcBackedSubscriptionQueryMessage(subscriptionQuery, this.messageSerializer, this.serializer);
    }

    QueryProviderOutbound serialize(QueryResponseMessage initialResult, String subscriptionId) {
        QueryResponse queryResponse = QueryResponse.newBuilder().setPayload(this.payloadSerializer.apply((Message)initialResult)).putAllMetaData(this.metadataSerializer.apply(initialResult.getMetaData())).setMessageIdentifier(initialResult.getIdentifier()).setRequestIdentifier(subscriptionId).build();
        return QueryProviderOutbound.newBuilder().setSubscriptionQueryResponse(SubscriptionQueryResponse.newBuilder().setSubscriptionIdentifier(subscriptionId).setInitialResult(queryResponse)).build();
    }

    <I> QueryResponseMessage<I> deserialize(QueryResponse queryResponse) {
        return new GrpcBackedResponseMessage(queryResponse, this.messageSerializer);
    }

    QueryProviderOutbound serialize(SubscriptionQueryUpdateMessage<?> subscriptionQueryUpdateMessage, String subscriptionId) {
        QueryUpdate queryUpdate = QueryUpdate.newBuilder().setPayload(this.payloadSerializer.apply((Message)subscriptionQueryUpdateMessage)).putAllMetaData(this.metadataSerializer.apply(subscriptionQueryUpdateMessage.getMetaData())).setMessageIdentifier(subscriptionQueryUpdateMessage.getIdentifier()).setClientId(this.configuration.getClientId()).setComponentName(this.configuration.getComponentName()).build();
        return QueryProviderOutbound.newBuilder().setSubscriptionQueryResponse(SubscriptionQueryResponse.newBuilder().setSubscriptionIdentifier(subscriptionId).setUpdate(queryUpdate)).build();
    }

    <U> SubscriptionQueryUpdateMessage<U> deserialize(QueryUpdate queryUpdate) {
        return new GrpcBackedQueryUpdateMessage(queryUpdate, this.messageSerializer);
    }

    QueryProviderOutbound serializeComplete(String subscriptionId) {
        QueryUpdateComplete completedQueryUpdate = QueryUpdateComplete.newBuilder().setClientId(this.configuration.getClientId()).setComponentName(this.configuration.getComponentName()).build();
        return QueryProviderOutbound.newBuilder().setSubscriptionQueryResponse(SubscriptionQueryResponse.newBuilder().setSubscriptionIdentifier(subscriptionId).setComplete(completedQueryUpdate)).build();
    }

    QueryProviderOutbound serializeCompleteExceptionally(String subscriptionId, Throwable cause) {
        QueryUpdateCompleteExceptionally exceptionallyCompletedQueryUpdate = QueryUpdateCompleteExceptionally.newBuilder().setErrorMessage(ExceptionSerializer.serialize(this.configuration.getClientId(), cause)).setErrorCode(ErrorCode.QUERY_EXECUTION_ERROR.errorCode()).setClientId(this.configuration.getClientId()).setComponentName(this.configuration.getComponentName()).build();
        return QueryProviderOutbound.newBuilder().setSubscriptionQueryResponse(SubscriptionQueryResponse.newBuilder().setSubscriptionIdentifier(subscriptionId).setCompleteExceptionally(exceptionallyCompletedQueryUpdate)).build();
    }
}

