/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.event;

import io.axoniq.axonserver.grpc.event.Confirmation;
import io.axoniq.axonserver.grpc.event.Event;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.axonframework.axonserver.connector.event.util.EventCipher;

public class AppendEventTransaction {
    private final int timeout;
    private final StreamObserver<Event> eventStreamObserver;
    private final CompletableFuture<Confirmation> observer;
    private final EventCipher eventCipher;

    public AppendEventTransaction(int timeout, StreamObserver<Event> eventStreamObserver, CompletableFuture<Confirmation> observer, EventCipher eventCipher) {
        this.timeout = timeout;
        this.eventStreamObserver = eventStreamObserver;
        this.observer = observer;
        this.eventCipher = eventCipher;
    }

    public void append(Event event) {
        this.eventStreamObserver.onNext((Object)this.eventCipher.encrypt(event));
    }

    public void commit() throws InterruptedException, ExecutionException, TimeoutException {
        this.eventStreamObserver.onCompleted();
        this.observer.get(this.timeout, TimeUnit.MILLISECONDS);
    }

    public void rollback(Throwable reason) {
        this.eventStreamObserver.onError(reason);
    }
}

