/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.heartbeat.source;

import io.axoniq.axonserver.grpc.control.Heartbeat;
import io.axoniq.axonserver.grpc.control.PlatformInboundInstruction;
import java.util.function.Consumer;
import org.axonframework.axonserver.connector.AxonServerConnectionManager;
import org.axonframework.axonserver.connector.heartbeat.HeartbeatSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcHeartbeatSource
implements HeartbeatSource {
    private static final Logger logger = LoggerFactory.getLogger(GrpcHeartbeatSource.class);
    private final Consumer<PlatformInboundInstruction> platformInstructionSender = instruction -> connectionManager.send(context, (PlatformInboundInstruction)instruction);

    public GrpcHeartbeatSource(AxonServerConnectionManager connectionManager, String context) {
    }

    @Override
    public void pulse() {
        try {
            PlatformInboundInstruction instruction = PlatformInboundInstruction.newBuilder().setHeartbeat(Heartbeat.newBuilder()).build();
            this.platformInstructionSender.accept(instruction);
        }
        catch (Exception e) {
            logger.warn("Problem sending heartbeat to AxonServer.", (Throwable)e);
        }
    }
}

