/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.processor;

import io.axoniq.axonserver.grpc.control.EventProcessorReference;
import io.axoniq.axonserver.grpc.control.EventProcessorSegmentReference;
import io.axoniq.axonserver.grpc.control.PlatformOutboundInstruction;
import java.util.function.Function;
import org.axonframework.axonserver.connector.AxonServerConnectionManager;
import org.axonframework.axonserver.connector.processor.EventProcessorController;
import org.axonframework.axonserver.connector.processor.grpc.GrpcEventProcessorMapping;
import org.axonframework.axonserver.connector.processor.grpc.PlatformInboundMessage;
import org.axonframework.eventhandling.EventProcessor;
import org.axonframework.lifecycle.StartHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventProcessorControlService {
    private static final Logger logger = LoggerFactory.getLogger(EventProcessorControlService.class);
    private final AxonServerConnectionManager axonServerConnectionManager;
    private final EventProcessorController eventProcessorController;
    private final String context;
    private final Function<EventProcessor, PlatformInboundMessage> platformInboundMessageMapper;

    public EventProcessorControlService(AxonServerConnectionManager axonServerConnectionManager, EventProcessorController eventProcessorController) {
        this(axonServerConnectionManager, eventProcessorController, axonServerConnectionManager.getDefaultContext());
    }

    public EventProcessorControlService(AxonServerConnectionManager axonServerConnectionManager, EventProcessorController eventProcessorController, String context) {
        this.axonServerConnectionManager = axonServerConnectionManager;
        this.eventProcessorController = eventProcessorController;
        this.context = context;
        this.platformInboundMessageMapper = new GrpcEventProcessorMapping();
    }

    @StartHandler(phase=0x40000009)
    public void start() {
        this.axonServerConnectionManager.onOutboundInstruction(this.context, PlatformOutboundInstruction.RequestCase.PAUSE_EVENT_PROCESSOR, this::pauseProcessor);
        this.axonServerConnectionManager.onOutboundInstruction(this.context, PlatformOutboundInstruction.RequestCase.START_EVENT_PROCESSOR, this::startProcessor);
        this.axonServerConnectionManager.onOutboundInstruction(this.context, PlatformOutboundInstruction.RequestCase.RELEASE_SEGMENT, this::releaseSegment);
        this.axonServerConnectionManager.onOutboundInstruction(this.context, PlatformOutboundInstruction.RequestCase.REQUEST_EVENT_PROCESSOR_INFO, this::getEventProcessorInfo);
        this.axonServerConnectionManager.onOutboundInstruction(this.context, PlatformOutboundInstruction.RequestCase.SPLIT_EVENT_PROCESSOR_SEGMENT, this::splitSegment);
        this.axonServerConnectionManager.onOutboundInstruction(this.context, PlatformOutboundInstruction.RequestCase.MERGE_EVENT_PROCESSOR_SEGMENT, this::mergeSegment);
    }

    private void pauseProcessor(PlatformOutboundInstruction platformOutboundInstruction) {
        EventProcessorReference pauseEventProcessor = platformOutboundInstruction.getPauseEventProcessor();
        String processorName = pauseEventProcessor.getProcessorName();
        this.eventProcessorController.pauseProcessor(processorName);
    }

    private void startProcessor(PlatformOutboundInstruction platformOutboundInstruction) {
        EventProcessorReference startEventProcessor = platformOutboundInstruction.getStartEventProcessor();
        String processorName = startEventProcessor.getProcessorName();
        this.eventProcessorController.startProcessor(processorName);
    }

    private void releaseSegment(PlatformOutboundInstruction platformOutboundInstruction) {
        EventProcessorSegmentReference releaseSegment = platformOutboundInstruction.getReleaseSegment();
        String processorName = releaseSegment.getProcessorName();
        int segmentIdentifier = releaseSegment.getSegmentIdentifier();
        this.eventProcessorController.releaseSegment(processorName, segmentIdentifier);
    }

    private void getEventProcessorInfo(PlatformOutboundInstruction platformOutboundInstruction) {
        EventProcessorReference requestInfo = platformOutboundInstruction.getRequestEventProcessorInfo();
        String processorName = requestInfo.getProcessorName();
        try {
            EventProcessor processor = this.eventProcessorController.getEventProcessor(processorName);
            this.axonServerConnectionManager.send(this.context, this.platformInboundMessageMapper.apply(processor).instruction());
        }
        catch (Exception e) {
            logger.debug("Problem getting the information about Event Processor [{}]", (Object)processorName, (Object)e);
        }
    }

    private void splitSegment(PlatformOutboundInstruction platformOutboundInstruction) {
        EventProcessorSegmentReference splitSegment = platformOutboundInstruction.getSplitEventProcessorSegment();
        int segmentId = splitSegment.getSegmentIdentifier();
        String processorName = splitSegment.getProcessorName();
        try {
            this.eventProcessorController.splitSegment(processorName, segmentId);
        }
        catch (Exception e) {
            logger.error("Failed to split segment [{}] for processor [{}]", new Object[]{segmentId, processorName, e});
        }
    }

    private void mergeSegment(PlatformOutboundInstruction platformOutboundInstruction) {
        EventProcessorSegmentReference mergeSegment = platformOutboundInstruction.getMergeEventProcessorSegment();
        String processorName = mergeSegment.getProcessorName();
        int segmentId = mergeSegment.getSegmentIdentifier();
        try {
            this.eventProcessorController.mergeSegment(processorName, segmentId);
        }
        catch (Exception e) {
            logger.error("Failed to merge segment [{}] for processor [{}]", new Object[]{segmentId, processorName, e});
        }
    }
}

