/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.util;

import java.time.Instant;
import java.util.Spliterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferingSpliterator<R>
implements Spliterator<R> {
    private static final Logger logger = LoggerFactory.getLogger(BufferingSpliterator.class);
    private final long deadline;
    private final BlockingQueue<WrappedElement<R>> blockingQueue;
    private AtomicBoolean finished = new AtomicBoolean(false);
    private AtomicBoolean cancelled = new AtomicBoolean(false);

    public BufferingSpliterator(Instant deadline) {
        this(deadline, Integer.MAX_VALUE);
    }

    public BufferingSpliterator() {
        this(Long.MAX_VALUE, Integer.MAX_VALUE);
    }

    public BufferingSpliterator(Instant deadline, int bufferCapacity) {
        this(deadline.toEpochMilli(), bufferCapacity);
    }

    public BufferingSpliterator(int bufferCapacity) {
        this(Long.MAX_VALUE, bufferCapacity);
    }

    private BufferingSpliterator(long deadline, int bufferCapacity) {
        this.deadline = deadline;
        this.blockingQueue = new LinkedBlockingQueue<WrappedElement<R>>(bufferCapacity);
    }

    @Override
    public boolean tryAdvance(Consumer<? super R> action) {
        WrappedElement<R> element = null;
        try {
            long timeLeft;
            long l = timeLeft = this.deadline == Long.MAX_VALUE ? Long.MAX_VALUE : this.deadline - System.currentTimeMillis();
            if (!this.finished.get() && timeLeft > 0L) {
                element = this.blockingQueue.poll(timeLeft, TimeUnit.MILLISECONDS);
                if (element != null) {
                    if (((WrappedElement)element).stop) {
                        this.finished.set(true);
                        this.blockingQueue.clear();
                        return false;
                    }
                    if (((WrappedElement)element).wrapped != null) {
                        action.accept(((WrappedElement)element).wrapped);
                        return true;
                    }
                }
            } else {
                this.cancelled.set(true);
                this.finished.set(true);
            }
        }
        catch (InterruptedException e) {
            this.cancel(e);
            Thread.currentThread().interrupt();
            logger.warn("Interrupted tryAdvance", (Throwable)e);
            return false;
        }
        return element != null;
    }

    @Override
    public Spliterator<R> trySplit() {
        return null;
    }

    @Override
    public long estimateSize() {
        return Long.MAX_VALUE;
    }

    @Override
    public int characteristics() {
        return 16;
    }

    public boolean put(R object) {
        try {
            if (this.cancelled.get()) {
                return false;
            }
            this.blockingQueue.put(new WrappedElement<R>(object));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.warn("Put operation was interrupted", (Throwable)e);
            throw new RuntimeException(e);
        }
        return true;
    }

    public void cancel(Throwable t) {
        try {
            if (!this.cancelled.get()) {
                this.blockingQueue.put(new WrappedElement(true, t));
                this.cancelled.set(true);
            }
        }
        catch (InterruptedException e) {
            logger.warn("Cancel operation was interrupted", (Throwable)e);
        }
    }

    private class WrappedElement<W> {
        private final W wrapped;
        private final boolean stop;
        private final Throwable exception;

        WrappedElement(W wrapped) {
            this.wrapped = wrapped;
            this.stop = false;
            this.exception = null;
        }

        WrappedElement(boolean stop, Throwable exception) {
            this.wrapped = null;
            this.stop = stop;
            this.exception = exception;
        }
    }
}

