/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.util;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.axonframework.axonserver.connector.PriorityCallable;
import org.axonframework.axonserver.connector.PriorityRunnable;

public class PriorityExecutorService
implements ExecutorService {
    private final ExecutorService delegate;
    private final AtomicLong taskSequence;
    private final long priority;

    PriorityExecutorService(ExecutorService delegate, long priority, AtomicLong taskSequence) {
        this.priority = priority;
        this.delegate = delegate;
        this.taskSequence = taskSequence;
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    @Nonnull
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, @Nonnull TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    private PriorityRunnable createPriorityRunnable(Runnable task) {
        if (task instanceof PriorityRunnable) {
            return (PriorityRunnable)task;
        }
        return new PriorityRunnable(task, this.priority, this.taskSequence.incrementAndGet());
    }

    private <T> PriorityCallable<T> createPriorityCallable(Callable<T> task) {
        if (task instanceof PriorityCallable) {
            return (PriorityCallable)task;
        }
        return new PriorityCallable<T>(task, this.priority, this.taskSequence.incrementAndGet());
    }

    @Override
    @Nonnull
    public <T> Future<T> submit(@Nonnull Callable<T> task) {
        CompletableFuture future = new CompletableFuture();
        PriorityRunnable priorityTask = this.createPriorityRunnable(() -> {
            try {
                Object call = task.call();
                future.complete(call);
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        });
        this.delegate.execute(priorityTask);
        return future;
    }

    @Override
    @Nonnull
    public <T> Future<T> submit(@Nonnull Runnable task, T result) {
        CompletableFuture future = new CompletableFuture();
        this.delegate.execute(this.createPriorityRunnable(() -> {
            task.run();
            future.complete(result);
        }));
        return future;
    }

    @Override
    @Nonnull
    public Future<?> submit(@Nonnull Runnable task) {
        CompletableFuture future = new CompletableFuture();
        this.delegate.execute(this.createPriorityRunnable(() -> {
            task.run();
            future.complete(null);
        }));
        return future;
    }

    @Override
    @Nonnull
    public <T> List<Future<T>> invokeAll(@Nonnull Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.delegate.invokeAll(tasks.stream().map(this::createPriorityCallable).collect(Collectors.toList()));
    }

    @Override
    @Nonnull
    public <T> List<Future<T>> invokeAll(@Nonnull Collection<? extends Callable<T>> tasks, long timeout, @Nonnull TimeUnit unit) throws InterruptedException {
        return this.delegate.invokeAll(tasks.stream().map(this::createPriorityCallable).collect(Collectors.toList()), timeout, unit);
    }

    @Override
    @Nonnull
    public <T> T invokeAny(@Nonnull Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.delegate.invokeAny(tasks.stream().map(this::createPriorityCallable).collect(Collectors.toList()));
    }

    @Override
    public <T> T invokeAny(@Nonnull Collection<? extends Callable<T>> tasks, long timeout, @Nonnull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate.invokeAny(tasks.stream().map(this::createPriorityCallable).collect(Collectors.toList()), timeout, unit);
    }

    @Override
    public void execute(@Nonnull Runnable command) {
        this.delegate.execute(this.createPriorityRunnable(command));
    }
}

