/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.util;

import io.axoniq.axonserver.grpc.ProcessingInstruction;
import io.axoniq.axonserver.grpc.ProcessingKey;
import java.util.List;
import java.util.Optional;

public abstract class ProcessingInstructionHelper {
    private ProcessingInstructionHelper() {
    }

    public static long priority(List<ProcessingInstruction> processingInstructions) {
        return ProcessingInstructionHelper.getProcessingInstructionNumber(processingInstructions, ProcessingKey.PRIORITY).orElse(0L);
    }

    public static long numberOfResults(List<ProcessingInstruction> processingInstructions) {
        return ProcessingInstructionHelper.getProcessingInstructionNumber(processingInstructions, ProcessingKey.NR_OF_RESULTS).orElse(1L);
    }

    public static boolean axonServerSupportsQueryStreaming(List<ProcessingInstruction> processingInstructions) {
        return ProcessingInstructionHelper.getProcessingInstructionBoolean(processingInstructions, ProcessingKey.SERVER_SUPPORTS_STREAMING).orElse(false);
    }

    public static boolean clientSupportsQueryStreaming(List<ProcessingInstruction> processingInstructions) {
        return ProcessingInstructionHelper.getProcessingInstructionBoolean(processingInstructions, ProcessingKey.CLIENT_SUPPORTS_STREAMING).orElse(false);
    }

    public static long timeout(List<ProcessingInstruction> processingInstructions) {
        return ProcessingInstructionHelper.getProcessingInstructionNumber(processingInstructions, ProcessingKey.TIMEOUT).orElse(0L);
    }

    private static Optional<Long> getProcessingInstructionNumber(List<ProcessingInstruction> processingInstructions, ProcessingKey processingKey) {
        return processingInstructions.stream().filter(instruction -> processingKey.equals((Object)instruction.getKey())).map(instruction -> instruction.getValue().getNumberValue()).findFirst();
    }

    private static Optional<Boolean> getProcessingInstructionBoolean(List<ProcessingInstruction> processingInstructions, ProcessingKey processingKey) {
        return processingInstructions.stream().filter(instruction -> processingKey.equals((Object)instruction.getKey())).map(instruction -> instruction.getValue().getBooleanValue()).findFirst();
    }
}

