/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.query;

import io.axoniq.axonserver.connector.FlowControl;
import io.axoniq.axonserver.connector.ReplyChannel;
import io.axoniq.axonserver.connector.ResultStream;
import io.axoniq.axonserver.connector.ResultStreamPublisher;
import io.axoniq.axonserver.connector.impl.CloseAwareReplyChannel;
import io.axoniq.axonserver.connector.query.QueryDefinition;
import io.axoniq.axonserver.connector.query.QueryHandler;
import io.axoniq.axonserver.grpc.ErrorMessage;
import io.axoniq.axonserver.grpc.query.QueryProviderInbound;
import io.axoniq.axonserver.grpc.query.QueryProviderOutbound;
import io.axoniq.axonserver.grpc.query.QueryRequest;
import io.axoniq.axonserver.grpc.query.QueryResponse;
import io.axoniq.axonserver.grpc.query.QueryUpdate;
import io.axoniq.axonserver.grpc.query.SubscriptionQuery;
import io.grpc.stub.StreamObserver;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import org.axonframework.axonserver.connector.AxonServerConfiguration;
import org.axonframework.axonserver.connector.AxonServerConnectionManager;
import org.axonframework.axonserver.connector.DispatchInterceptors;
import org.axonframework.axonserver.connector.ErrorCode;
import org.axonframework.axonserver.connector.InstructionAckSource;
import org.axonframework.axonserver.connector.PriorityRunnable;
import org.axonframework.axonserver.connector.TargetContextResolver;
import org.axonframework.axonserver.connector.command.AxonServerRegistration;
import org.axonframework.axonserver.connector.query.AxonServerQueryDispatchException;
import org.axonframework.axonserver.connector.query.QueryPriorityCalculator;
import org.axonframework.axonserver.connector.query.QueryProcessingTask;
import org.axonframework.axonserver.connector.query.QuerySerializer;
import org.axonframework.axonserver.connector.query.subscription.AxonServerSubscriptionQueryResult;
import org.axonframework.axonserver.connector.query.subscription.SubscriptionMessageSerializer;
import org.axonframework.axonserver.connector.util.ExceptionSerializer;
import org.axonframework.axonserver.connector.util.ExecutorServiceBuilder;
import org.axonframework.axonserver.connector.util.PriorityTaskSchedulers;
import org.axonframework.axonserver.connector.util.ProcessingInstructionHelper;
import org.axonframework.axonserver.connector.util.UpstreamAwareStreamObserver;
import org.axonframework.common.Assert;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.AxonException;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.Registration;
import org.axonframework.common.StringUtils;
import org.axonframework.lifecycle.Lifecycle;
import org.axonframework.lifecycle.ShutdownLatch;
import org.axonframework.messaging.Distributed;
import org.axonframework.messaging.GenericMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.MessageHandler;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.responsetypes.ConvertingResponseMessage;
import org.axonframework.messaging.responsetypes.InstanceResponseType;
import org.axonframework.messaging.responsetypes.MultipleInstancesResponseType;
import org.axonframework.messaging.responsetypes.ResponseType;
import org.axonframework.queryhandling.DefaultQueryBusSpanFactory;
import org.axonframework.queryhandling.GenericQueryResponseMessage;
import org.axonframework.queryhandling.QueryBus;
import org.axonframework.queryhandling.QueryBusSpanFactory;
import org.axonframework.queryhandling.QueryMessage;
import org.axonframework.queryhandling.QueryResponseMessage;
import org.axonframework.queryhandling.QueryUpdateEmitter;
import org.axonframework.queryhandling.StreamingQueryMessage;
import org.axonframework.queryhandling.SubscriptionQueryBackpressure;
import org.axonframework.queryhandling.SubscriptionQueryMessage;
import org.axonframework.queryhandling.SubscriptionQueryResult;
import org.axonframework.queryhandling.SubscriptionQueryUpdateMessage;
import org.axonframework.queryhandling.UpdateHandlerRegistration;
import org.axonframework.serialization.Serializer;
import org.axonframework.tracing.NoOpSpanFactory;
import org.axonframework.tracing.Span;
import org.axonframework.tracing.SpanFactory;
import org.axonframework.tracing.SpanScope;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;
import reactor.core.scheduler.Scheduler;

public class AxonServerQueryBus
implements QueryBus,
Distributed<QueryBus>,
Lifecycle {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final AtomicLong TASK_SEQUENCE = new AtomicLong(Long.MIN_VALUE);
    private static final int DIRECT_QUERY_NUMBER_OF_RESULTS = 1;
    private static final long DIRECT_QUERY_TIMEOUT_MS = TimeUnit.HOURS.toMillis(1L);
    private static final int SCATTER_GATHER_NUMBER_OF_RESULTS = -1;
    private static final int QUERY_QUEUE_CAPACITY = 1000;
    private final AxonServerConnectionManager axonServerConnectionManager;
    private final AxonServerConfiguration configuration;
    private final QueryUpdateEmitter updateEmitter;
    private final QueryBus localSegment;
    private final QuerySerializer serializer;
    private final SubscriptionMessageSerializer subscriptionSerializer;
    private final QueryPriorityCalculator priorityCalculator;
    private final DispatchInterceptors<QueryMessage<?, ?>> dispatchInterceptors;
    private final TargetContextResolver<? super QueryMessage<?, ?>> targetContextResolver;
    private final ShutdownLatch shutdownLatch = new ShutdownLatch();
    private final ExecutorService queryExecutor;
    private final LocalSegmentAdapter localSegmentAdapter;
    private final String context;
    private final QueryBusSpanFactory spanFactory;

    public AxonServerQueryBus(Builder builder) {
        builder.validate();
        this.axonServerConnectionManager = builder.axonServerConnectionManager;
        this.configuration = builder.configuration;
        this.updateEmitter = builder.updateEmitter;
        this.localSegment = builder.localSegment;
        this.serializer = builder.buildQuerySerializer();
        this.subscriptionSerializer = builder.buildSubscriptionMessageSerializer();
        this.priorityCalculator = builder.priorityCalculator;
        this.context = StringUtils.nonEmptyOrNull((String)builder.defaultContext) ? builder.defaultContext : this.configuration.getContext();
        this.targetContextResolver = builder.targetContextResolver.orElse(m -> this.context);
        this.spanFactory = builder.spanFactory;
        this.dispatchInterceptors = new DispatchInterceptors();
        PriorityBlockingQueue queryProcessQueue = new PriorityBlockingQueue(1000);
        this.queryExecutor = (ExecutorService)builder.executorServiceBuilder.apply(this.configuration, queryProcessQueue);
        this.localSegmentAdapter = new LocalSegmentAdapter();
    }

    public <Q, R> Publisher<QueryResponseMessage<R>> streamingQuery(StreamingQueryMessage<Q, R> query) {
        Span span = this.spanFactory.createStreamingQuerySpan(query, true).start();
        try (SpanScope unused = span.makeCurrent();){
            StreamingQueryMessage queryWithContext = (StreamingQueryMessage)this.spanFactory.propagateContext(query);
            int priority = this.priorityCalculator.determinePriority((QueryMessage<?, ?>)queryWithContext);
            AtomicReference<Scheduler> scheduler = new AtomicReference<Scheduler>(PriorityTaskSchedulers.forPriority(this.queryExecutor, priority, TASK_SEQUENCE));
            Flux flux = Mono.fromSupplier(this::registerStreamingQueryActivity).flatMapMany(activity -> Mono.just((Object)this.dispatchInterceptors.intercept(queryWithContext)).flatMapMany(intercepted -> Mono.just((Object)this.serializeStreaming((QueryMessage<?, ?>)intercepted, priority)).flatMapMany(queryRequest -> new ResultStreamPublisher(() -> this.sendRequest((QueryMessage<?, ?>)intercepted, (QueryRequest)queryRequest))).concatMap(queryResponse -> this.deserialize((StreamingQueryMessage)intercepted, (QueryResponse)queryResponse))).publishOn((Scheduler)scheduler.get()).doOnError(arg_0 -> ((Span)span).recordException(arg_0)).doFinally((Consumer)new ActivityFinisher((ShutdownLatch.ActivityHandle)activity, span)).subscribeOn((Scheduler)scheduler.get()));
            return flux;
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public void registerLifecycleHandlers(@Nonnull Lifecycle.LifecycleRegistry lifecycle) {
        lifecycle.onStart(0x1FFFFFFF, this::start);
        lifecycle.onShutdown(0x1FFFFFFF, this::disconnect);
        lifecycle.onShutdown(0, this::shutdownDispatching);
    }

    public void start() {
        this.shutdownLatch.initialize();
    }

    public <R> Registration subscribe(@Nonnull String queryName, @Nonnull Type responseType, @Nonnull MessageHandler<? super QueryMessage<?, R>> handler) {
        Registration localRegistration = this.localSegment.subscribe(queryName, responseType, handler);
        QueryDefinition queryDefinition = new QueryDefinition(queryName, responseType);
        io.axoniq.axonserver.connector.Registration serverRegistration = this.axonServerConnectionManager.getConnection(this.context).queryChannel().registerQueryHandler((QueryHandler)this.localSegmentAdapter, new QueryDefinition[]{queryDefinition});
        return new AxonServerRegistration(localRegistration, () -> ((io.axoniq.axonserver.connector.Registration)serverRegistration).cancel());
    }

    public <Q, R> CompletableFuture<QueryResponseMessage<R>> query(@Nonnull QueryMessage<Q, R> queryMessage) {
        Span span = this.spanFactory.createQuerySpan(queryMessage, true).start();
        try (SpanScope unused = span.makeCurrent();){
            QueryMessage queryWithContext = this.spanFactory.propagateContext(queryMessage);
            Assert.isFalse((boolean)Publisher.class.isAssignableFrom(queryMessage.getResponseType().getExpectedResponseType()), () -> "The direct query does not support Flux as a return type.");
            this.shutdownLatch.ifShuttingDown("Cannot dispatch new queries as this bus is being shut down");
            QueryMessage interceptedQuery = this.dispatchInterceptors.intercept(queryWithContext);
            ShutdownLatch.ActivityHandle queryInTransit = this.shutdownLatch.registerActivity();
            CompletableFuture<QueryResponseMessage<R>> queryTransaction = new CompletableFuture<QueryResponseMessage<R>>();
            try {
                int priority = this.priorityCalculator.determinePriority(interceptedQuery);
                QueryRequest queryRequest = this.serialize(interceptedQuery, false, priority);
                ResultStream<QueryResponse> result = this.sendRequest(interceptedQuery, queryRequest);
                queryTransaction.whenComplete((r, e) -> result.close());
                Span responseTaskSpan = this.spanFactory.createResponseProcessingSpan(interceptedQuery);
                ResponseProcessingTask responseProcessingTask = new ResponseProcessingTask(result, this.serializer, queryTransaction, queryMessage.getResponseType(), responseTaskSpan);
                result.onAvailable(() -> this.queryExecutor.execute(new PriorityRunnable(responseProcessingTask, priority, TASK_SEQUENCE.incrementAndGet())));
            }
            catch (Exception e2) {
                logger.debug("There was a problem issuing a query {}.", (Object)interceptedQuery, (Object)e2);
                AxonException exception = ErrorCode.QUERY_DISPATCH_ERROR.convert(this.configuration.getClientId(), e2);
                queryTransaction.completeExceptionally((Throwable)exception);
                span.recordException((Throwable)e2).end();
            }
            queryTransaction.whenComplete((r, e) -> {
                queryInTransit.end();
                if (e != null) {
                    span.recordException(e);
                }
                if (r != null && r.isExceptional()) {
                    span.recordException(r.exceptionResult());
                }
                span.end();
            });
            CompletableFuture<QueryResponseMessage<R>> completableFuture = queryTransaction;
            return completableFuture;
        }
    }

    private QueryRequest serializeStreaming(QueryMessage<?, ?> query, int priority) {
        return this.serialize(query, true, priority);
    }

    private ShutdownLatch.ActivityHandle registerStreamingQueryActivity() {
        this.shutdownLatch.ifShuttingDown("Cannot dispatch new queries as this bus is being shut down");
        return this.shutdownLatch.registerActivity();
    }

    private QueryRequest serialize(QueryMessage<?, ?> query, boolean stream, int priority) {
        return this.serializer.serializeRequest(query, 1, DIRECT_QUERY_TIMEOUT_MS, priority, stream);
    }

    private ResultStream<QueryResponse> sendRequest(QueryMessage<?, ?> queryMessage, QueryRequest queryRequest) {
        return this.axonServerConnectionManager.getConnection(this.targetContextResolver.resolveContext(queryMessage)).queryChannel().query(queryRequest);
    }

    private <R> Publisher<QueryResponseMessage<R>> deserialize(StreamingQueryMessage<?, R> queryMessage, QueryResponse queryResponse) {
        Class expectedResponseType = queryMessage.getResponseType().getExpectedResponseType();
        QueryResponseMessage<?> responseMessage = this.serializer.deserializeResponse(queryResponse);
        if (responseMessage.isExceptional()) {
            return Flux.error((Throwable)responseMessage.exceptionResult());
        }
        if (expectedResponseType.isAssignableFrom(responseMessage.getPayloadType())) {
            InstanceResponseType instanceResponseType = new InstanceResponseType(expectedResponseType);
            return Flux.just((Object)new ConvertingResponseMessage((ResponseType)instanceResponseType, responseMessage));
        }
        MultipleInstancesResponseType multiResponseType = new MultipleInstancesResponseType(expectedResponseType);
        ConvertingResponseMessage convertingMessage = new ConvertingResponseMessage((ResponseType)multiResponseType, responseMessage);
        return Flux.fromStream(((List)convertingMessage.getPayload()).stream().map(payload -> this.singleMessage(responseMessage, payload, expectedResponseType)));
    }

    private <R> QueryResponseMessage<R> singleMessage(QueryResponseMessage<?> original, R newPayload, Class<R> expectedPayloadType) {
        GenericMessage delegate = new GenericMessage(original.getIdentifier(), expectedPayloadType, newPayload, (Map)original.getMetaData());
        return new GenericQueryResponseMessage((Message)delegate);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <Q, R> Stream<QueryResponseMessage<R>> scatterGather(@Nonnull QueryMessage<Q, R> queryMessage, long timeout, @Nonnull TimeUnit timeUnit) {
        Assert.isFalse((boolean)Publisher.class.isAssignableFrom(queryMessage.getResponseType().getExpectedResponseType()), () -> "The scatter-Gather query does not support Flux as a return type.");
        this.shutdownLatch.ifShuttingDown(String.format("Cannot dispatch new %s as this bus is being shut down", "scatter-gather queries"));
        ShutdownLatch.ActivityHandle queryInTransit = this.shutdownLatch.registerActivity();
        Span span = this.spanFactory.createScatterGatherSpan(queryMessage, true).start();
        try (SpanScope unused = span.makeCurrent();){
            QueryMessage interceptedQuery = this.dispatchInterceptors.intercept(this.spanFactory.propagateContext(queryMessage));
            long deadline = System.currentTimeMillis() + timeUnit.toMillis(timeout);
            String targetContext = this.targetContextResolver.resolveContext(interceptedQuery);
            QueryRequest queryRequest = this.serializer.serializeRequest(interceptedQuery, -1, timeUnit.toMillis(timeout), this.priorityCalculator.determinePriority(interceptedQuery));
            ResultStream queryResult = this.axonServerConnectionManager.getConnection(targetContext).queryChannel().query(queryRequest);
            Runnable closeHandler = () -> {
                queryInTransit.end();
                span.end();
            };
            Stream stream = (Stream)StreamSupport.stream(new QueryResponseSpliterator<Q, R>(queryMessage, (ResultStream<QueryResponse>)queryResult, deadline, this.serializer, closeHandler), false).onClose(closeHandler);
            return stream;
        }
        catch (Exception e) {
            logger.debug("There was a problem issuing a scatter-gather query {}.", queryMessage, (Object)e);
            queryInTransit.end();
            span.recordException((Throwable)e).end();
            throw e;
        }
    }

    @Deprecated
    public <Q, I, U> SubscriptionQueryResult<QueryResponseMessage<I>, SubscriptionQueryUpdateMessage<U>> subscriptionQuery(@Nonnull SubscriptionQueryMessage<Q, I, U> query, SubscriptionQueryBackpressure backPressure, int updateBufferSize) {
        return this.subscriptionQuery(query, updateBufferSize);
    }

    public <Q, I, U> SubscriptionQueryResult<QueryResponseMessage<I>, SubscriptionQueryUpdateMessage<U>> subscriptionQuery(@Nonnull SubscriptionQueryMessage<Q, I, U> query, int updateBufferSize) {
        Assert.isFalse((boolean)Publisher.class.isAssignableFrom(query.getResponseType().getExpectedResponseType()), () -> "The subscription Query query does not support Flux as a return type.");
        Assert.isFalse((boolean)Publisher.class.isAssignableFrom(query.getUpdateResponseType().getExpectedResponseType()), () -> "The subscription Query query does not support Flux as an update type.");
        this.shutdownLatch.ifShuttingDown(String.format("Cannot dispatch new %s as this bus is being shut down", "subscription queries"));
        Span span = this.spanFactory.createSubscriptionQuerySpan(query, true).start();
        try (SpanScope unused = span.makeCurrent();){
            SubscriptionQueryMessage interceptedQuery = (SubscriptionQueryMessage)this.dispatchInterceptors.intercept(this.spanFactory.propagateContext(query));
            String subscriptionId = interceptedQuery.getIdentifier();
            String targetContext = this.targetContextResolver.resolveContext((QueryMessage<?, ?>)interceptedQuery);
            logger.debug("Subscription Query requested with subscription Id [{}]", (Object)subscriptionId);
            io.axoniq.axonserver.connector.query.SubscriptionQueryResult result = this.axonServerConnectionManager.getConnection(targetContext).queryChannel().subscriptionQuery(this.subscriptionSerializer.serializeQuery(interceptedQuery), this.subscriptionSerializer.serializeUpdateType(interceptedQuery), this.configuration.getQueryFlowControl().getPermits().intValue(), this.configuration.getQueryFlowControl().getNrOfNewPermits().intValue());
            AxonServerSubscriptionQueryResult axonServerSubscriptionQueryResult = new AxonServerSubscriptionQueryResult(interceptedQuery, result, this.subscriptionSerializer, this.spanFactory, span);
            return axonServerSubscriptionQueryResult;
        }
    }

    public QueryUpdateEmitter queryUpdateEmitter() {
        return this.updateEmitter;
    }

    public QueryBus localSegment() {
        return this.localSegment;
    }

    public Registration registerHandlerInterceptor(@Nonnull MessageHandlerInterceptor<? super QueryMessage<?, ?>> interceptor) {
        return this.localSegment.registerHandlerInterceptor(interceptor);
    }

    @Nonnull
    public Registration registerDispatchInterceptor(@Nonnull MessageDispatchInterceptor<? super QueryMessage<?, ?>> dispatchInterceptor) {
        return this.dispatchInterceptors.registerDispatchInterceptor(dispatchInterceptor);
    }

    public void disconnect() {
        if (this.axonServerConnectionManager.isConnected(this.context)) {
            this.axonServerConnectionManager.getConnection(this.context).queryChannel().prepareDisconnect();
        }
        this.localSegmentAdapter.cancel();
    }

    public CompletableFuture<Void> shutdownDispatching() {
        return this.shutdownLatch.initiateShutdown();
    }

    private class LocalSegmentAdapter
    implements QueryHandler {
        private final Map<String, QueryProcessingTask> queriesInProgress = new ConcurrentHashMap<String, QueryProcessingTask>();

        private LocalSegmentAdapter() {
        }

        public void cancel() {
            this.queriesInProgress.values().iterator().forEachRemaining(QueryProcessingTask::cancel);
        }

        public void handle(QueryRequest query, ReplyChannel<QueryResponse> responseHandler) {
            this.stream(query, responseHandler).request(Long.MAX_VALUE);
        }

        public FlowControl stream(QueryRequest query, ReplyChannel<QueryResponse> responseHandler) {
            Runnable onClose = () -> this.queriesInProgress.remove(query.getMessageIdentifier());
            CloseAwareReplyChannel closeAwareReplyChannel = new CloseAwareReplyChannel(responseHandler, onClose);
            long priority = ProcessingInstructionHelper.priority(query.getProcessingInstructionsList());
            final QueryProcessingTask processingTask = new QueryProcessingTask(AxonServerQueryBus.this.localSegment, query, (ReplyChannel<QueryResponse>)closeAwareReplyChannel, AxonServerQueryBus.this.serializer, AxonServerQueryBus.this.configuration.getClientId(), AxonServerQueryBus.this.spanFactory);
            final PriorityRunnable priorityTask = new PriorityRunnable(processingTask, priority, TASK_SEQUENCE.incrementAndGet());
            this.queriesInProgress.put(query.getMessageIdentifier(), processingTask);
            AxonServerQueryBus.this.queryExecutor.execute(priorityTask);
            return new FlowControl(){

                public void request(long requested) {
                    AxonServerQueryBus.this.queryExecutor.execute(new PriorityRunnable(() -> processingTask.request(requested), priorityTask.priority(), TASK_SEQUENCE.incrementAndGet()));
                }

                public void cancel() {
                    AxonServerQueryBus.this.queryExecutor.execute(new PriorityRunnable(processingTask::cancel, priorityTask.priority(), TASK_SEQUENCE.incrementAndGet()));
                }
            };
        }

        public io.axoniq.axonserver.connector.Registration registerSubscriptionQuery(SubscriptionQuery query, QueryHandler.UpdateHandler sendUpdate) {
            UpdateHandlerRegistration updateHandler = AxonServerQueryBus.this.updateEmitter.registerUpdateHandler(AxonServerQueryBus.this.subscriptionSerializer.deserialize(query), 1024);
            updateHandler.getUpdates().doOnError(e -> {
                ErrorMessage error = ExceptionSerializer.serialize(AxonServerQueryBus.this.configuration.getClientId(), e);
                String errorCode = ErrorCode.getQueryExecutionErrorCode(e).errorCode();
                QueryUpdate queryUpdate = QueryUpdate.newBuilder().setErrorMessage(error).setErrorCode(errorCode).build();
                sendUpdate.sendUpdate(queryUpdate);
                sendUpdate.complete();
            }).doOnComplete(() -> ((QueryHandler.UpdateHandler)sendUpdate).complete()).map(AxonServerQueryBus.this.subscriptionSerializer::serialize).subscribe(arg_0 -> ((QueryHandler.UpdateHandler)sendUpdate).sendUpdate(arg_0));
            return () -> {
                updateHandler.getRegistration().close();
                return CompletableFuture.completedFuture(null);
            };
        }
    }

    private static class ResponseProcessingTask<R>
    implements Runnable {
        private final AtomicBoolean singleExecutionCheck = new AtomicBoolean();
        private final ResultStream<QueryResponse> result;
        private final QuerySerializer serializer;
        private final CompletableFuture<QueryResponseMessage<R>> queryTransaction;
        private final ResponseType<R> expectedResponseType;
        private final Span span;

        public ResponseProcessingTask(ResultStream<QueryResponse> result, QuerySerializer serializer, CompletableFuture<QueryResponseMessage<R>> queryTransaction, ResponseType<R> expectedResponseType, Span responseTaskSpan) {
            this.result = result;
            this.serializer = serializer;
            this.queryTransaction = queryTransaction;
            this.expectedResponseType = expectedResponseType;
            this.span = responseTaskSpan;
        }

        @Override
        public void run() {
            if (this.singleExecutionCheck.compareAndSet(false, true)) {
                QueryResponse nextAvailable = (QueryResponse)this.result.nextIfAvailable();
                if (nextAvailable != null) {
                    this.span.run(() -> this.queryTransaction.complete(this.serializer.deserializeResponse(nextAvailable, this.expectedResponseType)));
                } else if (this.result.isClosed() && !this.queryTransaction.isDone()) {
                    Exception exception = (Exception)this.result.getError().map(ErrorCode.QUERY_DISPATCH_ERROR::convert).orElse(new AxonServerQueryDispatchException(ErrorCode.QUERY_DISPATCH_ERROR.errorCode(), "Query did not yield the expected number of results."));
                    this.queryTransaction.completeExceptionally(exception);
                }
            }
        }
    }

    private static class QueryResponseSpliterator<Q, R>
    implements Spliterator<QueryResponseMessage<R>> {
        private final QueryMessage<Q, R> queryMessage;
        private final ResultStream<QueryResponse> queryResult;
        private final long deadline;
        private final QuerySerializer serializer;
        private final Runnable closeHandler;

        public QueryResponseSpliterator(QueryMessage<Q, R> queryMessage, ResultStream<QueryResponse> queryResult, long deadline, QuerySerializer serializer, Runnable closeHandler) {
            this.queryMessage = queryMessage;
            this.queryResult = queryResult;
            this.deadline = deadline;
            this.serializer = serializer;
            this.closeHandler = closeHandler;
        }

        @Override
        public boolean tryAdvance(Consumer<? super QueryResponseMessage<R>> action) {
            QueryResponse next;
            long remaining = this.deadline - System.currentTimeMillis();
            if (remaining > 0L) {
                try {
                    next = (QueryResponse)this.queryResult.nextIfAvailable(remaining, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    this.closeHandler.run();
                    return false;
                }
            } else {
                next = (QueryResponse)this.queryResult.nextIfAvailable();
            }
            if (next != null) {
                action.accept(this.serializer.deserializeResponse(next, this.queryMessage.getResponseType()));
                return true;
            }
            this.queryResult.close();
            this.closeHandler.run();
            return false;
        }

        @Override
        public Spliterator<QueryResponseMessage<R>> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return Long.MAX_VALUE;
        }

        @Override
        public int characteristics() {
            return 0;
        }
    }

    public static class Builder {
        private AxonServerConnectionManager axonServerConnectionManager;
        private AxonServerConfiguration configuration;
        private QueryBus localSegment;
        private QueryUpdateEmitter updateEmitter;
        private Serializer messageSerializer;
        private Serializer genericSerializer;
        private QueryPriorityCalculator priorityCalculator = QueryPriorityCalculator.defaultQueryPriorityCalculator();
        private TargetContextResolver<? super QueryMessage<?, ?>> targetContextResolver = q -> this.configuration.getContext();
        private ExecutorServiceBuilder executorServiceBuilder = ExecutorServiceBuilder.defaultQueryExecutorServiceBuilder();
        private String defaultContext;
        private QueryBusSpanFactory spanFactory = DefaultQueryBusSpanFactory.builder().spanFactory((SpanFactory)NoOpSpanFactory.INSTANCE).build();

        public Builder axonServerConnectionManager(AxonServerConnectionManager axonServerConnectionManager) {
            BuilderUtils.assertNonNull((Object)axonServerConnectionManager, (String)"AxonServerConnectionManager may not be null");
            this.axonServerConnectionManager = axonServerConnectionManager;
            return this;
        }

        public Builder configuration(AxonServerConfiguration configuration) {
            BuilderUtils.assertNonNull((Object)configuration, (String)"AxonServerConfiguration may not be null");
            this.configuration = configuration;
            return this;
        }

        public Builder localSegment(QueryBus localSegment) {
            BuilderUtils.assertNonNull((Object)localSegment, (String)"Local QueryBus may not be null");
            this.localSegment = localSegment;
            return this;
        }

        public Builder updateEmitter(QueryUpdateEmitter updateEmitter) {
            BuilderUtils.assertNonNull((Object)updateEmitter, (String)"QueryUpdateEmitter may not be null");
            this.updateEmitter = updateEmitter;
            return this;
        }

        public Builder messageSerializer(Serializer messageSerializer) {
            BuilderUtils.assertNonNull((Object)messageSerializer, (String)"Message Serializer may not be null");
            this.messageSerializer = messageSerializer;
            return this;
        }

        public Builder genericSerializer(Serializer genericSerializer) {
            BuilderUtils.assertNonNull((Object)genericSerializer, (String)"Generic Serializer may not be null");
            this.genericSerializer = genericSerializer;
            return this;
        }

        public Builder priorityCalculator(QueryPriorityCalculator priorityCalculator) {
            BuilderUtils.assertNonNull(this.targetContextResolver, (String)"QueryPriorityCalculator may not be null");
            this.priorityCalculator = priorityCalculator;
            return this;
        }

        public Builder targetContextResolver(TargetContextResolver<? super QueryMessage<?, ?>> targetContextResolver) {
            BuilderUtils.assertNonNull(targetContextResolver, (String)"TargetContextResolver may not be null");
            this.targetContextResolver = targetContextResolver;
            return this;
        }

        public Builder executorServiceBuilder(ExecutorServiceBuilder executorServiceBuilder) {
            BuilderUtils.assertNonNull((Object)executorServiceBuilder, (String)"ExecutorServiceBuilder may not be null");
            this.executorServiceBuilder = executorServiceBuilder;
            return this;
        }

        @Deprecated
        public Builder requestStreamFactory(Function<UpstreamAwareStreamObserver<QueryProviderInbound>, StreamObserver<QueryProviderOutbound>> requestStreamFactory) {
            return this;
        }

        @Deprecated
        public Builder instructionAckSource(InstructionAckSource<QueryProviderOutbound> instructionAckSource) {
            return this;
        }

        public Builder defaultContext(String defaultContext) {
            BuilderUtils.assertNonEmpty((String)defaultContext, (String)"The context may not be null or empty");
            this.defaultContext = defaultContext;
            return this;
        }

        @Deprecated
        public Builder spanFactory(@Nonnull SpanFactory spanFactory) {
            BuilderUtils.assertNonNull((Object)spanFactory, (String)"The SpanFactory may not be null or empty");
            this.spanFactory = DefaultQueryBusSpanFactory.builder().spanFactory(spanFactory).build();
            return this;
        }

        public Builder spanFactory(@Nonnull QueryBusSpanFactory spanFactory) {
            BuilderUtils.assertNonNull((Object)spanFactory, (String)"SpanFactory may not be null");
            this.spanFactory = spanFactory;
            return this;
        }

        public AxonServerQueryBus build() {
            return new AxonServerQueryBus(this);
        }

        protected QuerySerializer buildQuerySerializer() {
            return new QuerySerializer(this.messageSerializer, this.genericSerializer, this.configuration);
        }

        protected SubscriptionMessageSerializer buildSubscriptionMessageSerializer() {
            return new SubscriptionMessageSerializer(this.messageSerializer, this.genericSerializer, this.configuration);
        }

        protected void validate() throws AxonConfigurationException {
            BuilderUtils.assertNonNull((Object)this.axonServerConnectionManager, (String)"The AxonServerConnectionManager is a hard requirement and should be provided");
            BuilderUtils.assertNonNull((Object)this.configuration, (String)"The AxonServerConfiguration is a hard requirement and should be provided");
            BuilderUtils.assertNonNull((Object)this.localSegment, (String)"The Local QueryBus is a hard requirement and should be provided");
            BuilderUtils.assertNonNull((Object)this.updateEmitter, (String)"The QueryUpdateEmitter is a hard requirement and should be provided");
            BuilderUtils.assertNonNull((Object)this.messageSerializer, (String)"The Message Serializer is a hard requirement and should be provided");
            BuilderUtils.assertNonNull((Object)this.genericSerializer, (String)"The Generic Serializer is a hard requirement and should be provided");
        }
    }

    private static class ActivityFinisher
    implements Consumer<SignalType> {
        private final ShutdownLatch.ActivityHandle activity;
        private final Span span;

        private ActivityFinisher(ShutdownLatch.ActivityHandle activity, Span span) {
            this.activity = activity;
            this.span = span;
        }

        @Override
        public void accept(SignalType signalType) {
            this.span.end();
            this.activity.end();
        }
    }
}

