/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.springboot.autoconfig;

import java.util.List;
import java.util.Optional;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.gateway.CommandGateway;
import org.axonframework.config.ConfigurerModule;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.gateway.EventGateway;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.queryhandling.QueryBus;
import org.axonframework.queryhandling.QueryGateway;
import org.axonframework.queryhandling.QueryMessage;
import org.axonframework.spring.config.SpringConfigurer;
import org.axonframework.springboot.autoconfig.AxonAutoConfiguration;
import org.axonframework.springboot.autoconfig.JpaAutoConfiguration;
import org.axonframework.springboot.autoconfig.JpaEventStoreAutoConfiguration;
import org.axonframework.springboot.autoconfig.NoOpTransactionAutoConfiguration;
import org.axonframework.springboot.autoconfig.TransactionAutoConfiguration;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnClass(value={SpringConfigurer.class})
@AutoConfigureAfter(value={AxonAutoConfiguration.class, JpaAutoConfiguration.class, JpaEventStoreAutoConfiguration.class, NoOpTransactionAutoConfiguration.class, TransactionAutoConfiguration.class})
public class InterceptorAutoConfiguration {
    @Bean
    @ConditionalOnBean(value={MessageDispatchInterceptor.class})
    public ConfigurerModule commandDispatchInterceptorConfigurer(Optional<List<MessageDispatchInterceptor<? super CommandMessage<?>>>> interceptors) {
        return configurer -> configurer.onInitialize(configuration -> interceptors.ifPresent(it -> it.forEach(arg_0 -> ((CommandGateway)configuration.commandGateway()).registerDispatchInterceptor(arg_0))));
    }

    @Bean
    @ConditionalOnBean(value={MessageDispatchInterceptor.class})
    public InitializingBean eventDispatchInterceptorConfigurer(EventGateway eventGateway, Optional<List<MessageDispatchInterceptor<? super EventMessage<?>>>> interceptors) {
        return () -> interceptors.ifPresent(it -> it.forEach(arg_0 -> ((EventGateway)eventGateway).registerDispatchInterceptor(arg_0)));
    }

    @Bean
    @ConditionalOnBean(value={MessageDispatchInterceptor.class})
    public ConfigurerModule queryDispatchInterceptorConfigurer(Optional<List<MessageDispatchInterceptor<? super QueryMessage<?, ?>>>> interceptors) {
        return configurer -> configurer.onInitialize(configuration -> interceptors.ifPresent(it -> it.forEach(arg_0 -> ((QueryGateway)configuration.queryGateway()).registerDispatchInterceptor(arg_0))));
    }

    @Bean
    @ConditionalOnBean(value={MessageHandlerInterceptor.class})
    public ConfigurerModule commandHandlerInterceptorConfigurer(Optional<List<MessageHandlerInterceptor<? super CommandMessage<?>>>> interceptors) {
        return configurer -> configurer.onInitialize(configuration -> interceptors.ifPresent(it -> it.forEach(arg_0 -> ((CommandBus)configuration.commandBus()).registerHandlerInterceptor(arg_0))));
    }

    @Bean
    public ConfigurerModule messageHandlerInterceptorConfigurer(Optional<List<MessageHandlerInterceptor<? super EventMessage<?>>>> interceptors) {
        return configurer -> interceptors.ifPresent(it -> it.forEach(i -> configurer.eventProcessing().registerDefaultHandlerInterceptor((c, n) -> i)));
    }

    @Bean
    @ConditionalOnBean(value={MessageHandlerInterceptor.class})
    public ConfigurerModule queryHandlerInterceptorConfigurer(Optional<List<MessageHandlerInterceptor<? super QueryMessage<?, ?>>>> interceptors) {
        return configurer -> configurer.onInitialize(configuration -> interceptors.ifPresent(it -> it.forEach(arg_0 -> ((QueryBus)configuration.queryBus()).registerHandlerInterceptor(arg_0))));
    }
}

