/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.springboot.autoconfig;

import java.time.temporal.TemporalAmount;
import javax.sql.DataSource;
import org.axonframework.common.jdbc.ConnectionProvider;
import org.axonframework.common.jdbc.PersistenceExceptionResolver;
import org.axonframework.common.jdbc.UnitOfWorkAwareConnectionProviderWrapper;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.config.Configuration;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.deadletter.jdbc.DeadLetterSchema;
import org.axonframework.eventhandling.deadletter.jdbc.JdbcSequencedDeadLetterQueue;
import org.axonframework.eventhandling.tokenstore.TokenStore;
import org.axonframework.eventhandling.tokenstore.jdbc.JdbcTokenStore;
import org.axonframework.eventhandling.tokenstore.jdbc.TokenSchema;
import org.axonframework.eventsourcing.eventstore.EventStorageEngine;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.axonframework.eventsourcing.eventstore.jdbc.EventSchema;
import org.axonframework.eventsourcing.eventstore.jdbc.JdbcEventStorageEngine;
import org.axonframework.eventsourcing.eventstore.jdbc.JdbcSQLErrorCodesResolver;
import org.axonframework.modelling.saga.repository.SagaStore;
import org.axonframework.modelling.saga.repository.jdbc.GenericSagaSqlSchema;
import org.axonframework.modelling.saga.repository.jdbc.JdbcSagaStore;
import org.axonframework.modelling.saga.repository.jdbc.SagaSqlSchema;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.upcasting.event.EventUpcaster;
import org.axonframework.spring.jdbc.SpringDataSourceConnectionProvider;
import org.axonframework.springboot.EventProcessorProperties;
import org.axonframework.springboot.TokenStoreProperties;
import org.axonframework.springboot.autoconfig.JpaAutoConfiguration;
import org.axonframework.springboot.autoconfig.JpaEventStoreAutoConfiguration;
import org.axonframework.springboot.util.DeadLetterQueueProviderConfigurerModule;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnBean(value={DataSource.class})
@EnableConfigurationProperties(value={TokenStoreProperties.class})
@AutoConfigureAfter(value={JpaAutoConfiguration.class, JpaEventStoreAutoConfiguration.class})
public class JdbcAutoConfiguration {
    private final TokenStoreProperties tokenStoreProperties;

    public JdbcAutoConfiguration(TokenStoreProperties tokenStoreProperties) {
        this.tokenStoreProperties = tokenStoreProperties;
    }

    @Bean
    @ConditionalOnMissingBean(value={EventStorageEngine.class, EventSchema.class})
    public EventSchema eventSchema() {
        return new EventSchema();
    }

    @Bean
    @ConditionalOnMissingBean(value={EventStorageEngine.class, EventBus.class})
    public EventStorageEngine eventStorageEngine(Serializer defaultSerializer, PersistenceExceptionResolver persistenceExceptionResolver, @Qualifier(value="eventSerializer") Serializer eventSerializer, Configuration configuration, ConnectionProvider connectionProvider, TransactionManager transactionManager, EventSchema eventSchema) {
        return JdbcEventStorageEngine.builder().snapshotSerializer(defaultSerializer).upcasterChain((EventUpcaster)configuration.upcasterChain()).persistenceExceptionResolver(persistenceExceptionResolver).eventSerializer(eventSerializer).snapshotFilter(configuration.snapshotFilter()).connectionProvider(connectionProvider).transactionManager(transactionManager).schema(eventSchema).build();
    }

    @Bean
    @ConditionalOnMissingBean(value={PersistenceExceptionResolver.class, EventStore.class})
    public PersistenceExceptionResolver jdbcSQLErrorCodesResolver() {
        return new JdbcSQLErrorCodesResolver();
    }

    @Bean
    @ConditionalOnMissingBean
    public ConnectionProvider connectionProvider(DataSource dataSource) {
        return new UnitOfWorkAwareConnectionProviderWrapper((ConnectionProvider)new SpringDataSourceConnectionProvider(dataSource));
    }

    @Bean
    @ConditionalOnMissingBean(value={TokenStore.class, TokenSchema.class})
    public TokenSchema tokenSchema() {
        return new TokenSchema();
    }

    @Bean
    @ConditionalOnMissingBean(value={TokenStore.class})
    public TokenStore tokenStore(ConnectionProvider connectionProvider, Serializer serializer, TokenSchema tokenSchema) {
        return JdbcTokenStore.builder().connectionProvider(connectionProvider).schema(tokenSchema).serializer(serializer).claimTimeout((TemporalAmount)this.tokenStoreProperties.getClaimTimeout()).build();
    }

    @Bean
    @ConditionalOnMissingBean(value={SagaStore.class, SagaSqlSchema.class})
    public JdbcSagaStore sagaStoreNoSchema(ConnectionProvider connectionProvider, Serializer serializer) {
        return JdbcSagaStore.builder().connectionProvider(connectionProvider).sqlSchema((SagaSqlSchema)new GenericSagaSqlSchema()).serializer(serializer).build();
    }

    @Bean
    @ConditionalOnMissingBean(value={SagaStore.class})
    @ConditionalOnBean(value={SagaSqlSchema.class})
    public JdbcSagaStore sagaStoreWithSchema(ConnectionProvider connectionProvider, Serializer serializer, SagaSqlSchema schema) {
        return JdbcSagaStore.builder().connectionProvider(connectionProvider).sqlSchema(schema).serializer(serializer).build();
    }

    @Bean
    @ConditionalOnMissingBean
    public DeadLetterSchema deadLetterSchema() {
        return DeadLetterSchema.defaultSchema();
    }

    @Bean
    @ConditionalOnMissingBean
    public DeadLetterQueueProviderConfigurerModule deadLetterQueueProviderConfigurerModule(EventProcessorProperties eventProcessorProperties, ConnectionProvider connectionProvider, TransactionManager transactionManager, DeadLetterSchema schema, @Qualifier(value="eventSerializer") Serializer eventSerializer, Serializer genericSerializer) {
        return new DeadLetterQueueProviderConfigurerModule(eventProcessorProperties, processingGroup -> config -> JdbcSequencedDeadLetterQueue.builder().processingGroup(processingGroup).connectionProvider(connectionProvider).transactionManager(transactionManager).schema(schema).genericSerializer(genericSerializer).eventSerializer(eventSerializer).build());
    }
}

