/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.authorization;

import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.axonframework.common.annotation.AnnotationUtils;
import org.axonframework.messaging.InterceptorChain;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.unitofwork.UnitOfWork;
import org.axonframework.spring.authorization.UnauthorizedMessageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.annotation.Secured;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class MessageAuthorizationHandlerInterceptor<T extends Message<?>>
implements MessageHandlerInterceptor<T> {
    private static final Logger logger = LoggerFactory.getLogger(MessageAuthorizationHandlerInterceptor.class);

    public Object handle(@Nonnull UnitOfWork<? extends T> unitOfWork, @Nonnull InterceptorChain interceptorChain) throws Exception {
        Message message = unitOfWork.getMessage();
        if (!AnnotationUtils.isAnnotationPresent((AnnotatedElement)message.getPayloadType(), Secured.class)) {
            return interceptorChain.proceed();
        }
        Secured annotation = message.getPayloadType().getAnnotation(Secured.class);
        Set authorities = Optional.ofNullable(message.getMetaData().get((Object)"authorities")).map(authorityMetaData -> {
            if (logger.isDebugEnabled()) {
                logger.debug("Found authorities [{}]", authorityMetaData);
            }
            return new HashSet((List)authorityMetaData);
        }).orElseThrow(() -> new UnauthorizedMessageException("No authorities found for message with identifier [" + message.getIdentifier() + "]"));
        if (logger.isDebugEnabled()) {
            logger.debug("Authorizing for [{}] and [{}]", (Object)message.getPayloadType().getName(), (Object)annotation.value());
        }
        authorities.retainAll(Arrays.stream(annotation.value()).map(SimpleGrantedAuthority::new).collect(Collectors.toSet()));
        if (!authorities.isEmpty()) {
            return interceptorChain.proceed();
        }
        throw new UnauthorizedMessageException("Unauthorized message with identifier [" + message.getIdentifier() + "]");
    }
}

