/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.integrationtests.deadline;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.awaitility.Awaitility;
import org.axonframework.commandhandling.CommandHandler;
import org.axonframework.common.AxonNonTransientException;
import org.axonframework.config.Configuration;
import org.axonframework.config.Configurer;
import org.axonframework.config.DefaultConfigurer;
import org.axonframework.deadline.DeadlineManager;
import org.axonframework.deadline.GenericDeadlineMessage;
import org.axonframework.deadline.annotation.DeadlineHandler;
import org.axonframework.eventhandling.DefaultEventBusSpanFactory;
import org.axonframework.eventhandling.EventBusSpanFactory;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.eventhandling.Timestamp;
import org.axonframework.eventsourcing.EventSourcingHandler;
import org.axonframework.eventsourcing.eventstore.EmbeddedEventStore;
import org.axonframework.eventsourcing.eventstore.EventStorageEngine;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.axonframework.eventsourcing.eventstore.inmemory.InMemoryEventStorageEngine;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.correlation.MessageOriginProvider;
import org.axonframework.messaging.correlation.SimpleCorrelationDataProvider;
import org.axonframework.messaging.interceptors.CorrelationDataInterceptor;
import org.axonframework.modelling.command.AggregateCreationPolicy;
import org.axonframework.modelling.command.AggregateIdentifier;
import org.axonframework.modelling.command.AggregateLifecycle;
import org.axonframework.modelling.command.AggregateMember;
import org.axonframework.modelling.command.CreationPolicy;
import org.axonframework.modelling.command.EntityId;
import org.axonframework.modelling.command.TargetAggregateIdentifier;
import org.axonframework.modelling.saga.AssociationValue;
import org.axonframework.modelling.saga.EndSaga;
import org.axonframework.modelling.saga.SagaEventHandler;
import org.axonframework.modelling.saga.StartSaga;
import org.axonframework.modelling.saga.repository.SagaStore;
import org.axonframework.tracing.SpanFactory;
import org.axonframework.tracing.TestSpanFactory;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractDeadlineManagerTestSuite {
    private static final int DEADLINE_TIMEOUT = 100;
    private static final int DEADLINE_WAIT_THRESHOLD = 1500;
    private static final int CHILD_ENTITY_DEADLINE_TIMEOUT = 250;
    private static final UUID IDENTIFIER = UUID.randomUUID();
    private static final UUID FAKE_IDENTIFIER = UUID.randomUUID();
    private static final boolean CANCEL_BEFORE_DEADLINE = true;
    private static final boolean DO_NOT_CANCEL_BEFORE_DEADLINE = false;
    private static final String END_SAGA = "end-saga";
    private static final UUID SAGA_ENDED = UUID.randomUUID();
    private static final boolean LIVE = false;
    private static final boolean CLOSED = true;
    private static final boolean DO_NOT_AUTO_LOCATE_CONFIGURER_MODULES = false;
    private static final String CUSTOM_CORRELATION_DATA_KEY = "custom-correlation-data";
    protected Configuration configuration;
    protected TestSpanFactory spanFactory;
    private List<Message<?>> publishedMessages;
    private DeadlineManager deadlineManager;
    private String managerName;

    @BeforeEach
    void setUp() {
        this.spanFactory = new TestSpanFactory();
        EventStore eventStore = (EventStore)Mockito.spy((Object)EmbeddedEventStore.builder().storageEngine((EventStorageEngine)new InMemoryEventStorageEngine()).spanFactory((EventBusSpanFactory)DefaultEventBusSpanFactory.builder().spanFactory((SpanFactory)this.spanFactory).build()).build());
        ArrayList<Object> correlationDataProviders = new ArrayList<Object>();
        correlationDataProviders.add(new MessageOriginProvider());
        correlationDataProviders.add(new SimpleCorrelationDataProvider(new String[]{CUSTOM_CORRELATION_DATA_KEY}));
        Configurer configurer = DefaultConfigurer.defaultConfiguration((boolean)false);
        configurer.eventProcessing().usingSubscribingEventProcessors().registerSaga(MySaga.class);
        this.configuration = configurer.configureEventStore(c -> eventStore).configureCorrelationDataProviders(config -> correlationDataProviders).configureAggregate(MyAggregate.class).registerComponent(DeadlineManager.class, this::buildAndSpyDeadlineManager).configureSpanFactory(c -> this.spanFactory).start();
        this.publishedMessages = new CopyOnWriteArrayList();
        this.configuration.eventBus().subscribe(events -> this.publishedMessages.addAll((Collection<Message<?>>)events));
    }

    private DeadlineManager buildAndSpyDeadlineManager(Configuration configuration) {
        DeadlineManager builtManager = this.buildDeadlineManager(configuration);
        builtManager.registerHandlerInterceptor((MessageHandlerInterceptor)new CorrelationDataInterceptor((Collection)configuration.correlationDataProviders()));
        this.managerName = builtManager.getClass().getSimpleName();
        this.deadlineManager = (DeadlineManager)Mockito.spy((Object)builtManager);
        return this.deadlineManager;
    }

    @AfterEach
    void tearDown() {
        this.configuration.shutdown();
    }

    public abstract DeadlineManager buildDeadlineManager(Configuration var1);

    @Test
    void deadlineOnAggregate() {
        this.configuration.commandGateway().sendAndWait((Object)new CreateMyAggregateCommand(IDENTIFIER, 100));
        Instant afterDeadlineWasScheduled = Instant.now().plusMillis(50L);
        this.assertPublishedEvents(new MyAggregateCreatedEvent(IDENTIFIER), new DeadlineOccurredEvent(new DeadlinePayload(IDENTIFIER)));
        Message<?> aggregateCreatedEvent = this.publishedMessages.get(0);
        Assertions.assertTrue((boolean)(aggregateCreatedEvent instanceof GenericEventMessage));
        Assertions.assertTrue((boolean)afterDeadlineWasScheduled.isAfter(((GenericEventMessage)aggregateCreatedEvent).getTimestamp()));
        Message<?> deadLineEvent = this.publishedMessages.get(1);
        Assertions.assertTrue((boolean)(deadLineEvent instanceof GenericEventMessage));
        Assertions.assertTrue((boolean)afterDeadlineWasScheduled.isBefore(((GenericEventMessage)deadLineEvent).getTimestamp()));
    }

    @Test
    void deadlineScheduleAndExecutionIsTraced() {
        String scheduledDeadlineId = (String)this.configuration.commandGateway().sendAndWait((Object)new CreateMyAggregateCommand(IDENTIFIER, 100));
        this.assertPublishedEvents(new MyAggregateCreatedEvent(IDENTIFIER), new DeadlineOccurredEvent(new DeadlinePayload(IDENTIFIER)));
        this.spanFactory.verifySpanCompleted("DeadlineManager.scheduleDeadline(deadlineName)");
        this.spanFactory.verifySpanHasAttributeValue("DeadlineManager.scheduleDeadline(deadlineName)", "axon.deadlineId", scheduledDeadlineId);
        Awaitility.await().pollDelay(Duration.ofMillis(50L)).atMost(Duration.ofMillis(100L)).untilAsserted(() -> this.spanFactory.verifySpanCompleted("DeadlineManager.executeDeadline(deadlineName)"));
        this.spanFactory.verifySpanHasAttributeValue("DeadlineManager.executeDeadline(deadlineName)", "axon.deadlineId", scheduledDeadlineId);
    }

    @Test
    public void deadlineCancellationWithinScopeOnAggregate() {
        this.configuration.commandGateway().sendAndWait((Object)new CreateMyAggregateCommand(IDENTIFIER));
        this.configuration.commandGateway().sendAndWait((Object)new ScheduleSpecificDeadline(IDENTIFIER, "some-payload"));
        this.configuration.commandGateway().sendAndWait((Object)new ScheduleSpecificDeadline(IDENTIFIER, "some-payload"));
        this.configuration.commandGateway().sendAndWait((Object)new ScheduleSpecificDeadline(IDENTIFIER, null));
        this.configuration.commandGateway().sendAndWait((Object)new CancelDeadlineWithinScope(IDENTIFIER));
        this.spanFactory.verifySpanCompleted("DeadlineManager.cancelAllWithinScope(deadlineName)");
        this.spanFactory.verifySpanCompleted("DeadlineManager.cancelAllWithinScope(specificDeadlineName)");
        this.spanFactory.verifySpanCompleted("DeadlineManager.cancelAllWithinScope(payloadlessDeadline)");
        this.assertPublishedEvents(new MyAggregateCreatedEvent(IDENTIFIER));
    }

    @Test
    void deadlineCancellationOnAggregate() {
        this.configuration.commandGateway().sendAndWait((Object)new CreateMyAggregateCommand(IDENTIFIER, 100, true));
        this.assertPublishedEvents(new MyAggregateCreatedEvent(IDENTIFIER));
    }

    @Test
    void deadlineOnChildEntity() {
        this.configuration.commandGateway().sendAndWait((Object)new CreateMyAggregateCommand(IDENTIFIER, 100));
        this.configuration.commandGateway().sendAndWait((Object)new TriggerDeadlineInChildEntityCommand(IDENTIFIER));
        this.assertPublishedEvents(new MyAggregateCreatedEvent(IDENTIFIER), new DeadlineOccurredInChildEvent(new EntityDeadlinePayload("entity" + IDENTIFIER)), new DeadlineOccurredEvent(new DeadlinePayload(IDENTIFIER)));
    }

    @Test
    void deadlineWithSpecifiedDeadlineName() {
        String expectedDeadlinePayload = "deadlinePayload";
        this.configuration.commandGateway().sendAndWait((Object)new CreateMyAggregateCommand(IDENTIFIER, 100, true));
        this.configuration.commandGateway().sendAndWait((Object)new ScheduleSpecificDeadline(IDENTIFIER, expectedDeadlinePayload));
        this.assertPublishedEvents(new MyAggregateCreatedEvent(IDENTIFIER), new SpecificDeadlineOccurredEvent(expectedDeadlinePayload));
    }

    @Test
    void deadlineCancellationOnAggregateIsTracedCorrectly() {
        this.configuration.commandGateway().sendAndWait((Object)new CreateMyAggregateCommand(IDENTIFIER, 100, true));
        this.assertPublishedEvents(new MyAggregateCreatedEvent(IDENTIFIER));
        ArgumentCaptor captor = ArgumentCaptor.forClass(String.class);
        ((DeadlineManager)Mockito.verify((Object)this.deadlineManager)).cancelSchedule((String)Mockito.any(), (String)captor.capture());
        this.spanFactory.verifySpanCompleted("DeadlineManager.cancelDeadline(deadlineName)");
    }

    @Test
    public void deadlineCancelAllOnAggregateIsTracedCorrectly() {
        this.configuration.commandGateway().sendAndWait((Object)new CreateMyAggregateCommand(IDENTIFIER, 100, false));
        this.configuration.commandGateway().sendAndWait((Object)new CancelAllDeadlinesWithName(IDENTIFIER));
        this.assertPublishedEvents(new MyAggregateCreatedEvent(IDENTIFIER));
        this.spanFactory.verifySpanCompleted("DeadlineManager.cancelAllDeadlines(deadlineName)");
    }

    @Test
    void deadlineWithoutPayload() {
        this.configuration.commandGateway().sendAndWait((Object)new CreateMyAggregateCommand(IDENTIFIER, 100, true));
        this.configuration.commandGateway().sendAndWait((Object)new ScheduleSpecificDeadline(IDENTIFIER, null));
        this.assertPublishedEvents(new MyAggregateCreatedEvent(IDENTIFIER), new SpecificDeadlineOccurredEvent(null));
    }

    @Test
    void handlerInterceptorOnAggregate() {
        this.configuration.deadlineManager().registerHandlerInterceptor((uow, chain) -> {
            uow.transformMessage(deadlineMessage -> GenericDeadlineMessage.asDeadlineMessage((String)deadlineMessage.getDeadlineName(), (Object)new DeadlinePayload(FAKE_IDENTIFIER), (Instant)deadlineMessage.getTimestamp()));
            return chain.proceed();
        });
        this.configuration.commandGateway().sendAndWait((Object)new CreateMyAggregateCommand(IDENTIFIER, 100));
        this.assertPublishedEvents(new MyAggregateCreatedEvent(IDENTIFIER), new DeadlineOccurredEvent(new DeadlinePayload(FAKE_IDENTIFIER)));
    }

    @Test
    void dispatchInterceptorOnAggregate() {
        this.configuration.deadlineManager().registerDispatchInterceptor(messages -> (i, m) -> GenericDeadlineMessage.asDeadlineMessage((String)m.getDeadlineName(), (Object)new DeadlinePayload(FAKE_IDENTIFIER), (Instant)m.getTimestamp()));
        this.configuration.commandGateway().sendAndWait((Object)new CreateMyAggregateCommand(IDENTIFIER));
        this.assertPublishedEvents(new MyAggregateCreatedEvent(IDENTIFIER), new DeadlineOccurredEvent(new DeadlinePayload(FAKE_IDENTIFIER)));
    }

    @Test
    void deadlineMessagesReceiveCorrelationDataThroughAggregate() {
        String expectedCorrelationData = "customValue";
        CustomCorrelationDataDispatchInterceptor correlationDataDispatchInterceptor = new CustomCorrelationDataDispatchInterceptor(expectedCorrelationData);
        this.configuration.commandGateway().registerDispatchInterceptor((MessageDispatchInterceptor)correlationDataDispatchInterceptor);
        this.configuration.commandGateway().sendAndWait((Object)new CreateMyAggregateCommand(IDENTIFIER));
        this.assertPublishedEvents(new MyAggregateCreatedEvent(IDENTIFIER), new DeadlineOccurredEvent(new DeadlinePayload(IDENTIFIER)));
        Message<?> aggregateCreatedEvent = this.publishedMessages.get(0);
        Assertions.assertTrue((boolean)aggregateCreatedEvent.getMetaData().containsKey((Object)CUSTOM_CORRELATION_DATA_KEY));
        Assertions.assertEquals((Object)expectedCorrelationData, (Object)aggregateCreatedEvent.getMetaData().get((Object)CUSTOM_CORRELATION_DATA_KEY));
        Message<?> deadLineEvent = this.publishedMessages.get(1);
        Assertions.assertTrue((boolean)deadLineEvent.getMetaData().containsKey((Object)CUSTOM_CORRELATION_DATA_KEY));
        Assertions.assertEquals((Object)expectedCorrelationData, (Object)deadLineEvent.getMetaData().get((Object)CUSTOM_CORRELATION_DATA_KEY));
    }

    @Test
    void scheduleInPastTriggersDeadline() {
        this.configuration.commandGateway().sendAndWait((Object)new CreateMyAggregateCommand(IDENTIFIER, -10000));
        this.assertPublishedEvents(new MyAggregateCreatedEvent(IDENTIFIER), new DeadlineOccurredEvent(new DeadlinePayload(IDENTIFIER)));
    }

    @Test
    void failedExecution() {
        this.configuration.deadlineManager().registerHandlerInterceptor((uow, interceptorChain) -> {
            interceptorChain.proceed();
            throw new AxonNonTransientException("Simulating handling error"){};
        });
        this.configuration.commandGateway().sendAndWait((Object)new CreateMyAggregateCommand(IDENTIFIER));
        this.assertPublishedEvents(new MyAggregateCreatedEvent(IDENTIFIER));
    }

    @Test
    void deadlineOnSaga() {
        EventMessage testEventMessage = GenericEventMessage.asEventMessage((Object)new SagaStartingEvent(IDENTIFIER, false));
        this.configuration.eventStore().publish(new EventMessage[]{testEventMessage});
        this.assertPublishedEvents(new SagaStartingEvent(IDENTIFIER, false), new DeadlineOccurredEvent(new DeadlinePayload(IDENTIFIER)));
        this.assertSagaIs(false);
    }

    @Test
    public void deadlineCancellationWithinScopeOnSaga() {
        SagaStartingEvent sagaStartingEvent = new SagaStartingEvent(IDENTIFIER, false);
        ScheduleSpecificDeadline firstSchedule = new ScheduleSpecificDeadline(IDENTIFIER, "some-payload");
        ScheduleSpecificDeadline secondSchedule = new ScheduleSpecificDeadline(IDENTIFIER, "some-payload");
        ScheduleSpecificDeadline thirdSchedule = new ScheduleSpecificDeadline(IDENTIFIER, null);
        CancelDeadlineWithinScope scheduleCancellation = new CancelDeadlineWithinScope(IDENTIFIER);
        this.configuration.eventStore().publish(new EventMessage[]{GenericEventMessage.asEventMessage((Object)sagaStartingEvent)});
        this.configuration.eventStore().publish(new EventMessage[]{GenericEventMessage.asEventMessage((Object)firstSchedule)});
        this.configuration.eventStore().publish(new EventMessage[]{GenericEventMessage.asEventMessage((Object)secondSchedule)});
        this.configuration.eventStore().publish(new EventMessage[]{GenericEventMessage.asEventMessage((Object)thirdSchedule)});
        this.configuration.eventStore().publish(new EventMessage[]{GenericEventMessage.asEventMessage((Object)scheduleCancellation)});
        this.assertPublishedEvents(sagaStartingEvent, firstSchedule, secondSchedule, thirdSchedule, scheduleCancellation);
        this.assertSagaIs(false);
        this.spanFactory.verifySpanCompleted("DeadlineManager.cancelAllWithinScope(deadlineName)");
        this.spanFactory.verifySpanCompleted("DeadlineManager.cancelAllWithinScope(specificDeadlineName)");
        this.spanFactory.verifySpanCompleted("DeadlineManager.cancelAllWithinScope(payloadlessDeadline)");
    }

    @Test
    void deadlineCancellationOnSaga() {
        this.configuration.eventStore().publish(new EventMessage[]{GenericEventMessage.asEventMessage((Object)new SagaStartingEvent(IDENTIFIER, true))});
        this.assertPublishedEvents(new SagaStartingEvent(IDENTIFIER, true));
        this.assertSagaIs(false);
    }

    @Test
    void deadlineCancellationOnSagaIsCorrectlyTraced() {
        this.configuration.eventStore().publish(new EventMessage[]{GenericEventMessage.asEventMessage((Object)new SagaStartingEvent(IDENTIFIER, true))});
        this.assertPublishedEvents(new SagaStartingEvent(IDENTIFIER, true));
        ArgumentCaptor captor = ArgumentCaptor.forClass(String.class);
        ((DeadlineManager)Mockito.verify((Object)this.deadlineManager)).cancelSchedule((String)Mockito.any(), (String)captor.capture());
        this.spanFactory.verifySpanCompleted("DeadlineManager.cancelDeadline(deadlineName)");
    }

    @Test
    public void deadlineCancelAllOnSagaIsCorrectlyTraced() {
        this.configuration.eventStore().publish(new EventMessage[]{GenericEventMessage.asEventMessage((Object)new SagaStartingEvent(IDENTIFIER, true))});
        this.configuration.eventStore().publish(new EventMessage[]{GenericEventMessage.asEventMessage((Object)new CancelAllDeadlinesWithName(IDENTIFIER))});
        this.assertPublishedEvents(new SagaStartingEvent(IDENTIFIER, true), new CancelAllDeadlinesWithName(IDENTIFIER));
        this.spanFactory.verifySpanCompleted("DeadlineManager.cancelAllDeadlines(deadlineName)");
    }

    @Test
    void deadlineWithSpecifiedDeadlineNameOnSaga() {
        String expectedDeadlinePayload = "deadlinePayload";
        this.configuration.eventStore().publish(new EventMessage[]{GenericEventMessage.asEventMessage((Object)new SagaStartingEvent(IDENTIFIER, true))});
        this.configuration.eventStore().publish(new EventMessage[]{GenericEventMessage.asEventMessage((Object)new ScheduleSpecificDeadline(IDENTIFIER, expectedDeadlinePayload))});
        this.assertPublishedEvents(new SagaStartingEvent(IDENTIFIER, true), new ScheduleSpecificDeadline(IDENTIFIER, expectedDeadlinePayload), new SpecificDeadlineOccurredEvent(expectedDeadlinePayload));
        this.assertSagaIs(false);
    }

    @Test
    void deadlineWithoutPayloadOnSaga() {
        this.configuration.eventStore().publish(new EventMessage[]{GenericEventMessage.asEventMessage((Object)new SagaStartingEvent(IDENTIFIER, true))});
        this.configuration.eventStore().publish(new EventMessage[]{GenericEventMessage.asEventMessage((Object)new ScheduleSpecificDeadline(IDENTIFIER, null))});
        this.assertPublishedEvents(new SagaStartingEvent(IDENTIFIER, true), new ScheduleSpecificDeadline(IDENTIFIER, null), new SpecificDeadlineOccurredEvent(null));
        this.assertSagaIs(false);
    }

    @Test
    void sagaEndingDeadlineEndsTheSaga() {
        EventStore eventStore = this.configuration.eventStore();
        eventStore.publish(new EventMessage[]{GenericEventMessage.asEventMessage((Object)new SagaStartingEvent(IDENTIFIER, true))});
        eventStore.publish(new EventMessage[]{GenericEventMessage.asEventMessage((Object)new ScheduleSpecificDeadline(IDENTIFIER, END_SAGA))});
        this.assertPublishedEvents(new SagaStartingEvent(IDENTIFIER, true), new ScheduleSpecificDeadline(IDENTIFIER, END_SAGA), new DeadlineOccurredEvent(new DeadlinePayload(SAGA_ENDED)));
        this.assertSagaIs(true);
    }

    @Test
    void handlerInterceptorOnSaga() {
        EventMessage testEventMessage = GenericEventMessage.asEventMessage((Object)new SagaStartingEvent(IDENTIFIER, false));
        this.configuration.deadlineManager().registerHandlerInterceptor((uow, chain) -> {
            uow.transformMessage(deadlineMessage -> GenericDeadlineMessage.asDeadlineMessage((String)deadlineMessage.getDeadlineName(), (Object)new DeadlinePayload(FAKE_IDENTIFIER), (Instant)deadlineMessage.getTimestamp()));
            return chain.proceed();
        });
        this.configuration.eventStore().publish(new EventMessage[]{testEventMessage});
        this.assertPublishedEvents(new SagaStartingEvent(IDENTIFIER, false), new DeadlineOccurredEvent(new DeadlinePayload(FAKE_IDENTIFIER)));
        this.assertSagaIs(false);
    }

    @Test
    void dispatchInterceptorOnSaga() {
        EventMessage testEventMessage = GenericEventMessage.asEventMessage((Object)new SagaStartingEvent(IDENTIFIER, false));
        this.configuration.deadlineManager().registerDispatchInterceptor(messages -> (i, m) -> GenericDeadlineMessage.asDeadlineMessage((String)m.getDeadlineName(), (Object)new DeadlinePayload(FAKE_IDENTIFIER), (Instant)m.getTimestamp()));
        this.configuration.eventStore().publish(new EventMessage[]{testEventMessage});
        this.assertPublishedEvents(new SagaStartingEvent(IDENTIFIER, false), new DeadlineOccurredEvent(new DeadlinePayload(FAKE_IDENTIFIER)));
        this.assertSagaIs(false);
    }

    @Test
    void deadlineMessagesReceiveCorrelationDataThroughSaga() {
        String expectedCorrelationData = "customValue";
        CustomCorrelationDataDispatchInterceptor correlationDataDispatchInterceptor = new CustomCorrelationDataDispatchInterceptor(expectedCorrelationData);
        this.configuration.eventStore().registerDispatchInterceptor((MessageDispatchInterceptor)correlationDataDispatchInterceptor);
        EventMessage testEventMessage = GenericEventMessage.asEventMessage((Object)new SagaStartingEvent(IDENTIFIER, false));
        this.configuration.eventStore().publish(new EventMessage[]{testEventMessage});
        this.assertPublishedEvents(new SagaStartingEvent(IDENTIFIER, false), new DeadlineOccurredEvent(new DeadlinePayload(IDENTIFIER)));
        this.assertSagaIs(false);
        Message<?> sagaStartingEvent = this.publishedMessages.get(0);
        Assertions.assertTrue((boolean)sagaStartingEvent.getMetaData().containsKey((Object)CUSTOM_CORRELATION_DATA_KEY));
        Assertions.assertEquals((Object)expectedCorrelationData, (Object)sagaStartingEvent.getMetaData().get((Object)CUSTOM_CORRELATION_DATA_KEY));
        Message<?> deadLineOccurredEvent = this.publishedMessages.get(1);
        Assertions.assertTrue((boolean)deadLineOccurredEvent.getMetaData().containsKey((Object)CUSTOM_CORRELATION_DATA_KEY));
        Assertions.assertEquals((Object)expectedCorrelationData, (Object)deadLineOccurredEvent.getMetaData().get((Object)CUSTOM_CORRELATION_DATA_KEY));
    }

    private void assertPublishedEvents(Object ... expectedEvents) {
        Awaitility.await().atMost(Duration.ofMillis(1600L)).until(() -> this.sameElements(Arrays.asList(expectedEvents)));
    }

    private boolean sameElements(List<Object> expected) {
        if (expected.size() != this.publishedMessages.size()) {
            return false;
        }
        List published = this.publishedMessages.stream().map(Message::getPayload).collect(Collectors.toList());
        return expected.containsAll(published) && published.containsAll(expected);
    }

    private void assertSagaIs(boolean live) {
        SagaStore sagaStore = this.configuration.eventProcessingConfiguration().sagaStore();
        Set sagaIds = sagaStore.findSagas(MySaga.class, new AssociationValue("id", IDENTIFIER.toString()));
        Assertions.assertEquals((Object)live, (Object)sagaIds.isEmpty());
    }

    private static class CustomCorrelationDataDispatchInterceptor
    implements MessageDispatchInterceptor<Message<?>> {
        private final String correlationData;

        private CustomCorrelationDataDispatchInterceptor(String correlationData) {
            this.correlationData = correlationData;
        }

        public BiFunction<Integer, Message<?>, Message<?>> handle(@NotNull List<? extends Message<?>> messages) {
            return (i, m) -> m.andMetaData((Map)MetaData.with((String)AbstractDeadlineManagerTestSuite.CUSTOM_CORRELATION_DATA_KEY, (Object)this.correlationData));
        }
    }

    public static class MyEntity {
        @EntityId
        private final UUID id;

        private MyEntity(UUID id) {
            this.id = id;
        }

        @DeadlineHandler
        public void on(EntityDeadlinePayload deadlineInfo, @Timestamp Instant timestamp) {
            Assertions.assertNotNull((Object)timestamp);
            AggregateLifecycle.apply((Object)new DeadlineOccurredInChildEvent(deadlineInfo));
        }
    }

    public static class MyAggregate {
        @AggregateIdentifier
        private UUID id;
        @AggregateMember
        private MyEntity myEntity;

        @CommandHandler
        @CreationPolicy(value=AggregateCreationPolicy.ALWAYS)
        public String on(CreateMyAggregateCommand command, DeadlineManager deadlineManager) {
            AggregateLifecycle.apply((Object)new MyAggregateCreatedEvent(command.id));
            String deadlineName = "deadlineName";
            Instant trigger = Instant.now().plus(Duration.ofMillis(command.deadlineMillis));
            String deadlineId = deadlineManager.schedule(trigger, deadlineName, (Object)new DeadlinePayload(command.id));
            if (command.cancelBeforeDeadline) {
                deadlineManager.cancelSchedule(deadlineName, deadlineId);
            }
            return deadlineId;
        }

        @CommandHandler
        public void on(ScheduleSpecificDeadline message, DeadlineManager deadlineManager) {
            String deadlinePayload = message.payload;
            if (deadlinePayload != null) {
                deadlineManager.schedule(Duration.ofMillis(100L), "specificDeadlineName", (Object)deadlinePayload);
            } else {
                deadlineManager.schedule(Duration.ofMillis(100L), "payloadlessDeadline");
            }
        }

        @CommandHandler
        public void on(CancelDeadlineWithinScope command, DeadlineManager deadlineManager) {
            deadlineManager.cancelAllWithinScope("deadlineName");
            deadlineManager.cancelAllWithinScope("specificDeadlineName");
            deadlineManager.cancelAllWithinScope("payloadlessDeadline");
        }

        @CommandHandler
        public void on(CancelAllDeadlinesWithName command, DeadlineManager deadlineManager) {
            deadlineManager.cancelAll("deadlineName");
        }

        @EventSourcingHandler
        public void on(MyAggregateCreatedEvent event) {
            this.id = event.id;
            this.myEntity = new MyEntity(this.id);
        }

        @DeadlineHandler
        public void on(DeadlinePayload deadlinePayload, @Timestamp Instant timestamp) {
            Assertions.assertNotNull((Object)timestamp);
            AggregateLifecycle.apply((Object)new DeadlineOccurredEvent(deadlinePayload));
        }

        @DeadlineHandler(deadlineName="specificDeadlineName")
        public void on(Object deadlinePayload) {
            AggregateLifecycle.apply((Object)new SpecificDeadlineOccurredEvent(deadlinePayload));
        }

        @DeadlineHandler(deadlineName="payloadlessDeadline")
        public void on() {
            AggregateLifecycle.apply((Object)new SpecificDeadlineOccurredEvent(null));
        }

        @CommandHandler
        public void handle(TriggerDeadlineInChildEntityCommand command, DeadlineManager deadlineManager) {
            deadlineManager.schedule(Duration.ofMillis(250L), "deadlineName", (Object)new EntityDeadlinePayload("entity" + command.id));
        }
    }

    public static class MySaga {
        private transient EventStore eventStore;

        @StartSaga
        @SagaEventHandler(associationProperty="id")
        public void on(SagaStartingEvent sagaStartingEvent, DeadlineManager deadlineManager) {
            String deadlineName = "deadlineName";
            String deadlineId = deadlineManager.schedule(Duration.ofMillis(100L), deadlineName, (Object)new DeadlinePayload(sagaStartingEvent.id));
            if (sagaStartingEvent.isCancelBeforeDeadline()) {
                deadlineManager.cancelSchedule(deadlineName, deadlineId);
            }
        }

        @SagaEventHandler(associationProperty="id")
        public void on(ScheduleSpecificDeadline message, DeadlineManager deadlineManager) {
            String deadlinePayload = message.payload;
            if (AbstractDeadlineManagerTestSuite.END_SAGA.equals(deadlinePayload)) {
                deadlineManager.schedule(Duration.ofMillis(100L), "sagaEndingDeadline");
            } else if (deadlinePayload != null) {
                deadlineManager.schedule(Duration.ofMillis(100L), "specificDeadlineName", (Object)deadlinePayload);
            } else {
                deadlineManager.schedule(Duration.ofMillis(100L), "payloadlessDeadline");
            }
        }

        @SagaEventHandler(associationProperty="id")
        public void on(CancelDeadlineWithinScope evt, DeadlineManager deadlineManager) {
            deadlineManager.cancelAllWithinScope("deadlineName");
            deadlineManager.cancelAllWithinScope("specificDeadlineName");
            deadlineManager.cancelAllWithinScope("payloadlessDeadline");
        }

        @SagaEventHandler(associationProperty="id")
        public void on(CancelAllDeadlinesWithName evt, DeadlineManager deadlineManager) {
            deadlineManager.cancelAll("deadlineName");
        }

        @DeadlineHandler
        public void on(DeadlinePayload deadlinePayload, @Timestamp Instant timestamp) {
            Assertions.assertNotNull((Object)timestamp);
            this.eventStore.publish(new EventMessage[]{GenericEventMessage.asEventMessage((Object)new DeadlineOccurredEvent(deadlinePayload))});
        }

        @DeadlineHandler(deadlineName="specificDeadlineName")
        public void on(Object deadlinePayload, @Timestamp Instant timestamp) {
            Assertions.assertNotNull((Object)timestamp);
            this.eventStore.publish(new EventMessage[]{GenericEventMessage.asEventMessage((Object)new SpecificDeadlineOccurredEvent(deadlinePayload))});
        }

        @DeadlineHandler(deadlineName="payloadlessDeadline")
        public void on() {
            this.eventStore.publish(new EventMessage[]{GenericEventMessage.asEventMessage((Object)new SpecificDeadlineOccurredEvent(null))});
        }

        @EndSaga
        @DeadlineHandler(deadlineName="sagaEndingDeadline")
        public void sagaEndingDeadline() {
            this.eventStore.publish(new EventMessage[]{GenericEventMessage.asEventMessage((Object)new DeadlineOccurredEvent(new DeadlinePayload(SAGA_ENDED)))});
        }

        @Autowired
        public void setEventStore(EventStore eventStore) {
            this.eventStore = eventStore;
        }
    }

    private static class SpecificDeadlineOccurredEvent {
        private final Object payload;

        private SpecificDeadlineOccurredEvent(Object payload) {
            this.payload = payload;
        }

        public int hashCode() {
            return Objects.hash(this.payload);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            SpecificDeadlineOccurredEvent other = (SpecificDeadlineOccurredEvent)obj;
            return Objects.equals(this.payload, other.payload);
        }
    }

    private static class DeadlineOccurredInChildEvent {
        private final EntityDeadlinePayload deadlineInfo;

        private DeadlineOccurredInChildEvent(EntityDeadlinePayload deadlineInfo) {
            this.deadlineInfo = deadlineInfo;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DeadlineOccurredInChildEvent that = (DeadlineOccurredInChildEvent)o;
            return Objects.equals(this.deadlineInfo, that.deadlineInfo);
        }

        public int hashCode() {
            return Objects.hash(this.deadlineInfo);
        }
    }

    private static class DeadlineOccurredEvent {
        private final DeadlinePayload deadlinePayload;

        private DeadlineOccurredEvent(DeadlinePayload deadlinePayload) {
            this.deadlinePayload = deadlinePayload;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DeadlineOccurredEvent that = (DeadlineOccurredEvent)o;
            return Objects.equals(this.deadlinePayload, that.deadlinePayload);
        }

        public int hashCode() {
            return Objects.hash(this.deadlinePayload);
        }
    }

    private static class EntityDeadlinePayload {
        private final String id;

        private EntityDeadlinePayload() {
            this("some-id");
        }

        private EntityDeadlinePayload(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EntityDeadlinePayload that = (EntityDeadlinePayload)o;
            return Objects.equals(this.id, that.id);
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }
    }

    private static class DeadlinePayload {
        private final UUID id;

        private DeadlinePayload() {
            this(UUID.randomUUID());
        }

        private DeadlinePayload(UUID id) {
            this.id = id;
        }

        public UUID getId() {
            return this.id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DeadlinePayload that = (DeadlinePayload)o;
            return Objects.equals(this.id, that.id);
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }
    }

    private static class SagaStartingEvent {
        private final UUID id;
        private final boolean cancelBeforeDeadline;

        private SagaStartingEvent(UUID id, boolean cancelBeforeDeadline) {
            this.id = id;
            this.cancelBeforeDeadline = cancelBeforeDeadline;
        }

        public UUID getId() {
            return this.id;
        }

        public boolean isCancelBeforeDeadline() {
            return this.cancelBeforeDeadline;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SagaStartingEvent that = (SagaStartingEvent)o;
            return this.cancelBeforeDeadline == that.cancelBeforeDeadline && Objects.equals(this.id, that.id);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.cancelBeforeDeadline);
        }
    }

    private static class MyAggregateCreatedEvent {
        private final UUID id;

        private MyAggregateCreatedEvent(UUID id) {
            this.id = id;
        }

        public UUID getId() {
            return this.id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyAggregateCreatedEvent that = (MyAggregateCreatedEvent)o;
            return Objects.equals(this.id, that.id);
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }

        public String toString() {
            return "MyAggregateCreatedEvent{id='" + this.id + '\'' + '}';
        }
    }

    private static class ScheduleSpecificDeadline {
        @TargetAggregateIdentifier
        private final UUID id;
        private final String payload;

        private ScheduleSpecificDeadline(UUID id, String payload) {
            this.id = id;
            this.payload = payload;
        }

        public UUID getId() {
            return this.id;
        }

        public int hashCode() {
            return Objects.hash(this.id, this.payload);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ScheduleSpecificDeadline other = (ScheduleSpecificDeadline)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.payload, other.payload);
        }
    }

    private static class TriggerDeadlineInChildEntityCommand {
        @TargetAggregateIdentifier
        private final UUID id;

        private TriggerDeadlineInChildEntityCommand(UUID id) {
            this.id = id;
        }
    }

    private static class CancelAllDeadlinesWithName {
        @TargetAggregateIdentifier
        private final UUID id;

        private CancelAllDeadlinesWithName(UUID id) {
            this.id = id;
        }

        public UUID getId() {
            return this.id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CancelAllDeadlinesWithName that = (CancelAllDeadlinesWithName)o;
            return Objects.equals(this.id, that.id);
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }
    }

    private static class CancelDeadlineWithinScope {
        @TargetAggregateIdentifier
        private final UUID id;

        private CancelDeadlineWithinScope(UUID id) {
            this.id = id;
        }

        public UUID getId() {
            return this.id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CancelDeadlineWithinScope that = (CancelDeadlineWithinScope)o;
            return Objects.equals(this.id, that.id);
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }
    }

    private static class CreateMyAggregateCommand {
        private final UUID id;
        private final boolean cancelBeforeDeadline;
        private final int deadlineMillis;

        private CreateMyAggregateCommand(UUID id) {
            this(id, false);
        }

        private CreateMyAggregateCommand(UUID id, int deadlineMillis) {
            this(id, deadlineMillis, false);
        }

        private CreateMyAggregateCommand(UUID id, boolean cancelBeforeDeadline) {
            this.id = id;
            this.cancelBeforeDeadline = cancelBeforeDeadline;
            this.deadlineMillis = 100;
        }

        private CreateMyAggregateCommand(UUID id, int deadlineMillis, boolean cancelBeforeDeadline) {
            this.id = id;
            this.cancelBeforeDeadline = cancelBeforeDeadline;
            this.deadlineMillis = deadlineMillis;
        }
    }
}

