/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring;

import java.util.List;
import org.axonframework.commandhandling.CommandHandler;
import org.axonframework.commandhandling.gateway.CommandGateway;
import org.axonframework.config.AggregateConfigurer;
import org.axonframework.config.Configuration;
import org.axonframework.config.EventProcessingModule;
import org.axonframework.eventsourcing.EventSourcingHandler;
import org.axonframework.eventsourcing.eventstore.EventStorageEngine;
import org.axonframework.eventsourcing.eventstore.inmemory.InMemoryEventStorageEngine;
import org.axonframework.modelling.command.AggregateIdentifier;
import org.axonframework.modelling.command.AggregateLifecycle;
import org.axonframework.modelling.command.TargetAggregateIdentifier;
import org.axonframework.spring.config.SpringAxonAutoConfigurer;
import org.axonframework.spring.stereotype.Aggregate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.EnableMBeanExport;
import org.springframework.context.annotation.Import;
import org.springframework.jmx.support.RegistrationPolicy;
import org.springframework.stereotype.Component;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(value={SpringExtension.class})
@EnableMBeanExport(registration=RegistrationPolicy.IGNORE_EXISTING)
public class AggregatePolymorphismTest {
    @Autowired
    private Configuration configuration;
    @Autowired
    private CommandGateway commandGateway;

    @Test
    void config() {
        List configurers = this.configuration.findModules(AggregateConfigurer.class);
        Assertions.assertEquals((int)3, (int)configurers.size());
        String bId = (String)this.commandGateway.sendAndWait((Object)new CreateBCommand("123"));
        String cId = (String)this.commandGateway.sendAndWait((Object)new CreateCCommand("456"));
        String dId = (String)this.commandGateway.sendAndWait((Object)new CreateDCommand("789"));
        String fId = (String)this.commandGateway.sendAndWait((Object)new CreateFCommand("000"));
        String iId = (String)this.commandGateway.sendAndWait((Object)new CreateICommand("111"));
        String bResult = (String)this.commandGateway.sendAndWait((Object)new CommonCommand(bId));
        String cResult = (String)this.commandGateway.sendAndWait((Object)new CommonCommand(cId));
        String dResult = (String)this.commandGateway.sendAndWait((Object)new CommonCommand(dId));
        String fResult = (String)this.commandGateway.sendAndWait((Object)new FCommand(fId));
        String iResult = (String)this.commandGateway.sendAndWait((Object)new HCommand(iId));
        Assertions.assertEquals((Object)"B123", (Object)bResult);
        Assertions.assertEquals((Object)"C456", (Object)cResult);
        Assertions.assertEquals((Object)"D789", (Object)dResult);
        Assertions.assertEquals((Object)"F000", (Object)fResult);
        Assertions.assertEquals((Object)"I111", (Object)iResult);
    }

    @Import(value={SpringAxonAutoConfigurer.ImportSelector.class})
    @org.springframework.context.annotation.Configuration
    public static class Context {
        @Bean
        public EventProcessingModule eventProcessingModule() {
            return new EventProcessingModule();
        }

        @Bean
        public EventStorageEngine eventStorageEngine() {
            return new InMemoryEventStorageEngine();
        }

        @Aggregate
        public static class I
        extends H {
            public I() {
            }

            @CommandHandler
            public I(CreateICommand cmd) {
                AggregateLifecycle.apply((Object)new CreatedEvent(cmd.id()));
            }
        }

        public static abstract class H
        extends G {
            @CommandHandler
            public String handle(HCommand cmd) {
                return this.getClass().getSimpleName() + cmd.id();
            }
        }

        @Aggregate
        public static abstract class G {
            @AggregateIdentifier
            private String id;

            @EventSourcingHandler
            public void on(CreatedEvent evt) {
                this.id = evt.getId();
            }
        }

        @Aggregate
        public static class F
        extends E {
            public F() {
            }

            @CommandHandler
            public F(CreateFCommand cmd) {
                AggregateLifecycle.apply((Object)new CreatedEvent(cmd.getId()));
            }
        }

        public static class E {
            @AggregateIdentifier
            private String id;

            @EventSourcingHandler
            public void on(CreatedEvent evt) {
                this.id = evt.getId();
            }

            @CommandHandler
            public String handle(FCommand cmd) {
                return this.getClass().getSimpleName() + cmd.getId();
            }
        }

        @Aggregate
        public static class D
        extends B {
            public D() {
            }

            @CommandHandler
            public D(CreateDCommand cmd) {
                AggregateLifecycle.apply((Object)new CreatedEvent(cmd.getId()));
            }
        }

        @Aggregate
        public static class C
        extends A {
            public C() {
            }

            @CommandHandler
            public C(CreateCCommand cmd) {
                AggregateLifecycle.apply((Object)new CreatedEvent(cmd.getId()));
            }
        }

        @Component
        public static class B
        extends A {
            public B() {
            }

            @CommandHandler
            public B(CreateBCommand cmd) {
                AggregateLifecycle.apply((Object)new CreatedEvent(cmd.getId()));
            }
        }

        @Component(value="abc")
        @Aggregate
        public static abstract class A {
            @AggregateIdentifier
            private String id;

            @EventSourcingHandler
            public void on(CreatedEvent evt) {
                this.id = evt.getId();
            }

            @CommandHandler
            public String handle(CommonCommand cmd) {
                return this.getClass().getSimpleName() + cmd.getId();
            }
        }
    }

    private static class HCommand {
        @TargetAggregateIdentifier
        private final String id;

        private HCommand(String id) {
            this.id = id;
        }

        public String id() {
            return this.id;
        }
    }

    private static class CreateICommand {
        @TargetAggregateIdentifier
        private final String id;

        private CreateICommand(String id) {
            this.id = id;
        }

        public String id() {
            return this.id;
        }
    }

    private static class CommonCommand {
        @TargetAggregateIdentifier
        private final String id;

        private CommonCommand(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }

    private static class CreatedEvent {
        private final String id;

        private CreatedEvent(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }

    private static class FCommand {
        @TargetAggregateIdentifier
        private final String id;

        private FCommand(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }

    private static class CreateFCommand {
        @TargetAggregateIdentifier
        private final String id;

        private CreateFCommand(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }

    private static class CreateDCommand {
        @TargetAggregateIdentifier
        private final String id;

        private CreateDCommand(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }

    private static class CreateCCommand {
        @TargetAggregateIdentifier
        private final String id;

        private CreateCCommand(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }

    private static class CreateBCommand {
        @TargetAggregateIdentifier
        private final String id;

        private CreateBCommand(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }
}

