/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.authorization;

import java.util.UUID;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.correlation.CorrelationDataProvider;
import org.axonframework.messaging.correlation.SimpleCorrelationDataProvider;
import org.axonframework.messaging.interceptors.CorrelationDataInterceptor;
import org.axonframework.spring.authorization.CreateAggregateCommand;
import org.axonframework.spring.authorization.MessageAuthorizationDispatchInterceptor;
import org.axonframework.spring.authorization.MessageAuthorizationHandlerInterceptor;
import org.axonframework.spring.authorization.TestAggregate;
import org.axonframework.spring.authorization.UnauthorizedMessageException;
import org.axonframework.test.aggregate.AggregateTestFixture;
import org.axonframework.test.aggregate.FixtureConfiguration;
import org.axonframework.test.matchers.Matchers;
import org.hamcrest.core.StringStartsWith;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.test.context.support.WithMockUser;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(value={SpringExtension.class})
@ContextConfiguration(classes={TestContext.class})
class MessageAuthorizationHandlerInterceptorTest {
    private FixtureConfiguration<TestAggregate> fixture;

    MessageAuthorizationHandlerInterceptorTest() {
    }

    @BeforeEach
    public void setUp() {
        this.fixture = new AggregateTestFixture(TestAggregate.class);
    }

    @Test
    @WithMockUser(username="admin", authorities={"ROLE_aggregate.create", "ROLE_aggregate.update"})
    public void shouldAuthorizeAndPropagateAuthorities() {
        String expectedAuthorities = "ROLE_aggregate.create,ROLE_aggregate.update";
        UUID aggregateId = UUID.randomUUID();
        this.fixture.registerCommandDispatchInterceptor((MessageDispatchInterceptor)new MessageAuthorizationDispatchInterceptor()).registerCommandHandlerInterceptor((MessageHandlerInterceptor)new MessageAuthorizationHandlerInterceptor()).registerCommandHandlerInterceptor((MessageHandlerInterceptor)new CorrelationDataInterceptor(new CorrelationDataProvider[]{new SimpleCorrelationDataProvider(new String[]{"authorities"})})).given(new Object[0]).when((Object)new CreateAggregateCommand(aggregateId)).expectSuccessfulHandlerExecution().expectResultMessageMatching(Matchers.matches(message -> message.getMetaData().get((Object)"authorities").equals(expectedAuthorities)));
    }

    @Test
    @WithMockUser(username="user", roles={""})
    public void shouldNotAuthorize() {
        UUID aggregateId = UUID.randomUUID();
        this.fixture.registerCommandDispatchInterceptor((MessageDispatchInterceptor)new MessageAuthorizationDispatchInterceptor()).registerCommandHandlerInterceptor((MessageHandlerInterceptor)new MessageAuthorizationHandlerInterceptor()).registerCommandHandlerInterceptor((MessageHandlerInterceptor)new CorrelationDataInterceptor(new CorrelationDataProvider[]{new SimpleCorrelationDataProvider(new String[]{"authorities"})})).given(new Object[0]).when((Object)new CreateAggregateCommand(aggregateId)).expectException(UnauthorizedMessageException.class).expectExceptionMessage(StringStartsWith.startsWith((String)"Unauthorized message"));
    }

    @Configuration
    static class TestContext {
        TestContext() {
        }

        @Bean
        public MessageAuthorizationDispatchInterceptor<?> messageAuthorizationDispatchInterceptor() {
            return new MessageAuthorizationDispatchInterceptor();
        }

        @Bean
        public MessageAuthorizationHandlerInterceptor<?> messageAuthorizationHandlerInterceptor() {
            return new MessageAuthorizationHandlerInterceptor();
        }
    }
}

