/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.authorization;

import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import org.axonframework.messaging.annotation.HandlerEnhancerDefinition;
import org.axonframework.spring.authorization.AggregateCreatedEvent;
import org.axonframework.spring.authorization.AggregateUpdatedEvent;
import org.axonframework.spring.authorization.CreateAggregateCommand;
import org.axonframework.spring.authorization.SecuredMessageHandlerDefinition;
import org.axonframework.spring.authorization.TestAggregate;
import org.axonframework.spring.authorization.UnauthorizedMessageException;
import org.axonframework.spring.authorization.UpdateAggregateCommand;
import org.axonframework.test.aggregate.AggregateTestFixture;
import org.axonframework.test.aggregate.FixtureConfiguration;
import org.axonframework.test.matchers.Matchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.StringStartsWith;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.testcontainers.shaded.com.google.common.collect.Sets;

class SecuredMessageHandlerDefinitionTest {
    private static final UUID TEST_AGGREGATE_IDENTIFIER = UUID.randomUUID();
    private FixtureConfiguration<TestAggregate> testSubject;

    SecuredMessageHandlerDefinitionTest() {
    }

    @BeforeEach
    void setUp() {
        this.testSubject = new AggregateTestFixture(TestAggregate.class).registerHandlerEnhancerDefinition((HandlerEnhancerDefinition)new SecuredMessageHandlerDefinition());
    }

    @Test
    void shouldAllowWhenAuthorityMatch() {
        HashMap<String, HashSet> metaData = new HashMap<String, HashSet>();
        metaData.put("authorities", Sets.newHashSet((Object[])new SimpleGrantedAuthority[]{new SimpleGrantedAuthority("ROLE_aggregate.create")}));
        this.testSubject.givenNoPriorActivity().when((Object)new CreateAggregateCommand(TEST_AGGREGATE_IDENTIFIER), metaData).expectEventsMatching(Matchers.exactSequenceOf((Matcher[])new Matcher[]{Matchers.predicate(eventMessage -> eventMessage.getPayloadType().isAssignableFrom(AggregateCreatedEvent.class))}));
    }

    @Test
    void shouldDenyWhenAuthorityDoesNotMatch() {
        HashMap<String, HashSet> metaData = new HashMap<String, HashSet>();
        metaData.put("authorities", Sets.newHashSet((Object[])new SimpleGrantedAuthority[]{new SimpleGrantedAuthority("ROLE_anonymous")}));
        this.testSubject.givenNoPriorActivity().when((Object)new CreateAggregateCommand(TEST_AGGREGATE_IDENTIFIER), metaData).expectException(UnauthorizedMessageException.class).expectExceptionMessage(StringStartsWith.startsWith((String)"Unauthorized message"));
    }

    @Test
    void shouldAllowUnannotatedMethods() {
        HashMap<String, HashSet> metaData = new HashMap<String, HashSet>();
        metaData.put("authorities", Sets.newHashSet((Object[])new SimpleGrantedAuthority[]{new SimpleGrantedAuthority("ROLE_anonymous")}));
        this.testSubject.given(new Object[]{new AggregateCreatedEvent(TEST_AGGREGATE_IDENTIFIER)}).when((Object)new UpdateAggregateCommand(TEST_AGGREGATE_IDENTIFIER), metaData).expectEventsMatching(Matchers.exactSequenceOf((Matcher[])new Matcher[]{Matchers.predicate(eventMessage -> eventMessage.getPayloadType().isAssignableFrom(AggregateUpdatedEvent.class))}));
    }

    @Test
    void shouldDenyWhenNoAuthorityPresent() {
        this.testSubject.givenNoPriorActivity().when((Object)new CreateAggregateCommand(TEST_AGGREGATE_IDENTIFIER)).expectException(UnauthorizedMessageException.class).expectExceptionMessage(StringStartsWith.startsWith((String)"Unauthorized message"));
    }
}

