/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.authorization;

import java.util.UUID;
import org.axonframework.commandhandling.CommandHandler;
import org.axonframework.eventsourcing.EventSourcingHandler;
import org.axonframework.modelling.command.AggregateCreationPolicy;
import org.axonframework.modelling.command.AggregateIdentifier;
import org.axonframework.modelling.command.AggregateLifecycle;
import org.axonframework.modelling.command.CreationPolicy;
import org.axonframework.spring.authorization.AggregateCreatedEvent;
import org.axonframework.spring.authorization.AggregateUpdatedEvent;
import org.axonframework.spring.authorization.CreateAggregateCommand;
import org.axonframework.spring.authorization.UpdateAggregateCommand;
import org.axonframework.spring.stereotype.Aggregate;
import org.springframework.security.access.annotation.Secured;

@Aggregate
public class TestAggregate {
    @AggregateIdentifier
    private UUID aggregateId;

    @CommandHandler
    @CreationPolicy(value=AggregateCreationPolicy.ALWAYS)
    @Secured(value={"ROLE_aggregate.create"})
    public void create(CreateAggregateCommand cmd) {
        AggregateLifecycle.apply((Object)new AggregateCreatedEvent(cmd.getAggregateId()));
    }

    @CommandHandler
    public void update(UpdateAggregateCommand cmd) {
        AggregateLifecycle.apply((Object)new AggregateUpdatedEvent(cmd.getAggregateId()));
    }

    @EventSourcingHandler
    public void on(AggregateCreatedEvent evt) {
        this.aggregateId = evt.getAggregateId();
    }
}

