/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.config;

import org.axonframework.commandhandling.CommandHandler;
import org.axonframework.eventhandling.EventHandler;
import org.axonframework.spring.config.AnnotationDriven;
import org.axonframework.spring.config.annotation.AnnotationCommandHandlerBeanPostProcessor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableMBeanExport;
import org.springframework.jmx.support.RegistrationPolicy;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(value={SpringExtension.class})
@EnableMBeanExport(registration=RegistrationPolicy.IGNORE_EXISTING)
@ContextConfiguration(classes={Context.class})
public class AnnotationDrivenConfigurationTest_CustomValues {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private DefaultListableBeanFactory beanFactory;

    @Test
    void commandHandlerPostProcessorBeanDefinitionContainCustomValues() {
        BeanDefinition beanDefinition = this.beanFactory.getBeanDefinition("__axon-annotation-command-handler-bean-post-processor");
        Assertions.assertEquals((Object)AnnotationCommandHandlerBeanPostProcessor.class.getName(), (Object)beanDefinition.getBeanClassName());
    }

    public static class AnnotatedCommandHandler {
        @CommandHandler
        public void on(String someEvent) {
        }
    }

    public static class AnnotatedEventHandler {
        @EventHandler
        public void on(String someEvent) {
        }
    }

    @AnnotationDriven
    @Configuration
    public static class Context {
        @Bean
        public AnnotatedEventHandler eventHandler() {
            return new AnnotatedEventHandler();
        }

        @Bean
        public AnnotatedCommandHandler commandHandler() {
            return new AnnotatedCommandHandler();
        }
    }
}

