/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.config;

import javax.persistence.Entity;
import javax.persistence.Id;
import org.axonframework.commandhandling.CommandHandler;
import org.axonframework.common.legacyjpa.EntityManagerProvider;
import org.axonframework.config.EventProcessingModule;
import org.axonframework.eventsourcing.EventSourcingHandler;
import org.axonframework.eventsourcing.eventstore.EventStorageEngine;
import org.axonframework.eventsourcing.eventstore.inmemory.InMemoryEventStorageEngine;
import org.axonframework.modelling.command.AggregateLifecycle;
import org.axonframework.modelling.command.Repository;
import org.axonframework.modelling.command.legacyjpa.GenericJpaRepository;
import org.axonframework.spring.config.SpringAxonAutoConfigurer;
import org.axonframework.spring.stereotype.Aggregate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableMBeanExport;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Scope;
import org.springframework.jmx.support.RegistrationPolicy;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(value={SpringExtension.class})
@EnableMBeanExport(registration=RegistrationPolicy.IGNORE_EXISTING)
@ContextConfiguration
class AutoWiredStateStoredAggregateTest {
    @Autowired
    private Repository<Context.MyAggregate> myAggregateRepository;

    AutoWiredStateStoredAggregateTest() {
    }

    @Test
    void aggregateIsWiredUsingStateStorage() {
        Assertions.assertEquals(GenericJpaRepository.class, this.myAggregateRepository.getClass());
    }

    public static class SomeEvent {
        private final String id;

        public SomeEvent(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }

    @Import(value={SpringAxonAutoConfigurer.ImportSelector.class})
    @Scope
    @Configuration
    public static class Context {
        @Bean
        public EventStorageEngine eventStorageEngine() {
            return new InMemoryEventStorageEngine();
        }

        @Bean
        public EntityManagerProvider entityManagerProvider() {
            return (EntityManagerProvider)Mockito.mock(EntityManagerProvider.class);
        }

        @Bean
        public EventProcessingModule eventProcessingConfiguration() {
            return new EventProcessingModule();
        }

        @Entity(name="myAggregate")
        @Aggregate
        public static class MyAggregate {
            @Id
            private String id;

            @CommandHandler
            public void handle(Long command) {
                AggregateLifecycle.apply((Object)command);
            }

            @CommandHandler
            public void handle(String command) {
            }

            @EventSourcingHandler
            public void on(Long event) {
                this.id = Long.toString(event);
            }

            @EventSourcingHandler
            public void on(String event) {
                Assertions.fail((String)"Event Handler on aggregate shouldn't be invoked");
            }
        }
    }
}

