/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.config;

import java.util.Arrays;
import java.util.function.Function;
import org.axonframework.config.Configuration;
import org.axonframework.config.EventProcessingConfigurer;
import org.axonframework.config.ModuleConfiguration;
import org.axonframework.spring.config.AxonConfiguration;
import org.axonframework.spring.config.EventHandlerRegistrar;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.springframework.core.annotation.Order;

class EventHandlerRegistrarTest {
    private AxonConfiguration axonConfig;
    private ModuleConfiguration eventConfiguration;
    private EventProcessingConfigurer eventConfigurer;
    private EventHandlerRegistrar testSubject;

    EventHandlerRegistrarTest() {
    }

    @BeforeEach
    void setUp() {
        this.axonConfig = (AxonConfiguration)Mockito.mock(AxonConfiguration.class);
        this.eventConfiguration = (ModuleConfiguration)Mockito.mock(ModuleConfiguration.class);
        this.eventConfigurer = (EventProcessingConfigurer)Mockito.mock(EventProcessingConfigurer.class);
        this.testSubject = new EventHandlerRegistrar(this.axonConfig, this.eventConfiguration, this.eventConfigurer);
    }

    @Test
    void beansRegisteredInOrder() {
        this.testSubject.setEventHandlers(Arrays.asList(new OrderedBean(), new LateOrderedBean(), new UnorderedBean()));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.eventConfigurer});
        ((EventProcessingConfigurer)inOrder.verify((Object)this.eventConfigurer)).registerEventHandler(this.returns(OrderedBean.class));
        ((EventProcessingConfigurer)inOrder.verify((Object)this.eventConfigurer)).registerEventHandler(this.returns(LateOrderedBean.class));
        ((EventProcessingConfigurer)inOrder.verify((Object)this.eventConfigurer)).registerEventHandler(this.returns(UnorderedBean.class));
    }

    private Function<Configuration, Object> returns(Class<?> type) {
        return (Function)Mockito.argThat(x -> {
            Object actual = x.apply(this.axonConfig);
            return type.isInstance(actual);
        });
    }

    @Order(value=100)
    public static class LateOrderedBean {
    }

    @Order(value=0)
    public static class OrderedBean {
    }

    public static class UnorderedBean {
    }
}

