/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.config;

import java.util.List;
import org.axonframework.config.EventProcessingModule;
import org.axonframework.config.ProcessingGroup;
import org.axonframework.eventhandling.EventHandler;
import org.axonframework.eventhandling.EventProcessor;
import org.axonframework.messaging.interceptors.CorrelationDataInterceptor;
import org.axonframework.messaging.interceptors.LoggingInterceptor;
import org.axonframework.spring.config.SpringAxonAutoConfigurer;
import org.axonframework.spring.stereotype.Saga;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableMBeanExport;
import org.springframework.context.annotation.Import;
import org.springframework.jmx.support.RegistrationPolicy;
import org.springframework.stereotype.Component;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(value={SpringExtension.class})
@EnableMBeanExport(registration=RegistrationPolicy.IGNORE_EXISTING)
public class EventProcessingModuleConfigTest {
    @Autowired
    private EventProcessingModule eventProcessingConfiguration;

    @Test
    void eventProcessingConfiguration() {
        Assertions.assertEquals((int)3, (int)this.eventProcessingConfiguration.eventProcessors().size());
        Assertions.assertTrue((boolean)this.eventProcessingConfiguration.eventProcessor("processor2").isPresent());
        Assertions.assertTrue((boolean)this.eventProcessingConfiguration.eventProcessor("subscribingProcessor").isPresent());
        EventProcessor processor2 = (EventProcessor)this.eventProcessingConfiguration.eventProcessorByProcessingGroup("processor1").get();
        Assertions.assertEquals((Object)"processor2", (Object)processor2.getName());
        List interceptorsFor = this.eventProcessingConfiguration.interceptorsFor("processor2");
        Assertions.assertEquals((int)2, (int)interceptorsFor.size());
        Assertions.assertTrue((boolean)interceptorsFor.stream().anyMatch(i -> i instanceof CorrelationDataInterceptor));
        Assertions.assertTrue((boolean)interceptorsFor.stream().anyMatch(i -> i instanceof LoggingInterceptor));
        Assertions.assertEquals((Object)"processor2", (Object)((EventProcessor)this.eventProcessingConfiguration.eventProcessorByProcessingGroup("processor2").get()).getName());
        Assertions.assertEquals((Object)"subscribingProcessor", (Object)((EventProcessor)this.eventProcessingConfiguration.eventProcessorByProcessingGroup("processor3").get()).getName());
        Assertions.assertEquals((Object)"subscribingProcessor", (Object)((EventProcessor)this.eventProcessingConfiguration.eventProcessorByProcessingGroup("Saga3Processor").get()).getName());
        Assertions.assertEquals((Object)"processor4", (Object)((EventProcessor)this.eventProcessingConfiguration.eventProcessorByProcessingGroup("processor4").get()).getName());
    }

    @Import(value={SpringAxonAutoConfigurer.ImportSelector.class})
    @Configuration
    public static class Context {
        @Bean
        public EventProcessingModule eventProcessingConfiguration() {
            EventProcessingModule config = new EventProcessingModule();
            config.assignProcessingGroup("processor1", "processor2");
            config.assignProcessingGroup(group -> group.contains("3") ? "subscribingProcessor" : group);
            config.registerSubscribingEventProcessor("subscribingProcessor");
            config.registerDefaultHandlerInterceptor((configuration, name) -> new LoggingInterceptor());
            return config;
        }

        @Saga
        @ProcessingGroup(value="processor4")
        public static class Saga5 {
        }

        @Saga
        @ProcessingGroup(value="processor4")
        public static class Saga4 {
        }

        @Component
        @ProcessingGroup(value="processor3")
        public static class EventHandler1 {
            @EventHandler
            public void on(String evt) {
            }
        }

        @Saga
        public static class Saga3 {
        }

        @Saga
        @ProcessingGroup(value="processor2")
        public static class Saga2 {
        }

        @Saga
        @ProcessingGroup(value="processor1")
        public static class Saga1 {
        }
    }
}

