/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.config;

import java.util.Collections;
import javax.annotation.Nonnull;
import org.axonframework.config.EventProcessingModule;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventHandler;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.messaging.InterceptorChain;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.annotation.MetaDataValue;
import org.axonframework.messaging.unitofwork.UnitOfWork;
import org.axonframework.spring.config.SpringAxonAutoConfigurer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableMBeanExport;
import org.springframework.context.annotation.Import;
import org.springframework.jmx.support.RegistrationPolicy;
import org.springframework.stereotype.Component;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(value={SpringExtension.class})
@EnableMBeanExport(registration=RegistrationPolicy.IGNORE_EXISTING)
public class EventProcessingModuleWithInterceptorsTest {
    @Autowired
    private EventBus eventBus;
    @Autowired
    private Context.MyEventHandler myEventHandler;

    @Test
    void interceptorRegistration() {
        this.eventBus.publish(new EventMessage[]{GenericEventMessage.asEventMessage((Object)"myEvent")});
        Assertions.assertEquals((Object)"myMetaDataValue", (Object)this.myEventHandler.getMetaDataValue());
    }

    @Import(value={SpringAxonAutoConfigurer.ImportSelector.class})
    @Configuration
    public static class Context {
        @Bean
        public EventProcessingModule eventProcessingConfiguration() {
            EventProcessingModule eventProcessingModule = new EventProcessingModule();
            eventProcessingModule.usingSubscribingEventProcessors();
            eventProcessingModule.registerDefaultHandlerInterceptor((a, b) -> new MyInterceptor());
            return eventProcessingModule;
        }

        @Component
        public class MyEventHandler {
            private String metaDataValue;

            public String getMetaDataValue() {
                return this.metaDataValue;
            }

            @EventHandler
            public void on(String event, @MetaDataValue(value="myMetaDataKey") String metaDataValue) {
                this.metaDataValue = metaDataValue;
            }
        }

        public class MyInterceptor
        implements MessageHandlerInterceptor<EventMessage<?>> {
            public Object handle(@Nonnull UnitOfWork<? extends EventMessage<?>> unitOfWork, @Nonnull InterceptorChain interceptorChain) throws Exception {
                unitOfWork.transformMessage(event -> event.andMetaData(Collections.singletonMap("myMetaDataKey", "myMetaDataValue")));
                return interceptorChain.proceed();
            }
        }
    }
}

