/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.config;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import java.lang.reflect.Executable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.axonframework.commandhandling.AsynchronousCommandBus;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandCallback;
import org.axonframework.commandhandling.CommandHandler;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.GenericCommandMessage;
import org.axonframework.commandhandling.MethodCommandHandlerDefinition;
import org.axonframework.commandhandling.SimpleCommandBus;
import org.axonframework.commandhandling.callbacks.FutureCallback;
import org.axonframework.common.caching.Cache;
import org.axonframework.common.lock.LockFactory;
import org.axonframework.common.lock.PessimisticLockFactory;
import org.axonframework.config.Configuration;
import org.axonframework.config.EventProcessingConfiguration;
import org.axonframework.config.EventProcessingConfigurer;
import org.axonframework.config.EventProcessingModule;
import org.axonframework.config.TagsConfiguration;
import org.axonframework.deadline.annotation.DeadlineMethodMessageHandlerDefinition;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventHandler;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.EventMessageHandler;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.eventhandling.ListenerInvocationErrorHandler;
import org.axonframework.eventhandling.replay.ReplayAwareMessageHandlerWrapper;
import org.axonframework.eventhandling.scheduling.quartz.QuartzEventScheduler;
import org.axonframework.eventsourcing.CachingEventSourcingRepository;
import org.axonframework.eventsourcing.EventSourcingHandler;
import org.axonframework.eventsourcing.eventstore.EventStorageEngine;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.axonframework.eventsourcing.eventstore.inmemory.InMemoryEventStorageEngine;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotation.AnnotatedMessageHandlingMemberDefinition;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.HandlerEnhancerDefinition;
import org.axonframework.messaging.annotation.MessageHandlerInterceptorDefinition;
import org.axonframework.messaging.annotation.MessageHandlingMember;
import org.axonframework.messaging.annotation.MultiHandlerDefinition;
import org.axonframework.messaging.annotation.MultiHandlerEnhancerDefinition;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.messaging.responsetypes.ResponseTypes;
import org.axonframework.modelling.command.AggregateIdentifier;
import org.axonframework.modelling.command.AggregateLifecycle;
import org.axonframework.modelling.command.CommandTargetResolver;
import org.axonframework.modelling.command.TargetAggregateIdentifier;
import org.axonframework.modelling.command.VersionedAggregateIdentifier;
import org.axonframework.modelling.command.inspection.MethodCommandHandlerInterceptorDefinition;
import org.axonframework.modelling.command.inspection.MethodCreationPolicyDefinition;
import org.axonframework.modelling.saga.AssociationValue;
import org.axonframework.modelling.saga.EndSagaMessageHandlerDefinition;
import org.axonframework.modelling.saga.SagaEventHandler;
import org.axonframework.modelling.saga.SagaMethodMessageHandlerDefinition;
import org.axonframework.modelling.saga.StartSaga;
import org.axonframework.modelling.saga.repository.SagaStore;
import org.axonframework.modelling.saga.repository.inmemory.InMemorySagaStore;
import org.axonframework.queryhandling.GenericSubscriptionQueryMessage;
import org.axonframework.queryhandling.QueryBus;
import org.axonframework.queryhandling.QueryHandler;
import org.axonframework.queryhandling.QueryUpdateEmitter;
import org.axonframework.queryhandling.SubscriptionQueryMessage;
import org.axonframework.queryhandling.SubscriptionQueryResult;
import org.axonframework.queryhandling.annotation.MethodQueryMessageHandlerDefinition;
import org.axonframework.serialization.SerializedType;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.SimpleSerializedObject;
import org.axonframework.serialization.upcasting.event.EventUpcaster;
import org.axonframework.serialization.xml.CompactDriver;
import org.axonframework.serialization.xml.XStreamSerializer;
import org.axonframework.spring.config.AnnotationDriven;
import org.axonframework.spring.config.AnnotationDrivenRegistrar;
import org.axonframework.spring.config.SpringAxonAutoConfigurer;
import org.axonframework.spring.eventhandling.scheduling.quartz.QuartzEventSchedulerFactoryBean;
import org.axonframework.spring.stereotype.Aggregate;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.internal.util.collections.Sets;
import org.mockito.verification.VerificationMode;
import org.quartz.Scheduler;
import org.quartz.SchedulerContext;
import org.quartz.SchedulerException;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.EnableMBeanExport;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;
import org.springframework.jmx.support.RegistrationPolicy;
import org.springframework.stereotype.Component;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit.jupiter.SpringExtension;
import reactor.test.StepVerifier;

@ExtendWith(value={SpringExtension.class})
@EnableMBeanExport(registration=RegistrationPolicy.IGNORE_EXISTING)
@ContextConfiguration
public class SpringAxonAutoConfigurerTest {
    @Autowired(required=false)
    private EventStore eventStore;
    @Autowired(required=false)
    private EventBus eventBus;
    @Autowired(required=false)
    private CommandBus commandBus;
    @Autowired(required=false)
    private QueryBus queryBus;
    @Qualifier(value="customSagaStore")
    @Autowired(required=false)
    private SagaStore<Object> customSagaStore;
    @Qualifier(value="sagaStore")
    @Autowired(required=false)
    private SagaStore<Object> sagaStore;
    @Autowired(required=false)
    private EventProcessingConfiguration eventProcessingConfiguration;
    @Autowired(required=false)
    private EventProcessingConfigurer eventProcessingConfigurer;
    @Autowired
    private Configuration axonConfig;
    @Autowired
    private Context.MyEventHandler myEventHandler;
    @Autowired
    private Context.MyOtherEventHandler myOtherEventHandler;
    @Autowired
    private Context.MyListenerInvocationErrorHandler myListenerInvocationErrorHandler;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private EventUpcaster eventUpcaster;
    @Autowired
    @Qualifier(value="myCommandTargetResolver")
    private CommandTargetResolver myCommandTargetResolver;
    @Autowired
    @Qualifier(value="myCache")
    private Cache myCache;
    @Autowired
    @Qualifier(value="primaryCommandTargetResolver")
    private CommandTargetResolver primaryCommandTargetResolver;
    @Autowired
    private TagsConfiguration tagsConfiguration;
    @Autowired
    @Qualifier(value="myLockFactory")
    private LockFactory myLockFactory;
    @Autowired
    private QuartzEventScheduler quartzEventScheduler;
    @Autowired
    @Qualifier(value="eventSerializer")
    private Serializer eventSerializer;

    @AfterEach
    void tearDown() {
        Mockito.reset((Object[])new CommandTargetResolver[]{this.primaryCommandTargetResolver});
    }

    @Test
    void contextWiresMainComponents() {
        Assertions.assertNotNull((Object)this.axonConfig);
        Assertions.assertNotNull((Object)this.axonConfig.eventBus());
        Assertions.assertNotNull((Object)this.eventBus);
        Assertions.assertNotNull((Object)this.eventStore);
        Assertions.assertNotNull((Object)this.commandBus);
        Assertions.assertNotNull((Object)this.eventProcessingConfigurer);
        Assertions.assertNotNull((Object)this.eventProcessingConfiguration);
        Assertions.assertEquals((Object)this.eventProcessingConfiguration, (Object)this.axonConfig.eventProcessingConfiguration());
        Assertions.assertTrue((boolean)(this.eventBus instanceof EventStore), (String)"Expected Axon to have configured an EventStore");
        Assertions.assertTrue((boolean)(this.commandBus instanceof AsynchronousCommandBus), (String)"Expected provided CommandBus implementation");
        Assertions.assertNotNull((Object)this.axonConfig.repository(Context.MyAggregate.class));
        Assertions.assertNotNull((Object)this.tagsConfiguration);
        Assertions.assertEquals((Object)this.tagsConfiguration, (Object)this.axonConfig.tags());
        Assertions.assertNotNull((Object)this.axonConfig.eventScheduler());
        Assertions.assertNotNull((Object)this.quartzEventScheduler);
    }

    @Test
    void testEventHandlerIsRegistered() {
        this.eventBus.publish(new EventMessage[]{GenericEventMessage.asEventMessage((Object)"Testing 123")});
        Assertions.assertNotNull((Object)this.myEventHandler.eventBus, (String)"Expected EventBus to be wired");
        Assertions.assertTrue((boolean)this.myEventHandler.received.contains("Testing 123"));
        Assertions.assertTrue((boolean)this.myOtherEventHandler.received.contains("Testing 123"));
    }

    @Test
    void testSagaIsConfigured() {
        AtomicInteger counter = new AtomicInteger();
        this.eventProcessingConfigurer.registerHandlerInterceptor("MySagaProcessor", config -> (uow, chain) -> {
            counter.incrementAndGet();
            return chain.proceed();
        });
        this.eventBus.publish(new EventMessage[]{GenericEventMessage.asEventMessage((Object)new SomeEvent("id"))});
        Assertions.assertTrue((boolean)Context.MySaga.events.contains("id"));
        Assertions.assertEquals((int)1, (int)this.customSagaStore.findSagas(Context.MySaga.class, new AssociationValue("id", "id")).size());
        Assertions.assertEquals((int)0, (int)this.sagaStore.findSagas(Context.MySaga.class, new AssociationValue("id", "id")).size());
        Assertions.assertEquals((int)1, (int)counter.get());
    }

    @Test
    void testWiresCommandHandler() {
        FutureCallback callback = new FutureCallback();
        this.commandBus.dispatch(GenericCommandMessage.asCommandMessage((Object)"test"), (CommandCallback)callback);
        callback.getResult(1L, TimeUnit.SECONDS);
        FutureCallback callback2 = new FutureCallback();
        this.commandBus.dispatch(GenericCommandMessage.asCommandMessage((Object)"test"), (CommandCallback)callback2);
        this.commandBus.dispatch(GenericCommandMessage.asCommandMessage((Object)1L), (CommandCallback)callback2);
        callback.getResult(1L, TimeUnit.SECONDS);
        Context.MyCommandHandler ch = (Context.MyCommandHandler)this.applicationContext.getBean(Context.MyCommandHandler.class);
        Assertions.assertTrue((boolean)ch.getCommands().contains("test"));
        ((CommandTargetResolver)Mockito.verify((Object)this.primaryCommandTargetResolver, (VerificationMode)Mockito.timeout((long)500L))).resolveTarget((CommandMessage)ArgumentMatchers.any());
    }

    @Test
    void testCustomCommandTargetResolverWiring() {
        FutureCallback callback1 = new FutureCallback();
        this.commandBus.dispatch(GenericCommandMessage.asCommandMessage((Object)new Context.CreateMyOtherAggregateCommand("id")), (CommandCallback)callback1);
        callback1.getResult();
        Mockito.when((Object)this.myCommandTargetResolver.resolveTarget((CommandMessage)ArgumentMatchers.any())).thenReturn((Object)new VersionedAggregateIdentifier("id", null));
        FutureCallback callback2 = new FutureCallback();
        this.commandBus.dispatch(GenericCommandMessage.asCommandMessage((Object)new Context.UpdateMyOtherAggregateCommand("id")), (CommandCallback)callback2);
        callback2.getResult();
        ((CommandTargetResolver)Mockito.verify((Object)this.myCommandTargetResolver)).resolveTarget((CommandMessage)ArgumentMatchers.any());
    }

    @Test
    void testListenerInvocationErrorHandler() {
        this.eventBus.publish(new EventMessage[]{GenericEventMessage.asEventMessage((Object)"Testing 123")});
        Assertions.assertNotNull((Object)this.myEventHandler.eventBus, (String)"Expected EventBus to be wired");
        Assertions.assertFalse((boolean)this.myListenerInvocationErrorHandler.received.isEmpty());
    }

    @Test
    void testSagaInvocationErrorHandler() {
        this.eventBus.publish(new EventMessage[]{GenericEventMessage.asEventMessage((Object)new SomeEvent("id"))});
        this.eventBus.publish(new EventMessage[]{GenericEventMessage.asEventMessage((Object)new SomeEventWhichHandlingFails("id"))});
        Assertions.assertTrue((boolean)Context.MySaga.events.containsAll(Arrays.asList("id", "id")));
        Assertions.assertEquals((int)1, (int)this.myListenerInvocationErrorHandler.received.size());
        Assertions.assertEquals((Object)"Ooops! I failed.", (Object)this.myListenerInvocationErrorHandler.received.get(0).getMessage());
    }

    @Test
    void testWiringOfQueryHandlerAndQueryUpdateEmitter() {
        GenericSubscriptionQueryMessage queryMessage = new GenericSubscriptionQueryMessage((Object)"axonCR", ResponseTypes.multipleInstancesOf(String.class), ResponseTypes.instanceOf(String.class));
        SubscriptionQueryResult result = this.queryBus.subscriptionQuery((SubscriptionQueryMessage)queryMessage);
        this.eventBus.publish(new EventMessage[]{GenericEventMessage.asEventMessage((Object)"New chat message")});
        StepVerifier.create((Publisher)result.initialResult().map(Message::getPayload)).expectNext(Arrays.asList("Message1", "Message2", "Message3")).verifyComplete();
        StepVerifier.create((Publisher)result.updates().map(Message::getPayload)).expectNext((Object)"New chat message").verifyComplete();
    }

    @Test
    void testHandlerDefinitionAndHandlerEnhancerBeansRegistered() {
        MultiHandlerDefinition handlerDefinition = (MultiHandlerDefinition)this.axonConfig.handlerDefinition(this.getClass());
        MultiHandlerEnhancerDefinition handlerEnhancerDefinition = (MultiHandlerEnhancerDefinition)handlerDefinition.getHandlerEnhancerDefinition();
        Assertions.assertEquals(AnnotatedMessageHandlingMemberDefinition.class, ((HandlerDefinition)handlerDefinition.getDelegates().get(0)).getClass());
        Assertions.assertEquals(Context.HandlerDefinitionWithInjectedResource.class, ((HandlerDefinition)handlerDefinition.getDelegates().get(1)).getClass());
        Assertions.assertEquals(MyHandlerDefinition.class, ((HandlerDefinition)handlerDefinition.getDelegates().get(2)).getClass());
        Assertions.assertEquals(MyHandlerDefinition.class, ((HandlerDefinition)handlerDefinition.getDelegates().get(3)).getClass());
        Set enhancerClasses = handlerEnhancerDefinition.getDelegates().stream().map(Object::getClass).collect(Collectors.toSet());
        Assertions.assertEquals((Object)Sets.newSet((Object[])new Class[]{SagaMethodMessageHandlerDefinition.class, MethodCommandHandlerInterceptorDefinition.class, MethodCommandHandlerDefinition.class, MethodCommandHandlerDefinition.class, MethodQueryMessageHandlerDefinition.class, ReplayAwareMessageHandlerWrapper.class, DeadlineMethodMessageHandlerDefinition.class, MethodCreationPolicyDefinition.class, MethodCreationPolicyDefinition.class, MyHandlerEnhancerDefinition.class, MessageHandlerInterceptorDefinition.class, EndSagaMessageHandlerDefinition.class}), enhancerClasses);
    }

    @Test
    void testEventUpcasterBeanPickedUp() {
        Stream representationStream = (Stream)Mockito.mock(Stream.class);
        this.axonConfig.upcasterChain().upcast(representationStream);
        ((EventUpcaster)Mockito.verify((Object)this.eventUpcaster)).upcast(representationStream);
    }

    @Test
    void testAggregateCaching() {
        FutureCallback callback1 = new FutureCallback();
        this.commandBus.dispatch(GenericCommandMessage.asCommandMessage((Object)new Context.CreateMyCachedAggregateCommand("id")), (CommandCallback)callback1);
        callback1.getResult();
        Assertions.assertNotNull((Object)this.axonConfig.repository(Context.MyCachedAggregate.class));
        Assertions.assertEquals(CachingEventSourcingRepository.class, this.axonConfig.repository(Context.MyCachedAggregate.class).getClass());
    }

    @Test
    void testAggregateLockFactory() {
        String expectedAggregateId = "someIdentifier";
        FutureCallback commandCallback = new FutureCallback();
        this.commandBus.dispatch(GenericCommandMessage.asCommandMessage((Object)new Context.CreateMyCachedAggregateCommand(expectedAggregateId)), (CommandCallback)commandCallback);
        commandCallback.getResult();
        ((LockFactory)Mockito.verify((Object)this.myLockFactory)).obtainLock(expectedAggregateId);
    }

    @Test
    void testEventSchedulerUsesEventSerializer() {
        Mockito.when((Object)this.eventSerializer.serialize(ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(byte[].class))).thenReturn((Object)new SimpleSerializedObject((Object)new byte[1], byte[].class, SerializedType.emptyType()));
        this.quartzEventScheduler.schedule(Instant.now(), (Object)"deadline");
        ((Serializer)Mockito.verify((Object)this.eventSerializer, (VerificationMode)Mockito.times((int)2))).serialize(ArgumentMatchers.any(), (Class)ArgumentMatchers.any());
    }

    private static class MyHandlerEnhancerDefinition
    implements HandlerEnhancerDefinition {
        private MyHandlerEnhancerDefinition() {
        }

        @Nonnull
        public <T> MessageHandlingMember<T> wrapHandler(@Nonnull MessageHandlingMember<T> original) {
            return new MethodCommandHandlerDefinition().wrapHandler(original);
        }
    }

    private static class MyHandlerDefinition
    implements HandlerDefinition {
        private MyHandlerDefinition() {
        }

        public <T> Optional<MessageHandlingMember<T>> createHandler(@Nonnull Class<T> declaringType, @Nonnull Executable executable, @Nonnull ParameterResolverFactory parameterResolverFactory) {
            return Optional.empty();
        }
    }

    public static class SomeEventWhichHandlingFails {
        private final String id;

        public SomeEventWhichHandlingFails(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }

    public static class SomeEvent {
        private final String id;

        public SomeEvent(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }

    @AnnotationDriven
    @Import(value={SpringAxonAutoConfigurer.ImportSelector.class, AnnotationDrivenRegistrar.class})
    @Scope
    @org.springframework.context.annotation.Configuration
    public static class Context {
        @Bean
        public EventProcessingModule eventProcessingConfiguration(@Qualifier(value="customSagaStore") SagaStore<? super MySaga> customSagaStore) {
            EventProcessingModule eventProcessingModule = new EventProcessingModule();
            eventProcessingModule.usingSubscribingEventProcessors().registerSaga(MySaga.class, sc -> sc.configureSagaStore(conf -> customSagaStore));
            return eventProcessingModule;
        }

        @Bean
        public TagsConfiguration tagsConfiguration() {
            return new TagsConfiguration();
        }

        @Primary
        @Bean(destroyMethod="shutdown")
        public CommandBus commandBus() {
            return AsynchronousCommandBus.builder().build();
        }

        @Bean
        public CommandBus simpleCommandBus() {
            return SimpleCommandBus.builder().build();
        }

        @Bean
        public EventStorageEngine eventStorageEngine() {
            return new InMemoryEventStorageEngine();
        }

        @Bean
        public SagaStore sagaStore() {
            return new InMemorySagaStore();
        }

        @Bean
        public SagaStore customSagaStore() {
            return new InMemorySagaStore();
        }

        @Bean
        public EventUpcaster eventUpcaster() {
            return (EventUpcaster)Mockito.mock(EventUpcaster.class);
        }

        @Bean
        @Primary
        @Qualifier(value="primaryCommandTargetResolver")
        public CommandTargetResolver primaryCommandTargetResolver() {
            return (CommandTargetResolver)Mockito.mock(CommandTargetResolver.class);
        }

        @Bean
        @Qualifier(value="myCommandTargetResolver")
        public CommandTargetResolver myCommandTargetResolver() {
            return (CommandTargetResolver)Mockito.mock(CommandTargetResolver.class);
        }

        @Bean
        public Scheduler scheduler() throws SchedulerException {
            Scheduler scheduler = (Scheduler)Mockito.mock(Scheduler.class);
            Mockito.when((Object)scheduler.getContext()).thenReturn(Mockito.mock(SchedulerContext.class));
            return scheduler;
        }

        @Bean
        @Primary
        public Serializer serializer() {
            return XStreamSerializer.builder().xStream(new XStream((HierarchicalStreamDriver)new CompactDriver())).build();
        }

        @Bean
        public Serializer eventSerializer() {
            return (Serializer)Mockito.mock(Serializer.class);
        }

        @Bean
        public QuartzEventSchedulerFactoryBean quartzEventSchedulerFactoryBean() {
            return new QuartzEventSchedulerFactoryBean();
        }

        @Bean
        @Qualifier(value="myCache")
        public Cache myCache() {
            return (Cache)Mockito.mock(Cache.class);
        }

        @Bean
        @Qualifier(value="myLockFactory")
        public LockFactory myLockFactory() {
            return (LockFactory)Mockito.spy((Object)PessimisticLockFactory.usingDefaults());
        }

        @Bean
        public HandlerDefinition myHandlerDefinition1() {
            return new MyHandlerDefinition();
        }

        @Bean
        public HandlerDefinition myHandlerDefinition2() {
            return new MyHandlerDefinition();
        }

        @Bean
        public HandlerEnhancerDefinition myHandlerEnhancerDefinition() {
            return new MyHandlerEnhancerDefinition();
        }

        @Component
        public static class HandlerDefinitionWithInjectedResource
        implements HandlerDefinition {
            private final CommandBus commandBus;

            public HandlerDefinitionWithInjectedResource(CommandBus commandBus) {
                this.commandBus = commandBus;
            }

            public <T> Optional<MessageHandlingMember<T>> createHandler(@Nonnull Class<T> declaringType, @Nonnull Executable executable, @Nonnull ParameterResolverFactory parameterResolverFactory) {
                Assertions.assertNotNull((Object)this.commandBus);
                return Optional.empty();
            }
        }

        @Component
        public static class MyListenerInvocationErrorHandler
        implements ListenerInvocationErrorHandler {
            public List<Exception> received = new ArrayList<Exception>();

            public void onError(@Nonnull Exception exception, @Nonnull EventMessage<?> event, @Nonnull EventMessageHandler eventHandler) {
                this.received.add(exception);
            }
        }

        @Component
        public static class FailingEventHandler {
            @EventHandler
            public void handle(String event) {
                throw new RuntimeException();
            }
        }

        @Component
        public static class MyOtherEventHandler {
            public List<String> received = new ArrayList<String>();

            @EventHandler
            public void handle(String event, MyEventHandler beanInjection) {
                Assertions.assertNotNull((Object)beanInjection);
                this.received.add(event);
            }
        }

        @Component
        public static class MyQueryHandler {
            @QueryHandler
            public List<String> getChatMessages(String chatRoom) {
                return Arrays.asList("Message1", "Message2", "Message3");
            }
        }

        @Component
        public static class MyEventHandler {
            public final List<String> received = new ArrayList<String>();
            private final EventBus eventBus;
            private final QueryUpdateEmitter queryUpdateEmitter;

            public MyEventHandler(EventBus eventBus, QueryUpdateEmitter queryUpdateEmitter) {
                this.eventBus = eventBus;
                this.queryUpdateEmitter = queryUpdateEmitter;
            }

            @EventHandler
            public void handle(String event, MyOtherEventHandler beanInjectionCheck) {
                Assertions.assertNotNull((Object)this.eventBus);
                Assertions.assertNotNull((Object)beanInjectionCheck);
                this.received.add(event);
                this.queryUpdateEmitter.emit(String.class, "axonCR"::equals, (Object)event);
                this.queryUpdateEmitter.complete(String.class, "axonCR"::equals);
            }
        }

        public static class MySaga {
            private static List<String> events = new ArrayList<String>();

            @StartSaga
            @SagaEventHandler(associationProperty="id")
            public void handle(SomeEvent event, MyEventHandler beanInjection) {
                Assertions.assertNotNull((Object)beanInjection);
                events.add(event.getId());
            }

            @SagaEventHandler(associationProperty="id")
            public void handle(SomeEventWhichHandlingFails event) {
                events.add(event.getId());
                throw new RuntimeException("Ooops! I failed.");
            }
        }

        @Component
        public static class MyCommandHandler {
            private List<String> commands = new ArrayList<String>();

            @CommandHandler
            public void handle(String command) {
                this.commands.add(command);
            }

            public List<String> getCommands() {
                return this.commands;
            }
        }

        @Aggregate(cache="myCache", lockFactory="myLockFactory")
        public static class MyCachedAggregate {
            @AggregateIdentifier
            private String id;

            public MyCachedAggregate() {
            }

            @CommandHandler
            public MyCachedAggregate(CreateMyCachedAggregateCommand command) {
                AggregateLifecycle.apply((Object)new MyCachedAggregateCreatedEvent(command.id));
            }

            @EventSourcingHandler
            public void on(MyCachedAggregateCreatedEvent event) {
                this.id = event.id;
            }
        }

        public static class MyCachedAggregateCreatedEvent {
            private final String id;

            public MyCachedAggregateCreatedEvent(String id) {
                this.id = id;
            }
        }

        public static class CreateMyCachedAggregateCommand {
            @TargetAggregateIdentifier
            private final String id;

            public CreateMyCachedAggregateCommand(String id) {
                this.id = id;
            }
        }

        @Aggregate(commandTargetResolver="myCommandTargetResolver")
        public static class MyOtherAggregate {
            @AggregateIdentifier
            private String id;

            public MyOtherAggregate() {
            }

            @CommandHandler
            public MyOtherAggregate(CreateMyOtherAggregateCommand command) {
                AggregateLifecycle.apply((Object)new MyOtherAggregateCreatedEvent(command.id));
            }

            @EventSourcingHandler
            public void on(MyOtherAggregateCreatedEvent event) {
                this.id = event.id;
            }

            @CommandHandler
            public void handle(UpdateMyOtherAggregateCommand command) {
            }
        }

        public static class MyOtherAggregateCreatedEvent {
            private final String id;

            public MyOtherAggregateCreatedEvent(String id) {
                this.id = id;
            }
        }

        public static class UpdateMyOtherAggregateCommand {
            @TargetAggregateIdentifier
            private final String id;

            public UpdateMyOtherAggregateCommand(String id) {
                this.id = id;
            }
        }

        public static class CreateMyOtherAggregateCommand {
            @TargetAggregateIdentifier
            private final String id;

            public CreateMyOtherAggregateCommand(String id) {
                this.id = id;
            }
        }

        @Aggregate(type="MyCustomAggregateType", filterEventsByType=true)
        public static class MyAggregate {
            @AggregateIdentifier
            private String id;

            @CommandHandler
            public void handle(Long command, MyEventHandler beanInjection) {
                Assertions.assertNotNull((Object)beanInjection);
                AggregateLifecycle.apply((Object)command);
            }

            @EventSourcingHandler
            public void on(Long event, MyEventHandler beanInjection) {
                Assertions.assertNotNull((Object)beanInjection);
                this.id = Long.toString(event);
            }

            @EventSourcingHandler
            public void on(String event) {
                Assertions.fail((String)"Event Handler on aggregate shouldn't be invoked");
            }
        }
    }
}

