/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.axonframework.commandhandling.AsynchronousCommandBus;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandHandler;
import org.axonframework.commandhandling.SimpleCommandBus;
import org.axonframework.config.EventProcessingModule;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventHandler;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.eventhandling.SubscribingEventProcessor;
import org.axonframework.eventsourcing.EventSourcingHandler;
import org.axonframework.eventsourcing.eventstore.EventStorageEngine;
import org.axonframework.eventsourcing.eventstore.inmemory.InMemoryEventStorageEngine;
import org.axonframework.messaging.SubscribableMessageSource;
import org.axonframework.messaging.annotation.MetaDataValue;
import org.axonframework.modelling.command.AggregateIdentifier;
import org.axonframework.modelling.saga.SagaEventHandler;
import org.axonframework.modelling.saga.StartSaga;
import org.axonframework.modelling.saga.repository.SagaStore;
import org.axonframework.modelling.saga.repository.inmemory.InMemorySagaStore;
import org.axonframework.spring.config.SpringAxonAutoConfigurer;
import org.axonframework.spring.stereotype.Aggregate;
import org.axonframework.spring.stereotype.Saga;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableMBeanExport;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;
import org.springframework.jmx.support.RegistrationPolicy;
import org.springframework.stereotype.Component;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(value={SpringExtension.class})
@EnableMBeanExport(registration=RegistrationPolicy.IGNORE_EXISTING)
@ContextConfiguration
public class SpringAxonAutoConfigurerTest_CustomEventHandlerConfiguration {
    @Autowired(required=false)
    private EventBus eventBus;
    @Autowired
    private Context.MyEventHandler myEventHandler;
    @Autowired
    private Context.MyOtherEventHandler myOtherEventHandler;

    @Test
    void eventHandlerIsRegisteredWithCustomProcessor() {
        this.eventBus.publish(new EventMessage[]{GenericEventMessage.asEventMessage((Object)"Testing 123")});
        Assertions.assertNotNull((Object)this.myEventHandler.eventBus, (String)"Expected EventBus to be wired");
        Assertions.assertTrue((boolean)this.myEventHandler.received.contains("value"));
        Assertions.assertTrue((boolean)this.myOtherEventHandler.received.contains("Testing 123"));
    }

    public static class SomeEvent {
        private final String id;

        public SomeEvent(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }

    @Import(value={SpringAxonAutoConfigurer.ImportSelector.class})
    @Scope
    @Configuration
    public static class Context {
        @Bean
        public EventProcessingModule eventProcessingConfiguration() {
            EventProcessingModule eventProcessingModule = new EventProcessingModule();
            eventProcessingModule.usingSubscribingEventProcessors();
            eventProcessingModule.byDefaultAssignTo("test").registerEventProcessor("test", (name, config, eventHandlerInvoker) -> {
                SubscribingEventProcessor processor = SubscribingEventProcessor.builder().name(name).eventHandlerInvoker(eventHandlerInvoker).messageSource((SubscribableMessageSource)config.eventBus()).build();
                processor.registerHandlerInterceptor((unitOfWork, interceptorChain) -> {
                    unitOfWork.transformMessage(m -> m.andMetaData(Collections.singletonMap("key", "value")));
                    return interceptorChain.proceed();
                });
                return processor;
            });
            return eventProcessingModule;
        }

        @Primary
        @Bean(destroyMethod="shutdown")
        public CommandBus commandBus() {
            return AsynchronousCommandBus.builder().build();
        }

        @Bean
        public CommandBus simpleCommandBus() {
            return SimpleCommandBus.builder().build();
        }

        @Bean
        public EventStorageEngine eventStorageEngine() {
            return new InMemoryEventStorageEngine();
        }

        @Bean
        public SagaStore sagaStore() {
            return new InMemorySagaStore();
        }

        @Bean
        public SagaStore customSagaStore() {
            return new InMemorySagaStore();
        }

        @Component
        public static class MyOtherEventHandler {
            public List<String> received = new ArrayList<String>();

            @EventHandler
            public void handle(String event) {
                this.received.add(event);
            }
        }

        @Component
        public static class MyEventHandler {
            public List<String> received = new ArrayList<String>();
            private EventBus eventBus;

            public MyEventHandler(EventBus eventBus) {
                this.eventBus = eventBus;
            }

            @EventHandler(payloadType=String.class)
            public void handle(@MetaDataValue(value="key") String event) {
                Assertions.assertNotNull((Object)this.eventBus);
                this.received.add(event);
            }
        }

        @Saga(sagaStore="customSagaStore")
        public static class MySaga {
            private static List<String> events = new ArrayList<String>();

            @StartSaga
            @SagaEventHandler(associationProperty="id")
            public void handle(SomeEvent event) {
                events.add(event.getId());
            }
        }

        @Component
        public static class MyCommandHandler {
            private List<String> commands = new ArrayList<String>();

            @CommandHandler
            public void handle(String command) {
                this.commands.add(command);
            }

            public List<String> getCommands() {
                return this.commands;
            }
        }

        @Aggregate
        public static class MyAggregate {
            @AggregateIdentifier
            private String id;

            @EventSourcingHandler
            public void on(String event) {
                Assertions.fail((String)"Event Handler on aggregate shouldn't be invoked");
            }
        }
    }
}

