/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.config;

import org.axonframework.config.Configuration;
import org.axonframework.config.Configurer;
import org.axonframework.spring.config.SpringAxonConfiguration;
import org.axonframework.spring.event.AxonStartedEvent;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.context.ApplicationContext;

class SpringAxonConfigurationTest {
    SpringAxonConfigurationTest() {
    }

    @Test
    void axonStartedEventIsPublished() {
        Configurer configurer = (Configurer)Mockito.mock(Configurer.class);
        ApplicationContext context = (ApplicationContext)Mockito.mock(ApplicationContext.class);
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configurer.buildConfiguration()).thenReturn((Object)configuration);
        SpringAxonConfiguration springAxonConfiguration = new SpringAxonConfiguration(configurer);
        springAxonConfiguration.setApplicationContext(context);
        springAxonConfiguration.start();
        ((ApplicationContext)Mockito.verify((Object)context)).publishEvent(Mockito.isA(AxonStartedEvent.class));
    }

    @Test
    void lifecyclePhaseIsLowerThanWebServers() {
        int webServerGracefulShutdownLifecyclePhase = 0x7FFFFBFF;
        int webServerDefaultLifecyclePhase = webServerGracefulShutdownLifecyclePhase - 1024;
        SpringAxonConfiguration springAxonConfiguration = new SpringAxonConfiguration((Configurer)Mockito.mock(Configurer.class));
        Assertions.assertTrue((springAxonConfiguration.getPhase() < webServerDefaultLifecyclePhase ? 1 : 0) != 0);
    }
}

