/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.config;

import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.SimpleCommandBus;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.config.Configuration;
import org.axonframework.spring.config.SpringConfigurer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.GenericBeanDefinition;

class SpringConfigurerTest {
    private ConfigurableListableBeanFactory context;

    SpringConfigurerTest() {
    }

    @BeforeEach
    void setUp() {
        this.context = (ConfigurableListableBeanFactory)Mockito.mock(ConfigurableListableBeanFactory.class);
        Mockito.when((Object)this.context.getBeanNamesForType((Class)Mockito.any(Class.class))).thenReturn((Object)new String[0]);
    }

    @Test
    void springComponentLoadedWhenNoComponentConfigured() {
        Mockito.when((Object)this.context.getBeanNamesForType(CommandBus.class)).thenReturn((Object)new String[]{"commandBus"});
        SimpleCommandBus commandBus = SimpleCommandBus.builder().build();
        Mockito.when((Object)this.context.getBean("commandBus", CommandBus.class)).thenReturn((Object)commandBus);
        SpringConfigurer configurer = new SpringConfigurer(this.context);
        Assertions.assertSame((Object)commandBus, (Object)configurer.buildConfiguration().commandBus());
    }

    @Test
    void springPrimaryBeanUsedWhenMultipleCandidates() {
        Mockito.when((Object)this.context.getBeanNamesForType(CommandBus.class)).thenReturn((Object)new String[]{"commandBus", "alternative"});
        Mockito.when((Object)this.context.getMergedBeanDefinition((String)Mockito.any())).thenReturn((Object)new GenericBeanDefinition());
        GenericBeanDefinition primary = new GenericBeanDefinition();
        primary.setPrimary(true);
        Mockito.when((Object)this.context.getMergedBeanDefinition("commandBus")).thenReturn((Object)primary);
        SimpleCommandBus commandBus = SimpleCommandBus.builder().build();
        Mockito.when((Object)this.context.getBean("commandBus", CommandBus.class)).thenReturn((Object)commandBus);
        SpringConfigurer configurer = new SpringConfigurer(this.context);
        Assertions.assertSame((Object)commandBus, (Object)configurer.buildConfiguration().commandBus());
        ((ConfigurableListableBeanFactory)Mockito.verify((Object)this.context, (VerificationMode)Mockito.never())).getBean((String)Mockito.eq((Object)"alternative"), (Class)Mockito.any(Class.class));
    }

    @Test
    void failsWhenMultiplePrimaryCandidates() {
        Mockito.when((Object)this.context.getBeanNamesForType(CommandBus.class)).thenReturn((Object)new String[]{"commandBus", "alternative"});
        GenericBeanDefinition primary = new GenericBeanDefinition();
        primary.setPrimary(true);
        Mockito.when((Object)this.context.getMergedBeanDefinition((String)Mockito.any())).thenReturn((Object)primary);
        SimpleCommandBus commandBus = SimpleCommandBus.builder().build();
        Mockito.when((Object)this.context.getBean("commandBus", CommandBus.class)).thenReturn((Object)commandBus);
        SpringConfigurer configurer = new SpringConfigurer(this.context);
        Configuration configuration = configurer.buildConfiguration();
        Assertions.assertThrows(AxonConfigurationException.class, () -> ((Configuration)configuration).commandBus());
        ((ConfigurableListableBeanFactory)Mockito.verify((Object)this.context, (VerificationMode)Mockito.never())).getBean(Mockito.anyString(), (Class)Mockito.any(Class.class));
    }

    @Test
    void failsWhenMultipleNonPrimaryCandidates() {
        Mockito.when((Object)this.context.getBeanNamesForType(CommandBus.class)).thenReturn((Object)new String[]{"commandBus", "alternative"});
        GenericBeanDefinition nonPrimary = new GenericBeanDefinition();
        Mockito.when((Object)this.context.getMergedBeanDefinition((String)Mockito.any())).thenReturn((Object)nonPrimary);
        SimpleCommandBus commandBus = SimpleCommandBus.builder().build();
        Mockito.when((Object)this.context.getBean("commandBus", CommandBus.class)).thenReturn((Object)commandBus);
        SpringConfigurer configurer = new SpringConfigurer(this.context);
        Configuration configuration = configurer.buildConfiguration();
        Assertions.assertThrows(AxonConfigurationException.class, () -> ((Configuration)configuration).commandBus());
        ((ConfigurableListableBeanFactory)Mockito.verify((Object)this.context, (VerificationMode)Mockito.never())).getBean(Mockito.anyString(), (Class)Mockito.any(Class.class));
    }

    @Test
    void usesConfigurerDefaultsWhenNoBeansDefined() {
        SpringConfigurer configurer = new SpringConfigurer(this.context);
        Assertions.assertNotNull((Object)configurer.buildConfiguration().commandBus());
        ((ConfigurableListableBeanFactory)Mockito.verify((Object)this.context, (VerificationMode)Mockito.never())).getBean(Mockito.anyString(), (Class)Mockito.any(Class.class));
    }
}

