/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.config;

import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.axonframework.config.Configuration;
import org.axonframework.config.EventProcessingModule;
import org.axonframework.serialization.upcasting.event.EventUpcaster;
import org.axonframework.serialization.upcasting.event.EventUpcasterChain;
import org.axonframework.serialization.upcasting.event.IntermediateEventRepresentation;
import org.axonframework.spring.config.SpringAxonAutoConfigurer;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Scope;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ContextConfiguration
@ExtendWith(value={SpringExtension.class})
class UpcasterOrderingTest {
    @Autowired
    private Configuration axonConfig;

    UpcasterOrderingTest() {
    }

    @Test
    void upcastersAreRegisteredInOrder() {
        Stream mockStream = (Stream)Mockito.mock(Stream.class);
        EventUpcasterChain testSubject = this.axonConfig.upcasterChain();
        testSubject.upcast(mockStream);
        InOrder upcasterOrder = Mockito.inOrder((Object[])new Object[]{mockStream});
        ((Stream)upcasterOrder.verify((Object)mockStream)).sorted();
        ((Stream)upcasterOrder.verify((Object)mockStream)).filter((Predicate)Mockito.any());
        ((Stream)upcasterOrder.verify((Object)mockStream)).distinct();
        ((Stream)upcasterOrder.verify((Object)mockStream)).map((Function)Mockito.any());
    }

    private static class ThirdUpcaster
    implements EventUpcaster {
        private ThirdUpcaster() {
        }

        public Stream<IntermediateEventRepresentation> upcast(Stream<IntermediateEventRepresentation> intermediateRepresentations) {
            intermediateRepresentations.distinct();
            return intermediateRepresentations;
        }
    }

    @Scope
    @org.springframework.context.annotation.Configuration
    public static class OtherTestContext {
        @Bean
        @Order(value=2)
        public ThirdUpcaster someSecondUpcaster() {
            return new ThirdUpcaster();
        }

        @Order(value=1)
        @Component
        public static class SecondUpcaster
        implements EventUpcaster {
            public Stream<IntermediateEventRepresentation> upcast(Stream<IntermediateEventRepresentation> intermediateRepresentations) {
                intermediateRepresentations.filter(ier -> true);
                return intermediateRepresentations;
            }
        }
    }

    @Scope
    @Import(value={SpringAxonAutoConfigurer.ImportSelector.class})
    @org.springframework.context.annotation.Configuration
    public static class TestContext {
        @Bean
        public EventProcessingModule eventProcessingModule() {
            return new EventProcessingModule();
        }

        @Order(value=0)
        @Component
        public static class FirstUpcaster
        implements EventUpcaster {
            public Stream<IntermediateEventRepresentation> upcast(Stream<IntermediateEventRepresentation> intermediateRepresentations) {
                intermediateRepresentations.sorted();
                return intermediateRepresentations;
            }
        }

        @Component
        public static class UnorderedUpcaster
        implements EventUpcaster {
            public Stream<IntermediateEventRepresentation> upcast(Stream<IntermediateEventRepresentation> intermediateRepresentations) {
                intermediateRepresentations.map(ier -> ier);
                return intermediateRepresentations;
            }
        }
    }
}

