/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.config.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.axonframework.commandhandling.CommandHandler;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.GenericCommandMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageHandler;
import org.axonframework.spring.config.annotation.AnnotationCommandHandlerBeanPostProcessor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.FactoryBean;

class AnnotationCommandHandlerBeanPostProcessorTest {
    private AnnotationCommandHandlerBeanPostProcessor testSubject;

    AnnotationCommandHandlerBeanPostProcessorTest() {
    }

    @BeforeEach
    void setUp() {
        this.testSubject = new AnnotationCommandHandlerBeanPostProcessor();
    }

    @Test
    void commandHandlerCallsRedirectToAdapter() throws Exception {
        BeanFactory mockBeanFactory = (BeanFactory)Mockito.mock(BeanFactory.class);
        this.testSubject.setBeanFactory(mockBeanFactory);
        Object result1 = this.testSubject.postProcessBeforeInitialization((Object)new AnnotatedCommandHandler(), "beanName");
        Object postProcessedBean = this.testSubject.postProcessAfterInitialization(result1, "beanName");
        Assertions.assertTrue((boolean)(postProcessedBean instanceof MessageHandler));
        Assertions.assertTrue((boolean)(postProcessedBean instanceof AnnotatedCommandHandler));
        MessageHandler commandHandler = (MessageHandler)postProcessedBean;
        AnnotatedCommandHandler annotatedCommandHandler = (AnnotatedCommandHandler)postProcessedBean;
        CommandMessage myCommand = GenericCommandMessage.asCommandMessage((Object)new MyCommand());
        commandHandler.handle((Message)myCommand);
        Assertions.assertEquals((int)1, (int)annotatedCommandHandler.getInvocationCount());
    }

    @Test
    void commandHandlerCallsRedirectToAdapterWhenUsingCustomAnnotation() throws Exception {
        BeanFactory mockBeanFactory = (BeanFactory)Mockito.mock(BeanFactory.class);
        this.testSubject.setBeanFactory(mockBeanFactory);
        Object result1 = this.testSubject.postProcessBeforeInitialization((Object)new CustomAnnotatedCommandHandler(), "beanName");
        Object postProcessedBean = this.testSubject.postProcessAfterInitialization(result1, "beanName");
        Assertions.assertTrue((boolean)(postProcessedBean instanceof MessageHandler));
        Assertions.assertTrue((boolean)(postProcessedBean instanceof CustomAnnotatedCommandHandler));
        MessageHandler commandHandler = (MessageHandler)postProcessedBean;
        CustomAnnotatedCommandHandler annotatedCommandHandler = (CustomAnnotatedCommandHandler)postProcessedBean;
        CommandMessage myCommand = GenericCommandMessage.asCommandMessage((Object)new MyCommand());
        commandHandler.handle((Message)myCommand);
        Assertions.assertEquals((int)1, (int)annotatedCommandHandler.getInvocationCount());
    }

    @Test
    void processorIgnoresFactoryBeans() {
        BeanFactory mockBeanFactory = (BeanFactory)Mockito.mock(BeanFactory.class);
        Mockito.when((Object)mockBeanFactory.containsBean("beanName")).thenReturn((Object)true);
        FactoryBean mockFactoryBean = (FactoryBean)Mockito.mock(FactoryBean.class);
        this.testSubject.setBeanFactory(mockBeanFactory);
        Object result1 = this.testSubject.postProcessBeforeInitialization((Object)mockFactoryBean, "beanName");
        Object postProcessedBean = this.testSubject.postProcessAfterInitialization((Object)mockFactoryBean, "beanName");
        Assertions.assertSame((Object)mockFactoryBean, (Object)result1);
        Assertions.assertSame((Object)mockFactoryBean, (Object)postProcessedBean);
        ((BeanFactory)Mockito.verify((Object)mockBeanFactory, (VerificationMode)Mockito.never())).isSingleton(Mockito.anyString());
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @CommandHandler
    private static @interface MyCustomCommand {
    }

    private static class MyCommand {
        private MyCommand() {
        }
    }

    public static class CustomAnnotatedCommandHandler {
        private int invocationCount;

        @MyCustomCommand
        public void handleCommand(MyCommand command) {
            ++this.invocationCount;
        }

        public int getInvocationCount() {
            return this.invocationCount;
        }
    }

    public static class AnnotatedCommandHandler {
        private int invocationCount;

        @CommandHandler
        public void handleCommand(MyCommand command) {
            ++this.invocationCount;
        }

        public int getInvocationCount() {
            return this.invocationCount;
        }
    }
}

