/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.config.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageHandler;
import org.axonframework.messaging.responsetypes.ResponseTypes;
import org.axonframework.queryhandling.GenericQueryMessage;
import org.axonframework.queryhandling.QueryHandler;
import org.axonframework.spring.config.annotation.AnnotationQueryHandlerBeanPostProcessor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.FactoryBean;

class AnnotationQueryHandlerBeanPostProcessorTest {
    private AnnotationQueryHandlerBeanPostProcessor testSubject;

    AnnotationQueryHandlerBeanPostProcessorTest() {
    }

    @BeforeEach
    void setUp() {
        this.testSubject = new AnnotationQueryHandlerBeanPostProcessor();
    }

    @Test
    void queryHandlerCallsRedirectToAdapter() throws Exception {
        BeanFactory mockBeanFactory = (BeanFactory)Mockito.mock(BeanFactory.class);
        this.testSubject.setBeanFactory(mockBeanFactory);
        Object result1 = this.testSubject.postProcessBeforeInitialization((Object)new AnnotatedQueryHandler(), "beanName");
        Object postProcessedBean = this.testSubject.postProcessAfterInitialization(result1, "beanName");
        Assertions.assertTrue((boolean)(postProcessedBean instanceof MessageHandler));
        Assertions.assertTrue((boolean)(postProcessedBean instanceof AnnotatedQueryHandler));
        MessageHandler queryHandler = (MessageHandler)postProcessedBean;
        AnnotatedQueryHandler annotatedQueryHandler = (AnnotatedQueryHandler)postProcessedBean;
        GenericQueryMessage myCommand = new GenericQueryMessage((Object)new MyQuery(), ResponseTypes.instanceOf(Integer.class));
        Assertions.assertEquals((Object)0, (Object)queryHandler.handle((Message)myCommand));
        Assertions.assertEquals((int)1, (int)annotatedQueryHandler.getInvocationCount());
    }

    @Test
    void queryHandlerCallsRedirectToAdapterWhenUsingCustomAnnotation() throws Exception {
        BeanFactory mockBeanFactory = (BeanFactory)Mockito.mock(BeanFactory.class);
        this.testSubject.setBeanFactory(mockBeanFactory);
        Object result1 = this.testSubject.postProcessBeforeInitialization((Object)new CustomAnnotatedQueryHandler(), "beanName");
        Object postProcessedBean = this.testSubject.postProcessAfterInitialization(result1, "beanName");
        Assertions.assertTrue((boolean)(postProcessedBean instanceof MessageHandler));
        Assertions.assertTrue((boolean)(postProcessedBean instanceof CustomAnnotatedQueryHandler));
        MessageHandler queryHandler = (MessageHandler)postProcessedBean;
        CustomAnnotatedQueryHandler annotatedQueryHandler = (CustomAnnotatedQueryHandler)postProcessedBean;
        GenericQueryMessage myCommand = new GenericQueryMessage((Object)new MyQuery(), ResponseTypes.instanceOf(Integer.class));
        Assertions.assertEquals((Object)0, (Object)queryHandler.handle((Message)myCommand));
        Assertions.assertEquals((int)1, (int)annotatedQueryHandler.getInvocationCount());
    }

    @Test
    void processorIgnoresFactoryBeans() {
        BeanFactory mockBeanFactory = (BeanFactory)Mockito.mock(BeanFactory.class);
        Mockito.when((Object)mockBeanFactory.containsBean("beanName")).thenReturn((Object)true);
        FactoryBean mockFactoryBean = (FactoryBean)Mockito.mock(FactoryBean.class);
        this.testSubject.setBeanFactory(mockBeanFactory);
        Object result1 = this.testSubject.postProcessBeforeInitialization((Object)mockFactoryBean, "beanName");
        Object postProcessedBean = this.testSubject.postProcessAfterInitialization((Object)mockFactoryBean, "beanName");
        Assertions.assertSame((Object)mockFactoryBean, (Object)result1);
        Assertions.assertSame((Object)mockFactoryBean, (Object)postProcessedBean);
        ((BeanFactory)Mockito.verify((Object)mockBeanFactory, (VerificationMode)Mockito.never())).isSingleton(Mockito.anyString());
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @QueryHandler
    private static @interface MyCustomQuery {
    }

    private static class MyQuery {
        private MyQuery() {
        }
    }

    public static class CustomAnnotatedQueryHandler {
        private int invocationCount;

        @MyCustomQuery
        public Integer handleCommand(MyQuery query) {
            return this.invocationCount++;
        }

        public int getInvocationCount() {
            return this.invocationCount;
        }
    }

    public static class AnnotatedQueryHandler {
        private int invocationCount;

        @QueryHandler
        public Integer handleCommand(MyQuery query) {
            return this.invocationCount++;
        }

        public int getInvocationCount() {
            return this.invocationCount;
        }
    }
}

