/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.config.annotation;

import java.util.concurrent.atomic.AtomicInteger;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.SimpleCommandBus;
import org.axonframework.eventhandling.AnnotationEventHandlerAdapter;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventHandler;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.eventhandling.SimpleEventBus;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.spring.config.AnnotationDriven;
import org.axonframework.test.FixtureExecutionException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableMBeanExport;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;
import org.springframework.jmx.support.RegistrationPolicy;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(value={SpringExtension.class})
@ContextConfiguration(classes={AppContext.class})
@EnableMBeanExport(registration=RegistrationPolicy.IGNORE_EXISTING)
public class SpringBeanResolverFactoryTest {
    @Autowired
    private AnnotatedEventHandlerWithResources annotatedHandler;
    @Autowired
    private ApplicationContext applicationContext;
    private static final AtomicInteger counter = new AtomicInteger();
    @Autowired
    private ParameterResolverFactory parameterResolver;

    @BeforeEach
    void setUp() {
        counter.set(0);
        Assertions.assertTrue((boolean)((DuplicateResourceWithPrimary)this.applicationContext.getBean("duplicateResourceWithPrimary1", DuplicateResourceWithPrimary.class)).isPrimary());
        Assertions.assertFalse((boolean)((DuplicateResourceWithPrimary)this.applicationContext.getBean("duplicateResourceWithPrimary2", DuplicateResourceWithPrimary.class)).isPrimary());
    }

    @Test
    void methodsAreProperlyInjected() throws Exception {
        Assertions.assertNotNull((Object)this.annotatedHandler);
        new AnnotationEventHandlerAdapter((Object)this.annotatedHandler, this.parameterResolver).handle(GenericEventMessage.asEventMessage((Object)"Hello"));
        Assertions.assertEquals((int)1, (int)counter.get());
    }

    @Test
    void newInstanceIsCreatedEachTimePrototypeResourceIsInjected() throws Exception {
        Object handler = this.applicationContext.getBean("prototypeResourceHandler");
        AnnotationEventHandlerAdapter adapter = new AnnotationEventHandlerAdapter(handler, (ParameterResolverFactory)this.applicationContext.getBean(ParameterResolverFactory.class));
        adapter.handle(GenericEventMessage.asEventMessage((Object)"Hello1"));
        adapter.handle(GenericEventMessage.asEventMessage((Object)"Hello2"));
        Assertions.assertEquals((int)2, (int)counter.get());
    }

    @Test
    void methodsAreProperlyInjected_ErrorOnMissingParameterType() {
        Object bean = this.applicationContext.getBean("missingResourceHandler");
        AnnotationEventHandlerAdapter adapter = new AnnotationEventHandlerAdapter(bean, this.parameterResolver);
        Assertions.assertThrows(FixtureExecutionException.class, () -> adapter.handle(GenericEventMessage.asEventMessage((Object)"Hi there")));
    }

    @Test
    void methodsAreProperlyInjected_NullableParameterType() throws Exception {
        new AnnotationEventHandlerAdapter(this.applicationContext.getBean("nullableResourceHandler"), this.parameterResolver).handle(GenericEventMessage.asEventMessage((Object)"Hi there"));
        Assertions.assertEquals((int)1, (int)counter.get());
    }

    @Test
    void methodsAreProperlyInjected_ErrorOnDuplicateParameterType() {
        Object bean = this.applicationContext.getBean("duplicateResourceHandler");
        AnnotationEventHandlerAdapter adapter = new AnnotationEventHandlerAdapter(bean, this.parameterResolver);
        Assertions.assertThrows(FixtureExecutionException.class, () -> adapter.handle(GenericEventMessage.asEventMessage((Object)"Hi there")));
    }

    @Test
    @DirtiesContext
    void methodsAreProperlyInjected_DuplicateParameterTypeWithPrimary() throws Exception {
        new AnnotationEventHandlerAdapter(this.applicationContext.getBean("duplicateResourceHandlerWithPrimary"), this.parameterResolver).handle(GenericEventMessage.asEventMessage((Object)"Hi there"));
        Assertions.assertEquals((int)1, (int)counter.get());
    }

    @Test
    @DirtiesContext
    void methodsAreProperlyInjected_DuplicateParameterTypeWithQualifier() throws Exception {
        new AnnotationEventHandlerAdapter(this.applicationContext.getBean("duplicateResourceHandlerWithQualifier"), this.parameterResolver).handle(GenericEventMessage.asEventMessage((Object)"Hi there"));
        Assertions.assertEquals((int)1, (int)counter.get());
    }

    @Test
    @DirtiesContext
    void methodsAreProperlyInjected_QualifierPrecedesPrimary() throws Exception {
        new AnnotationEventHandlerAdapter(this.applicationContext.getBean("duplicateResourceHandlerWithQualifierAndPrimary"), this.parameterResolver).handle(GenericEventMessage.asEventMessage((Object)"Hi there"));
        Assertions.assertEquals((int)1, (int)counter.get());
    }

    @Test
    @DirtiesContext
    void methodsAreProperlyInjected_DuplicateParameterWithAutowired() {
        Object handler = this.applicationContext.getBean("duplicateResourceHandlerWithAutowired");
        AnnotationEventHandlerAdapter adapter = new AnnotationEventHandlerAdapter(handler, (ParameterResolverFactory)this.applicationContext.getBean(ParameterResolverFactory.class));
        Assertions.assertThrows(NoUniqueBeanDefinitionException.class, () -> adapter.handle(GenericEventMessage.asEventMessage((Object)"Hi there")));
    }

    @Test
    @DirtiesContext
    void methodsAreProperlyInjectedForDuplicateResourceHandlerWithAutowiredAndQualifier() throws Exception {
        new AnnotationEventHandlerAdapter(this.applicationContext.getBean("duplicateResourceHandlerWithAutowiredAndQualifier"), this.parameterResolver).handle(GenericEventMessage.asEventMessage((Object)"Hi there"));
        Assertions.assertEquals((int)1, (int)counter.get());
    }

    private static interface ThisResourceReallyDoesntExist {
    }

    public static class AnnotatedEventHandlerWithResources {
        @EventHandler
        public void handle(String message, CommandBus commandBus, EventBus eventBus) {
            Assertions.assertNotNull((Object)message);
            Assertions.assertNotNull((Object)commandBus);
            Assertions.assertNotNull((Object)eventBus);
            counter.incrementAndGet();
        }
    }

    public static class PrototypeResourceHandler {
        private PrototypeResource resource;

        @EventHandler
        public void handle(String message, PrototypeResource resource) {
            this.resource = resource;
            Assertions.assertNotEquals((Object)this.resource, (Object)this.resource);
            counter.incrementAndGet();
        }
    }

    public static class DuplicateResourceHandlerWithAutowiredAndQualifier {
        @EventHandler
        public void handle(String message, @Autowired @Qualifier(value="qualifiedByName") DuplicateResourceWithQualifier resource) {
            counter.incrementAndGet();
        }
    }

    public static class DuplicateResourceHandlerWithAutowired {
        @EventHandler
        public void handle(String message, @Autowired DuplicateResource resource) {
            counter.incrementAndGet();
        }
    }

    public static class DuplicateResourceHandlerWithQualifierAndPrimary {
        @EventHandler
        public void handle(String message, @Qualifier(value="duplicateResourceWithPrimary2") DuplicateResourceWithPrimary resource) {
            Assertions.assertFalse((boolean)resource.isPrimary(), (String)"expect the non-primary bean to be autowired here");
            counter.incrementAndGet();
        }
    }

    public static class DuplicateResourceHandlerWithQualifier {
        @EventHandler
        public void handle(String message, @Qualifier(value="qualifiedByName") DuplicateResourceWithQualifier resource) {
            counter.incrementAndGet();
        }
    }

    public static class DuplicateResourceHandlerWithPrimary {
        @EventHandler
        public void handle(String message, DuplicateResourceWithPrimary dataSource) {
            counter.incrementAndGet();
        }
    }

    public static class DuplicateResourceHandler {
        @EventHandler
        public void handle(String message, DuplicateResource dataSource) {
            counter.incrementAndGet();
        }
    }

    public static class NullableResourceHandler {
        @EventHandler
        public void handle(String message, @Autowired(required=false) ThisResourceReallyDoesntExist dataSource) {
            counter.incrementAndGet();
        }
    }

    public static class MissingResourceHandler {
        @EventHandler
        public void handle(String message, ThisResourceReallyDoesntExist dataSource) {
            counter.incrementAndGet();
        }
    }

    public static interface PrototypeResource {
    }

    @AnnotationDriven
    @Configuration
    public static class AppContext {
        @Bean(name={"annotatedHandler"})
        public AnnotatedEventHandlerWithResources createHandler() {
            return new AnnotatedEventHandlerWithResources();
        }

        @Lazy
        @Bean
        public MissingResourceHandler missingResourceHandler() {
            return new MissingResourceHandler();
        }

        @Lazy
        @Bean
        public NullableResourceHandler nullableResourceHandler() {
            return new NullableResourceHandler();
        }

        @Lazy
        @Bean
        public DuplicateResourceHandler duplicateResourceHandler() {
            return new DuplicateResourceHandler();
        }

        @Lazy
        @Bean
        public DuplicateResourceHandlerWithPrimary duplicateResourceHandlerWithPrimary() {
            return new DuplicateResourceHandlerWithPrimary();
        }

        @Lazy
        @Bean
        public DuplicateResourceHandlerWithQualifier duplicateResourceHandlerWithQualifier() {
            return new DuplicateResourceHandlerWithQualifier();
        }

        @Lazy
        @Bean
        public DuplicateResourceHandlerWithQualifierAndPrimary duplicateResourceHandlerWithQualifierAndPrimary() {
            return new DuplicateResourceHandlerWithQualifierAndPrimary();
        }

        @Lazy
        @Bean
        public DuplicateResourceHandlerWithAutowired duplicateResourceHandlerWithAutowired() {
            return new DuplicateResourceHandlerWithAutowired();
        }

        @Lazy
        @Bean
        public DuplicateResourceHandlerWithAutowiredAndQualifier duplicateResourceHandlerWithAutowiredAndQualifier() {
            return new DuplicateResourceHandlerWithAutowiredAndQualifier();
        }

        @Lazy
        @Bean
        public PrototypeResourceHandler prototypeResourceHandler() {
            return new PrototypeResourceHandler();
        }

        @Bean
        public DuplicateResource duplicateResource1() {
            return new DuplicateResource(){};
        }

        @Bean
        public DuplicateResource duplicateResource2() {
            return new DuplicateResource(){};
        }

        @Primary
        @Bean
        public DuplicateResourceWithPrimary duplicateResourceWithPrimary1() {
            return () -> true;
        }

        @Bean
        public DuplicateResourceWithPrimary duplicateResourceWithPrimary2() {
            return () -> false;
        }

        @Bean
        public DuplicateResourceWithQualifier duplicateResourceWithQualifier1() {
            return new DuplicateResourceWithQualifier(){};
        }

        @Bean(value={"qualifiedByName"})
        public DuplicateResourceWithQualifier duplicateResourceWithQualifier2() {
            return new DuplicateResourceWithQualifier(){};
        }

        @Bean
        @Scope(value="prototype")
        public PrototypeResource prototypeResource() {
            return new PrototypeResource(){};
        }

        @Bean
        public CommandBus commandBus() {
            return SimpleCommandBus.builder().build();
        }

        @Bean
        public EventBus eventBus() {
            return SimpleEventBus.builder().build();
        }
    }

    public static interface DuplicateResourceWithQualifier {
    }

    public static interface DuplicateResource {
    }

    public static interface DuplicateResourceWithPrimary {
        public boolean isPrimary();
    }
}

