/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.eventhandling.deadletter;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContext;
import javax.sql.DataSource;
import org.axonframework.common.legacyjpa.EntityManagerProvider;
import org.axonframework.common.legacyjpa.SimpleEntityManagerProvider;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.eventhandling.deadletter.DeadLetteringEventIntegrationTest;
import org.axonframework.eventhandling.deadletter.jpa.DeadLetterEntry;
import org.axonframework.eventhandling.deadletter.jpa.DeadLetterEventEntry;
import org.axonframework.eventhandling.deadletter.legacyjpa.DeadLetterJpaConverter;
import org.axonframework.eventhandling.deadletter.legacyjpa.EventMessageDeadLetterJpaConverter;
import org.axonframework.eventhandling.deadletter.legacyjpa.JpaDeadLetter;
import org.axonframework.eventhandling.deadletter.legacyjpa.JpaSequencedDeadLetterQueue;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.deadletter.Cause;
import org.axonframework.messaging.deadletter.DeadLetter;
import org.axonframework.messaging.deadletter.GenericDeadLetter;
import org.axonframework.messaging.deadletter.SequencedDeadLetterQueue;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.TestSerializer;
import org.axonframework.spring.messaging.unitofwork.SpringTransactionManager;
import org.axonframework.spring.utils.MysqlTestContainerExtension;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.Extensions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.EnableMBeanExport;
import org.springframework.jmx.support.RegistrationPolicy;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.support.PersistenceAnnotationBeanPostProcessor;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.test.context.junit.jupiter.SpringExtension;
import org.springframework.transaction.PlatformTransactionManager;

@Extensions(value={@ExtendWith(value={SpringExtension.class}), @ExtendWith(value={MysqlTestContainerExtension.class})})
@EnableMBeanExport(registration=RegistrationPolicy.IGNORE_EXISTING)
class SpringJpaDeadLetteringIntegrationTest
extends DeadLetteringEventIntegrationTest {
    @Autowired
    private PlatformTransactionManager platformTransactionManager;
    @Autowired
    private EntityManagerProvider entityManagerProvider;
    private final Serializer serializer = TestSerializer.JACKSON.getSerializer();
    private final DeadLetterJpaConverter<EventMessage<?>> converter = new EventMessageDeadLetterJpaConverter();
    private JpaSequencedDeadLetterQueue<EventMessage<?>> jpaDeadLetterQueue;

    SpringJpaDeadLetteringIntegrationTest() {
    }

    @BeforeEach
    public void clear() {
        this.getTransactionManager().executeInTransaction(() -> this.entityManagerProvider.getEntityManager().createQuery("delete from DeadLetterEntry e").executeUpdate());
    }

    protected TransactionManager getTransactionManager() {
        return new SpringTransactionManager(this.platformTransactionManager);
    }

    protected SequencedDeadLetterQueue<EventMessage<?>> buildDeadLetterQueue() {
        this.jpaDeadLetterQueue = JpaSequencedDeadLetterQueue.builder().processingGroup("problematicProcessingGroup").entityManagerProvider(this.entityManagerProvider).transactionManager(this.getTransactionManager()).serializer(this.serializer).addConverter(this.converter).build();
        return this.jpaDeadLetterQueue;
    }

    @Test
    void deadLetterSequenceReturnsMatchingEnqueuedLettersInInsertOrder() {
        String aggregateId = UUID.randomUUID().toString();
        HashMap insertedLetters = new HashMap();
        Iterator resultIterator = this.jpaDeadLetterQueue.deadLetterSequence((Object)aggregateId).iterator();
        Assertions.assertFalse((boolean)resultIterator.hasNext());
        IntStream.range(0, 64).boxed().sorted(Collections.reverseOrder()).forEach(i -> {
            GenericDeadLetter letter = new GenericDeadLetter((Object)aggregateId, (Message)GenericEventMessage.asEventMessage((Object)i));
            this.insertLetterAtIndex(aggregateId, (DeadLetter<EventMessage<?>>)letter, (int)i);
            insertedLetters.put(i, letter);
        });
        resultIterator = this.jpaDeadLetterQueue.deadLetterSequence((Object)aggregateId).iterator();
        for (Map.Entry entry : insertedLetters.entrySet()) {
            Integer sequenceIndex = (Integer)entry.getKey();
            Supplier<String> assertMessageSupplier = () -> "Failed asserting event [" + sequenceIndex + "]";
            Assertions.assertTrue((boolean)resultIterator.hasNext(), assertMessageSupplier);
            GenericDeadLetter expected = (GenericDeadLetter)entry.getValue();
            DeadLetter result = (DeadLetter)resultIterator.next();
            Assertions.assertTrue((boolean)(result instanceof JpaDeadLetter));
            JpaDeadLetter actual = (JpaDeadLetter)result;
            Assertions.assertEquals((Object)expected.getSequenceIdentifier(), (Object)actual.getSequenceIdentifier(), assertMessageSupplier);
            Assertions.assertEquals((Object)((EventMessage)expected.message()).getPayload(), (Object)actual.message().getPayload(), assertMessageSupplier);
            Assertions.assertFalse((boolean)result.cause().isPresent(), assertMessageSupplier);
            Assertions.assertEquals((Object)expected.diagnostics(), (Object)actual.diagnostics(), assertMessageSupplier);
            Assertions.assertEquals((long)sequenceIndex.longValue(), (Long)actual.getIndex(), assertMessageSupplier);
        }
    }

    private void insertLetterAtIndex(String aggregateId, DeadLetter<EventMessage<?>> letter, int index) {
        this.transactionManager.executeInTransaction(() -> {
            DeadLetterEventEntry eventEntry = this.converter.convert((EventMessage)letter.message(), this.serializer, this.serializer);
            DeadLetterEntry deadLetter = new DeadLetterEntry("problematicProcessingGroup", aggregateId, (long)index, eventEntry, letter.enqueuedAt(), letter.lastTouched(), (Cause)letter.cause().orElse(null), letter.diagnostics(), this.serializer);
            this.entityManagerProvider.getEntityManager().persist((Object)deadLetter);
        });
    }

    @Configuration
    public static class TestContext {
        @Bean
        public DataSource dataSource() {
            return MysqlTestContainerExtension.getInstance().asDataSource();
        }

        @Bean(value={"entityManagerFactory"})
        public LocalContainerEntityManagerFactoryBean entityManagerFactory(DataSource dataSource) {
            LocalContainerEntityManagerFactoryBean entityManagerFactoryBean = new LocalContainerEntityManagerFactoryBean();
            entityManagerFactoryBean.setPersistenceUnitName("AxonSpringTest");
            HibernateJpaVendorAdapter jpaVendorAdapter = new HibernateJpaVendorAdapter();
            jpaVendorAdapter.setGenerateDdl(true);
            jpaVendorAdapter.setShowSql(false);
            entityManagerFactoryBean.setJpaVendorAdapter((JpaVendorAdapter)jpaVendorAdapter);
            entityManagerFactoryBean.setDataSource(dataSource);
            return entityManagerFactoryBean;
        }

        @Bean
        @DependsOn(value={"entityManagerFactory"})
        public JpaTransactionManager transactionManager(EntityManagerFactory entityManagerFactory, DataSource dataSource) {
            JpaTransactionManager jpaTransactionManager = new JpaTransactionManager(entityManagerFactory);
            jpaTransactionManager.setDataSource(dataSource);
            return jpaTransactionManager;
        }

        @Bean
        public PersistenceAnnotationBeanPostProcessor persistenceAnnotationBeanPostProcessor() {
            return new PersistenceAnnotationBeanPostProcessor();
        }

        @Configuration
        public static class PersistenceConfig {
            @PersistenceContext
            private EntityManager entityManager;

            @Bean
            public EntityManagerProvider entityManagerProvider() {
                return new SimpleEntityManagerProvider(this.entityManager);
            }
        }
    }
}

