/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.eventhandling.scheduling;

import java.time.Duration;
import javax.inject.Inject;
import org.axonframework.eventhandling.scheduling.EventScheduler;
import org.axonframework.modelling.saga.SagaEventHandler;
import org.axonframework.modelling.saga.StartSaga;
import org.axonframework.spring.eventhandling.scheduling.MySagaExpiredEvent;
import org.axonframework.spring.eventhandling.scheduling.StartingEvent;

public class SimpleTimingSaga {
    private transient EventScheduler timer;
    private volatile boolean triggered = false;
    private static final Duration SCHEDULE_DURATION = Duration.ofMillis(50L);

    @StartSaga
    @SagaEventHandler(associationProperty="association")
    public void handle(StartingEvent event) {
        this.timer.schedule(SCHEDULE_DURATION, (Object)new MySagaExpiredEvent(event.getAssociation()));
    }

    @SagaEventHandler(associationProperty="association")
    public void handle(MySagaExpiredEvent event) {
        this.triggered = true;
    }

    public boolean isTriggered() {
        return this.triggered;
    }

    @Inject
    public void setTimer(EventScheduler timer) {
        this.timer = timer;
    }
}

