/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.eventhandling.scheduling.java;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public class ResultStoringScheduledExecutorService
implements ScheduledExecutorService {
    private final ScheduledExecutorService delegate;
    private final List<Future<?>> results = new CopyOnWriteArrayList();

    public ResultStoringScheduledExecutorService(ScheduledExecutorService delegate) {
        this.delegate = delegate;
    }

    @Override
    public ScheduledFuture<?> schedule(@Nonnull Runnable command, long delay, @Nonnull TimeUnit unit) {
        ScheduledFuture<?> future = this.delegate.schedule(command, delay, unit);
        this.results.add(future);
        return future;
    }

    @Override
    public <V> ScheduledFuture<V> schedule(@Nonnull Callable<V> callable, long delay, @Nonnull TimeUnit unit) {
        ScheduledFuture<V> future = this.delegate.schedule(callable, delay, unit);
        this.results.add(future);
        return future;
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(@Nonnull Runnable command, long initialDelay, long period, @Nonnull TimeUnit unit) {
        return this.delegate.scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(@Nonnull Runnable command, long initialDelay, long delay, @Nonnull TimeUnit unit) {
        ScheduledFuture<?> future = this.delegate.scheduleWithFixedDelay(command, initialDelay, delay, unit);
        this.results.add(future);
        return future;
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, @Nonnull TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(@Nonnull Callable<T> task) {
        Future<T> future = this.delegate.submit(task);
        this.results.add(future);
        return future;
    }

    @Override
    public <T> Future<T> submit(@Nonnull Runnable task, T result) {
        Future<T> future = this.delegate.submit(task, result);
        this.results.add(future);
        return future;
    }

    @Override
    public Future<?> submit(@Nonnull Runnable task) {
        Future<?> future = this.delegate.submit(task);
        this.results.add(future);
        return future;
    }

    @Override
    public <T> List<Future<T>> invokeAll(@Nonnull Collection<? extends Callable<T>> tasks) throws InterruptedException {
        List futures = this.delegate.invokeAll(tasks);
        this.results.addAll(futures);
        return futures;
    }

    @Override
    public <T> List<Future<T>> invokeAll(@Nonnull Collection<? extends Callable<T>> tasks, long timeout, @Nonnull TimeUnit unit) throws InterruptedException {
        List futures = this.delegate.invokeAll(tasks, timeout, unit);
        this.results.addAll(futures);
        return futures;
    }

    @Override
    public <T> T invokeAny(@Nonnull Collection<? extends Callable<T>> tasks) {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    @Override
    public <T> T invokeAny(@Nonnull Collection<? extends Callable<T>> tasks, long timeout, @Nonnull TimeUnit unit) {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    @Override
    public void execute(@Nonnull Runnable command) {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    public List<Future<?>> getResults() {
        return this.results;
    }
}

