/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.eventhandling.scheduling.quartz;

import jakarta.annotation.PostConstruct;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class QuartzTableMaker
implements ApplicationContextAware {
    @PersistenceContext
    private EntityManager entityManager;
    private ApplicationContext applicationContext;
    private Resource sqlResource;
    private PlatformTransactionManager transactionManager;

    @Transactional
    @PostConstruct
    public void createTables() {
        new TransactionTemplate(this.transactionManager).execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(@Nonnull TransactionStatus status) {
                QuartzTableMaker.this.executeCreateSQL();
            }
        });
    }

    private void executeCreateSQL() {
        try {
            String script = IOUtils.toString((InputStream)this.sqlResource.getInputStream(), (Charset)Charset.defaultCharset());
            List<String> statements = Arrays.asList(script.split(";"));
            for (String statement : statements) {
                while (statement.trim().startsWith("#")) {
                    statement = statement.trim().split("\n", 2)[1];
                }
                if (statement.trim().length() <= 0) continue;
                this.entityManager.createNativeQuery(statement.trim()).executeUpdate();
            }
        }
        catch (IOException ex) {
            throw new DataAccessResourceFailureException("Failed to open SQL script '" + this.sqlResource + "'", (Throwable)ex);
        }
    }

    public void setSqlResource(Resource sqlResource) {
        this.sqlResource = sqlResource;
    }

    @Autowired
    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setApplicationContext(@Nonnull ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

