/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.eventhandling.tokenstore.jpa;

import java.time.Duration;
import java.time.temporal.TemporalAmount;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.spi.PersistenceProvider;
import org.axonframework.common.legacyjpa.EntityManagerProvider;
import org.axonframework.common.legacyjpa.SimpleEntityManagerProvider;
import org.axonframework.common.transaction.Transaction;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.eventhandling.tokenstore.jpa.TokenEntry;
import org.axonframework.eventhandling.tokenstore.legacyjpa.JpaTokenStore;
import org.axonframework.serialization.TestSerializer;
import org.hibernate.dialect.HSQLDialect;
import org.hibernate.jpa.HibernatePersistenceProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableMBeanExport;
import org.springframework.jmx.support.RegistrationPolicy;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit.jupiter.SpringExtension;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@ContextConfiguration
@ExtendWith(value={SpringExtension.class})
@EnableMBeanExport(registration=RegistrationPolicy.IGNORE_EXISTING)
class JpaTokenStoreTest {
    @Autowired
    @Qualifier(value="jpaTokenStore")
    private JpaTokenStore jpaTokenStore;
    @Autowired
    @Qualifier(value="stealingJpaTokenStore")
    private JpaTokenStore stealingJpaTokenStore;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private PlatformTransactionManager transactionManager;

    JpaTokenStoreTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    @Test
    void stealingFromOtherThreadFailsWithRowLock() throws Exception {
        this.jpaTokenStore.initializeTokenSegments("processor", 1);
        ExecutorService executor1 = Executors.newSingleThreadExecutor();
        CountDownLatch cdl = new CountDownLatch(1);
        try {
            this.jpaTokenStore.fetchToken("processor", 0);
            Future<?> result = executor1.submit(() -> {
                DefaultTransactionDefinition txDef = new DefaultTransactionDefinition();
                txDef.setPropagationBehavior(3);
                TransactionStatus tx = this.transactionManager.getTransaction((TransactionDefinition)txDef);
                cdl.countDown();
                try {
                    this.stealingJpaTokenStore.fetchToken("processor", 0);
                }
                finally {
                    this.transactionManager.rollback(tx);
                }
            });
            cdl.await();
            try {
                result.get(250L, TimeUnit.MILLISECONDS);
                Assertions.fail((String)"Expected task to time out on the write lock");
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
            Assertions.assertFalse((boolean)result.isDone());
            result.cancel(true);
            TokenEntry tokenEntry = (TokenEntry)this.entityManager.find(TokenEntry.class, (Object)new TokenEntry.PK("processor", 0));
            Assertions.assertEquals((Object)"local", (Object)tokenEntry.getOwner());
        }
        finally {
            executor1.shutdown();
        }
    }

    @Configuration
    public static class Context {
        @Bean
        public LocalContainerEntityManagerFactoryBean sessionFactory() {
            LocalContainerEntityManagerFactoryBean sessionFactory = new LocalContainerEntityManagerFactoryBean();
            sessionFactory.setPersistenceProvider((PersistenceProvider)new HibernatePersistenceProvider());
            sessionFactory.setPackagesToScan(new String[]{TokenEntry.class.getPackage().getName()});
            sessionFactory.setJpaPropertyMap(Collections.singletonMap("hibernate.dialect", new HSQLDialect()));
            sessionFactory.setJpaPropertyMap(Collections.singletonMap("hibernate.hbm2ddl.auto", "create-drop"));
            sessionFactory.setJpaPropertyMap(Collections.singletonMap("hibernate.show_sql", "false"));
            sessionFactory.setJpaPropertyMap(Collections.singletonMap("hibernate.connection.url", "jdbc:hsqldb:mem:testdb"));
            return sessionFactory;
        }

        @Bean
        public PlatformTransactionManager txManager() {
            return new JpaTransactionManager();
        }

        @Bean
        public JpaTokenStore jpaTokenStore(EntityManagerProvider entityManagerProvider) {
            return JpaTokenStore.builder().entityManagerProvider(entityManagerProvider).serializer(TestSerializer.XSTREAM.getSerializer()).nodeId("local").build();
        }

        @Bean
        public JpaTokenStore stealingJpaTokenStore(EntityManagerProvider entityManagerProvider) {
            return JpaTokenStore.builder().entityManagerProvider(entityManagerProvider).serializer(TestSerializer.XSTREAM.getSerializer()).claimTimeout((TemporalAmount)Duration.ofSeconds(-1L)).nodeId("stealing").build();
        }

        @Bean
        public TransactionManager transactionManager(final PlatformTransactionManager txManager) {
            return () -> {
                final TransactionStatus transaction = txManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition());
                return new Transaction(){

                    public void commit() {
                        txManager.commit(transaction);
                    }

                    public void rollback() {
                        txManager.rollback(transaction);
                    }
                };
            };
        }

        @Configuration
        public static class PersistenceConfig {
            @PersistenceContext
            private EntityManager entityManager;

            @Bean
            public EntityManagerProvider entityManagerProvider() {
                return new SimpleEntityManagerProvider(this.entityManager);
            }
        }
    }
}

