/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.eventsourcing;

import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executor;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.GenericDomainEventMessage;
import org.axonframework.eventsourcing.AbstractAggregateFactory;
import org.axonframework.eventsourcing.AggregateFactory;
import org.axonframework.eventsourcing.EventSourcingRepository;
import org.axonframework.eventsourcing.eventstore.DomainEventStream;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.axonframework.messaging.MetaData;
import org.axonframework.modelling.command.RepositoryProvider;
import org.axonframework.spring.config.annotation.StubAggregate;
import org.axonframework.spring.eventsourcing.SpringAggregateSnapshotter;
import org.axonframework.spring.eventsourcing.SpringAggregateSnapshotterFactoryBean;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.context.ApplicationContext;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.SimpleTransactionStatus;

class SpringAggregateSnapshotterFactoryBeanTest {
    private SpringAggregateSnapshotterFactoryBean testSubject;
    private PlatformTransactionManager mockTransactionManager;
    private String aggregateIdentifier;
    private EventStore mockEventStore;
    private RepositoryProvider mockRepositoryProvider;
    private ApplicationContext mockApplicationContext;
    private Executor executor;

    SpringAggregateSnapshotterFactoryBeanTest() {
    }

    @BeforeEach
    void setUp() {
        this.mockApplicationContext = (ApplicationContext)Mockito.mock(ApplicationContext.class);
        this.mockEventStore = (EventStore)Mockito.mock(EventStore.class);
        this.mockRepositoryProvider = (RepositoryProvider)Mockito.mock(RepositoryProvider.class);
        this.executor = (Executor)Mockito.spy((Object)new MockExecutor());
        this.testSubject = new SpringAggregateSnapshotterFactoryBean();
        this.testSubject.setApplicationContext(this.mockApplicationContext);
        this.testSubject.setExecutor(this.executor);
        Mockito.when((Object)this.mockApplicationContext.getBeansOfType(AggregateFactory.class)).thenReturn(Collections.singletonMap("myFactory", new AbstractAggregateFactory<StubAggregate>(StubAggregate.class){

            public StubAggregate doCreateAggregate(String aggregateIdentifier, DomainEventMessage firstEvent) {
                return new StubAggregate(aggregateIdentifier);
            }
        }));
        this.testSubject.setEventStore(this.mockEventStore);
        this.testSubject.setRepositoryProvider(this.mockRepositoryProvider);
        this.mockTransactionManager = (PlatformTransactionManager)Mockito.mock(PlatformTransactionManager.class);
        this.aggregateIdentifier = UUID.randomUUID().toString();
        String type = "testAggregate";
        GenericDomainEventMessage event1 = new GenericDomainEventMessage(type, this.aggregateIdentifier, 0L, (Object)"Mock contents", (Map)MetaData.emptyInstance());
        GenericDomainEventMessage event2 = new GenericDomainEventMessage(type, this.aggregateIdentifier, 1L, (Object)"Mock contents", (Map)MetaData.emptyInstance());
        Mockito.when((Object)this.mockEventStore.readEvents(this.aggregateIdentifier)).thenReturn((Object)DomainEventStream.of((DomainEventMessage[])new DomainEventMessage[]{event1, event2}));
    }

    @Test
    void snapshotCreatedNoTransaction() {
        SpringAggregateSnapshotter snapshotter = this.testSubject.getObject();
        snapshotter.scheduleSnapshot(StubAggregate.class, this.aggregateIdentifier);
        ((EventStore)Mockito.verify((Object)this.mockEventStore)).storeSnapshot(this.eventSequence(1L));
        ((Executor)Mockito.verify((Object)this.executor)).execute((Runnable)Mockito.any());
    }

    @Test
    void retrieveAggregateFactoryFromRepositoryIfNotExplicitlyAvailable() {
        this.testSubject.setEventStore(null);
        Mockito.reset((Object[])new ApplicationContext[]{this.mockApplicationContext});
        Mockito.when((Object)this.mockApplicationContext.getBean(EventStore.class)).thenReturn((Object)this.mockEventStore);
        Mockito.when((Object)this.mockApplicationContext.getBeansOfType(EventSourcingRepository.class)).thenReturn(Collections.singletonMap("myRepository", EventSourcingRepository.builder(StubAggregate.class).eventStore(this.mockEventStore).repositoryProvider(this.mockRepositoryProvider).build()));
        this.snapshotCreatedNoTransaction();
    }

    @Test
    void snapshotCreatedNewlyCreatedTransactionCommitted() {
        this.testSubject.setTransactionManager(this.mockTransactionManager);
        SpringAggregateSnapshotter snapshotter = this.testSubject.getObject();
        SimpleTransactionStatus newlyCreatedTransaction = new SimpleTransactionStatus(true);
        Mockito.when((Object)this.mockTransactionManager.getTransaction((TransactionDefinition)Mockito.isA(TransactionDefinition.class))).thenReturn((Object)newlyCreatedTransaction);
        snapshotter.scheduleSnapshot(StubAggregate.class, this.aggregateIdentifier);
        ((EventStore)Mockito.verify((Object)this.mockEventStore)).storeSnapshot(this.eventSequence(1L));
        ((PlatformTransactionManager)Mockito.verify((Object)this.mockTransactionManager)).commit((TransactionStatus)newlyCreatedTransaction);
    }

    @Test
    void snapshotCreatedExistingTransactionNotCommitted() {
        this.testSubject.setTransactionManager(this.mockTransactionManager);
        SpringAggregateSnapshotter snapshotter = this.testSubject.getObject();
        SimpleTransactionStatus existingTransaction = new SimpleTransactionStatus(false);
        Mockito.when((Object)this.mockTransactionManager.getTransaction((TransactionDefinition)Mockito.isA(TransactionDefinition.class))).thenReturn((Object)existingTransaction);
        snapshotter.scheduleSnapshot(StubAggregate.class, this.aggregateIdentifier);
        ((EventStore)Mockito.verify((Object)this.mockEventStore)).storeSnapshot(this.eventSequence(1L));
        ((PlatformTransactionManager)Mockito.verify((Object)this.mockTransactionManager, (VerificationMode)Mockito.never())).commit((TransactionStatus)existingTransaction);
    }

    @Test
    void snapshotCreatedExistingTransactionNotRolledBack() {
        this.testSubject.setTransactionManager(this.mockTransactionManager);
        SpringAggregateSnapshotter snapshotter = this.testSubject.getObject();
        SimpleTransactionStatus existingTransaction = new SimpleTransactionStatus(false);
        Mockito.when((Object)this.mockTransactionManager.getTransaction((TransactionDefinition)Mockito.isA(TransactionDefinition.class))).thenReturn((Object)existingTransaction);
        ((EventStore)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Stub")}).when((Object)this.mockEventStore)).storeSnapshot((DomainEventMessage)Mockito.isA(DomainEventMessage.class));
        snapshotter.scheduleSnapshot(StubAggregate.class, this.aggregateIdentifier);
        ((EventStore)Mockito.verify((Object)this.mockEventStore)).storeSnapshot(this.eventSequence(1L));
        ((PlatformTransactionManager)Mockito.verify((Object)this.mockTransactionManager, (VerificationMode)Mockito.never())).commit((TransactionStatus)existingTransaction);
        ((PlatformTransactionManager)Mockito.verify((Object)this.mockTransactionManager, (VerificationMode)Mockito.never())).rollback((TransactionStatus)existingTransaction);
    }

    @Test
    void snapshotCreatedNewTransactionRolledBack() {
        this.testSubject.setTransactionManager(this.mockTransactionManager);
        SpringAggregateSnapshotter snapshotter = this.testSubject.getObject();
        SimpleTransactionStatus existingTransaction = new SimpleTransactionStatus(true);
        Mockito.when((Object)this.mockTransactionManager.getTransaction((TransactionDefinition)Mockito.any())).thenReturn((Object)existingTransaction);
        ((EventStore)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Stub")}).when((Object)this.mockEventStore)).storeSnapshot((DomainEventMessage)Mockito.isA(DomainEventMessage.class));
        snapshotter.scheduleSnapshot(StubAggregate.class, this.aggregateIdentifier);
        ((EventStore)Mockito.verify((Object)this.mockEventStore)).storeSnapshot(this.eventSequence(1L));
        ((PlatformTransactionManager)Mockito.verify((Object)this.mockTransactionManager, (VerificationMode)Mockito.never())).commit((TransactionStatus)existingTransaction);
        ((PlatformTransactionManager)Mockito.verify((Object)this.mockTransactionManager)).rollback((TransactionStatus)existingTransaction);
    }

    private DomainEventMessage eventSequence(long sequenceNumber) {
        return (DomainEventMessage)Mockito.argThat(o -> o != null && o.getSequenceNumber() == sequenceNumber);
    }

    public static class MockExecutor
    implements Executor {
        @Override
        public void execute(Runnable command) {
            command.run();
        }
    }
}

