/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.eventsourcing;

import java.util.List;
import org.axonframework.config.Configurer;
import org.axonframework.config.ConfigurerModule;
import org.axonframework.config.ModuleConfiguration;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.GenericDomainEventMessage;
import org.axonframework.eventsourcing.AggregateFactory;
import org.axonframework.eventsourcing.eventstore.EmbeddedEventStore;
import org.axonframework.eventsourcing.eventstore.EventStorageEngine;
import org.axonframework.eventsourcing.eventstore.inmemory.InMemoryEventStorageEngine;
import org.axonframework.spring.config.SpringAggregateLookup;
import org.axonframework.spring.config.SpringAxonConfiguration;
import org.axonframework.spring.config.SpringConfigurer;
import org.axonframework.spring.eventsourcing.context.SpringWiredAggregate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(value={SpringExtension.class})
@ContextConfiguration(classes={Context.class})
class SpringPrototypeAggregateFactoryTest {
    @Autowired
    private AggregateFactory<SpringWiredAggregate> testSubject;

    SpringPrototypeAggregateFactoryTest() {
    }

    @Test
    void contextStarts() {
        Assertions.assertNotNull(this.testSubject);
    }

    @Test
    void createNewAggregateInstance() {
        GenericDomainEventMessage domainEvent = new GenericDomainEventMessage("SpringWiredAggregate", "id2", 0L, (Object)"FirstEvent");
        SpringWiredAggregate aggregate = (SpringWiredAggregate)this.testSubject.createAggregateRoot("id2", (DomainEventMessage)domainEvent);
        Assertions.assertNotNull((Object)aggregate.getContext(), (String)"ContextAware method not invoked");
    }

    @Test
    void processSnapshotAggregateInstance() {
        GenericDomainEventMessage snapshotEvent = new GenericDomainEventMessage("SpringWiredAggregate", "id2", 5L, (Object)new SpringWiredAggregate());
        SpringWiredAggregate aggregate = (SpringWiredAggregate)this.testSubject.createAggregateRoot("id2", (DomainEventMessage)snapshotEvent);
        Assertions.assertNotNull((Object)aggregate.getContext(), (String)"ContextAware method not invoked");
    }

    @Configuration
    @ComponentScan(basePackages={"org.axonframework.spring.eventsourcing.context"})
    static class Context {
        Context() {
        }

        @Bean
        public EmbeddedEventStore eventStore() {
            return EmbeddedEventStore.builder().storageEngine((EventStorageEngine)new InMemoryEventStorageEngine()).build();
        }

        @Bean
        public static SpringAggregateLookup springAggregateLookup() {
            return new SpringAggregateLookup();
        }

        @Bean
        public SpringAxonConfiguration springAxonConfiguration(Configurer configurer) {
            return new SpringAxonConfiguration(configurer);
        }

        @Bean
        public SpringConfigurer springAxonConfigurer(ConfigurableListableBeanFactory beanFactory, List<ConfigurerModule> configurerModules, List<ModuleConfiguration> moduleConfigurations) {
            SpringConfigurer configurer = new SpringConfigurer(beanFactory);
            moduleConfigurations.forEach(arg_0 -> ((SpringConfigurer)configurer).registerModule(arg_0));
            configurerModules.forEach(c -> c.configureModule((Configurer)configurer));
            return configurer;
        }
    }
}

