/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.jdbc;

import java.sql.Connection;
import javax.sql.DataSource;
import org.axonframework.common.jdbc.ConnectionProvider;
import org.axonframework.common.jdbc.UnitOfWorkAwareConnectionProviderWrapper;
import org.axonframework.common.transaction.Transaction;
import org.axonframework.messaging.unitofwork.DefaultUnitOfWork;
import org.axonframework.spring.jdbc.SpringDataSourceConnectionProvider;
import org.axonframework.spring.messaging.unitofwork.SpringTransactionManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableMBeanExport;
import org.springframework.jdbc.datasource.DriverManagerDataSource;
import org.springframework.jdbc.support.JdbcTransactionManager;
import org.springframework.jmx.support.RegistrationPolicy;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit.jupiter.SpringExtension;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;

@ExtendWith(value={SpringExtension.class})
@ContextConfiguration(classes={Context.class})
@EnableMBeanExport(registration=RegistrationPolicy.IGNORE_EXISTING)
class SpringDataSourceConnectionProviderTest {
    private Connection mockConnection;
    @Autowired
    private DataSource dataSource;
    @Autowired
    private PlatformTransactionManager transactionManager;
    @Autowired
    private ConnectionProvider connectionProvider;
    private SpringTransactionManager springTransactionManager;

    SpringDataSourceConnectionProviderTest() {
    }

    @BeforeEach
    void setUp() {
        this.springTransactionManager = new SpringTransactionManager(this.transactionManager);
    }

    @DirtiesContext
    @Transactional
    @Test
    void connectionNotCommittedWhenTransactionScopeOutsideUnitOfWork() throws Exception {
        Mockito.when((Object)this.dataSource.getConnection()).thenAnswer(invocation -> {
            Assertions.fail((String)"Should be using an already existing connection.");
            return null;
        });
        DefaultUnitOfWork uow = DefaultUnitOfWork.startAndGet(null);
        Connection connection = this.connectionProvider.getConnection();
        connection.commit();
        uow.commit();
    }

    @Test
    void connectionCommittedWhenTransactionScopeInsideUnitOfWork() throws Exception {
        ((DataSource)Mockito.doAnswer(invocation -> {
            Object spy = Mockito.spy((Object)invocation.callRealMethod());
            this.mockConnection = (Connection)spy;
            return spy;
        }).when((Object)this.dataSource)).getConnection();
        DefaultUnitOfWork uow = DefaultUnitOfWork.startAndGet(null);
        Transaction transaction = this.springTransactionManager.startTransaction();
        uow.onCommit(u -> transaction.commit());
        uow.onRollback(u -> transaction.rollback());
        Connection innerConnection = this.connectionProvider.getConnection();
        Assertions.assertNotSame((Object)innerConnection, (Object)this.mockConnection);
        innerConnection.commit();
        ((Connection)Mockito.verify((Object)this.mockConnection, (VerificationMode)Mockito.never())).commit();
        uow.commit();
        ((Connection)Mockito.verify((Object)this.mockConnection)).commit();
    }

    @Configuration
    static class Context {
        Context() {
        }

        @Bean
        public DataSource dataSource() {
            DriverManagerDataSource dataSource = new DriverManagerDataSource();
            dataSource.setUrl("jdbc:hsqldb:mem:axontest");
            dataSource.setUsername("sa");
            dataSource.setPassword("");
            dataSource.setDriverClassName("org.hsqldb.jdbcDriver");
            return (DataSource)Mockito.spy((Object)dataSource);
        }

        @Bean
        public PlatformTransactionManager platformTransactionManager(DataSource dataSource) {
            return new JdbcTransactionManager(dataSource);
        }

        @Bean
        public ConnectionProvider connectionProvider(DataSource dataSource) {
            return new UnitOfWorkAwareConnectionProviderWrapper((ConnectionProvider)new SpringDataSourceConnectionProvider(dataSource));
        }
    }
}

