/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.messaging;

import java.util.ArrayList;
import java.util.List;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.eventhandling.SimpleEventBus;
import org.axonframework.messaging.SubscribableMessageSource;
import org.axonframework.spring.messaging.ApplicationContextEventPublisher;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.PayloadApplicationEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableMBeanExport;
import org.springframework.context.event.EventListener;
import org.springframework.jmx.support.RegistrationPolicy;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(value={SpringExtension.class})
@ContextConfiguration
@EnableMBeanExport(registration=RegistrationPolicy.IGNORE_EXISTING)
public class ApplicationContextEventPublisherTest {
    @Autowired
    private ListenerBean listenerBean;
    @Autowired
    private EventBus eventBus;

    @Test
    void eventsForwardedToListenerBean() {
        this.eventBus.publish(new EventMessage[]{GenericEventMessage.asEventMessage((Object)"test")});
        Assertions.assertEquals((Object)"test", (Object)this.listenerBean.getEvents().get(0));
    }

    public static class ListenerBean {
        private List<Object> events = new ArrayList<Object>();

        @EventListener
        public void handle(PayloadApplicationEvent<String> event) {
            this.events.add(event.getPayload());
        }

        public List<Object> getEvents() {
            return this.events;
        }
    }

    @Configuration
    public static class Context {
        @Bean
        public ListenerBean listenerBean() {
            return new ListenerBean();
        }

        @Bean
        public EventBus eventBus() {
            return SimpleEventBus.builder().build();
        }

        @Bean
        public ApplicationContextEventPublisher publisher(EventBus eventBus) {
            return new ApplicationContextEventPublisher((SubscribableMessageSource)eventBus);
        }
    }
}

