/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.messaging;

import java.time.Instant;
import java.util.HashMap;
import java.util.UUID;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericDomainEventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.spring.messaging.DefaultEventMessageConverter;
import org.axonframework.spring.messaging.EventMessageConverter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class DefaultEventMessageConverterTest {
    private EventMessageConverter eventMessageConverter = new DefaultEventMessageConverter();

    DefaultEventMessageConverterTest() {
    }

    @Test
    void given_generic_event_message_when_converting_twice_then_resulting_event_should_be_the_same() {
        Instant instant = Instant.EPOCH;
        String id = UUID.randomUUID().toString();
        HashMap<String, Object> metaData = new HashMap<String, Object>();
        metaData.put("number", 100);
        metaData.put("string", "world");
        EventPayload payload = new EventPayload("hello");
        GenericEventMessage axonMessage = new GenericEventMessage(id, (Object)payload, metaData, instant);
        EventMessage convertedAxonMessage = this.eventMessageConverter.convertFromInboundMessage(this.eventMessageConverter.convertToOutboundMessage((EventMessage)axonMessage));
        Assertions.assertEquals((Object)instant, (Object)convertedAxonMessage.getTimestamp());
        Assertions.assertEquals((Object)100, (Object)convertedAxonMessage.getMetaData().get((Object)"number"));
        Assertions.assertEquals((Object)"world", (Object)convertedAxonMessage.getMetaData().get((Object)"string"));
        Assertions.assertEquals((Object)"hello", (Object)((EventPayload)convertedAxonMessage.getPayload()).name);
        Assertions.assertEquals((Object)id, (Object)convertedAxonMessage.getIdentifier());
    }

    @Test
    void given_domain_event_message_when_converting_twice_then_resulting_event_should_be_the_same() {
        Instant instant = Instant.EPOCH;
        String id = UUID.randomUUID().toString();
        String aggId = UUID.randomUUID().toString();
        HashMap<String, Object> metaData = new HashMap<String, Object>();
        metaData.put("number", 100);
        metaData.put("string", "world");
        EventPayload payload = new EventPayload("hello");
        GenericDomainEventMessage axonMessage = new GenericDomainEventMessage("foo", aggId, 1L, (Object)payload, metaData, id, instant);
        EventMessage convertedAxonMessage = this.eventMessageConverter.convertFromInboundMessage(this.eventMessageConverter.convertToOutboundMessage((EventMessage)axonMessage));
        Assertions.assertTrue((boolean)(convertedAxonMessage instanceof DomainEventMessage));
        DomainEventMessage convertDomainMessage = (DomainEventMessage)convertedAxonMessage;
        Assertions.assertEquals((Object)instant, (Object)convertDomainMessage.getTimestamp());
        Assertions.assertEquals((Object)100, (Object)convertDomainMessage.getMetaData().get((Object)"number"));
        Assertions.assertEquals((Object)"world", (Object)convertDomainMessage.getMetaData().get((Object)"string"));
        Assertions.assertEquals((Object)"hello", (Object)((EventPayload)convertDomainMessage.getPayload()).name);
        Assertions.assertEquals((Object)id, (Object)convertDomainMessage.getIdentifier());
        Assertions.assertEquals((Object)"foo", (Object)convertDomainMessage.getType());
        Assertions.assertEquals((Object)aggId, (Object)convertDomainMessage.getAggregateIdentifier());
        Assertions.assertEquals((long)1L, (long)convertDomainMessage.getSequenceNumber());
    }

    private class EventPayload {
        private final String name;

        EventPayload(String name) {
            this.name = name;
        }
    }
}

