/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.spring.messaging;

import java.util.Collections;
import java.util.function.Consumer;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.messaging.SubscribableMessageSource;
import org.axonframework.spring.messaging.OutboundEventMessageChannelAdapter;
import org.axonframework.spring.utils.StubDomainEvent;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;

class OutboundEventMessageChannelAdapterTest {
    private OutboundEventMessageChannelAdapter testSubject;
    private EventBus mockEventBus;
    private MessageChannel mockChannel;

    OutboundEventMessageChannelAdapterTest() {
    }

    @BeforeEach
    void setUp() {
        this.mockEventBus = (EventBus)Mockito.mock(EventBus.class);
        this.mockChannel = (MessageChannel)Mockito.mock(MessageChannel.class);
        this.testSubject = new OutboundEventMessageChannelAdapter((SubscribableMessageSource)this.mockEventBus, this.mockChannel);
    }

    @Test
    void messageForwardedToChannel() {
        StubDomainEvent event = new StubDomainEvent();
        this.testSubject.handle(Collections.singletonList(new GenericEventMessage((Object)event)));
        ((MessageChannel)Mockito.verify((Object)this.mockChannel)).send(this.messageWithPayload(event));
    }

    @Test
    void eventListenerRegisteredOnInit() {
        ((EventBus)Mockito.verify((Object)this.mockEventBus, (VerificationMode)Mockito.never())).subscribe((Consumer)Mockito.any());
        this.testSubject.afterPropertiesSet();
        ((EventBus)Mockito.verify((Object)this.mockEventBus)).subscribe((Consumer)Mockito.any());
    }

    @Test
    void filterBlocksEvents() {
        this.testSubject = new OutboundEventMessageChannelAdapter((SubscribableMessageSource)this.mockEventBus, this.mockChannel, m -> !m.getPayloadType().isAssignableFrom(Class.class));
        this.testSubject.handle(Collections.singletonList(this.newDomainEvent()));
        ((EventBus)Mockito.verify((Object)this.mockEventBus, (VerificationMode)Mockito.never())).publish(new EventMessage[]{(EventMessage)Mockito.isA(EventMessage.class)});
    }

    private EventMessage<String> newDomainEvent() {
        return new GenericEventMessage((Object)"Mock");
    }

    private Message<?> messageWithPayload(StubDomainEvent event) {
        return (Message)Mockito.argThat(x -> event.equals(x.getPayload()));
    }
}

